/**
 * Framework7 4.4.3
 * Full featured mobile HTML framework for building iOS & Android apps
 * http://framework7.io/
 *
 * Copyright 2014-2019 Vladimir Kharlampidi
 *
 * Released under the MIT License
 *
 * Released on: June 4, 2019
 */

!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?module.exports=t():"function"==typeof define&&define.amd?define(t):(e=e||self).Framework7=t()}(this,function(){"use strict";var t7ctx;t7ctx="undefined"!=typeof window?window:"undefined"!=typeof global?global:void 0;var Template7Context=t7ctx,Template7Utils={quoteSingleRexExp:new RegExp("'","g"),quoteDoubleRexExp:new RegExp('"',"g"),isFunction:function(e){return"function"==typeof e},escape:function(e){return void 0===e&&(e=""),e.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;").replace(/'/g,"&#039;")},helperToSlices:function(e){var t,r,a,n=Template7Utils.quoteDoubleRexExp,o=Template7Utils.quoteSingleRexExp,i=e.replace(/[{}#}]/g,"").trim().split(" "),s=[];for(r=0;r<i.length;r+=1){var l=i[r],c=void 0,u=void 0;if(0===r)s.push(l);else if(0===l.indexOf('"')||0===l.indexOf("'"))if(c=0===l.indexOf('"')?n:o,u=0===l.indexOf('"')?'"':"'",2===l.match(c).length)s.push(l);else{for(t=0,a=r+1;a<i.length;a+=1)if(l+=" "+i[a],i[a].indexOf(u)>=0){t=a,s.push(l);break}t&&(r=t)}else if(l.indexOf("=")>0){var p=l.split("="),d=p[0],h=p[1];if(c||(c=0===h.indexOf('"')?n:o,u=0===h.indexOf('"')?'"':"'"),2!==h.match(c).length){for(t=0,a=r+1;a<i.length;a+=1)if(h+=" "+i[a],i[a].indexOf(u)>=0){t=a;break}t&&(r=t)}var f=[d,h.replace(c,"")];s.push(f)}else s.push(l)}return s},stringToBlocks:function(e){var t,r,a=[];if(!e)return[];var n=e.split(/({{[^{^}]*}})/);for(t=0;t<n.length;t+=1){var o=n[t];if(""!==o)if(o.indexOf("{{")<0)a.push({type:"plain",content:o});else{if(o.indexOf("{/")>=0)continue;if((o=o.replace(/{{([#\/])*([ ])*/,"{{$1").replace(/([ ])*}}/,"}}")).indexOf("{#")<0&&o.indexOf(" ")<0&&o.indexOf("else")<0){a.push({type:"variable",contextName:o.replace(/[{}]/g,"")});continue}var i=Template7Utils.helperToSlices(o),s=i[0],l=">"===s,c=[],u={};for(r=1;r<i.length;r+=1){var p=i[r];Array.isArray(p)?u[p[0]]="false"!==p[1]&&p[1]:c.push(p)}if(o.indexOf("{#")>=0){var d="",h="",f=0,v=void 0,m=!1,g=!1,b=0;for(r=t+1;r<n.length;r+=1)if(n[r].indexOf("{{#")>=0&&(b+=1),n[r].indexOf("{{/")>=0&&(b-=1),n[r].indexOf("{{#"+s)>=0)d+=n[r],g&&(h+=n[r]),f+=1;else if(n[r].indexOf("{{/"+s)>=0){if(!(f>0)){v=r,m=!0;break}f-=1,d+=n[r],g&&(h+=n[r])}else n[r].indexOf("else")>=0&&0===b?g=!0:(g||(d+=n[r]),g&&(h+=n[r]));m&&(v&&(t=v),"raw"===s?a.push({type:"plain",content:d}):a.push({type:"helper",helperName:s,contextName:c,content:d,inverseContent:h,hash:u}))}else o.indexOf(" ")>0&&(l&&(s="_partial",c[0]&&(0===c[0].indexOf("[")?c[0]=c[0].replace(/[[\]]/g,""):c[0]='"'+c[0].replace(/"|'/g,"")+'"')),a.push({type:"helper",helperName:s,contextName:c,hash:u}))}}return a},parseJsVariable:function(e,t,r){return e.split(/([+ \-*\/^()&=|<>!%:?])/g).reduce(function(e,a){if(!a)return e;if(a.indexOf(t)<0)return e.push(a),e;if(!r)return e.push(JSON.stringify("")),e;var n=r;return a.indexOf(t+".")>=0&&a.split(t+".")[1].split(".").forEach(function(e){n=e in n?n[e]:void 0}),"string"==typeof n&&(n=JSON.stringify(n)),void 0===n&&(n="undefined"),e.push(n),e},[]).join("")},parseJsParents:function(e,t){return e.split(/([+ \-*^()&=|<>!%:?])/g).reduce(function(e,r){if(!r)return e;if(r.indexOf("../")<0)return e.push(r),e;if(!t||0===t.length)return e.push(JSON.stringify("")),e;var a=r.split("../").length-1,n=a>t.length?t[t.length-1]:t[a-1];return r.replace(/..\//g,"").split(".").forEach(function(e){n=void 0!==n[e]?n[e]:"undefined"}),!1===n||!0===n?(e.push(JSON.stringify(n)),e):null===n||"undefined"===n?(e.push(JSON.stringify("")),e):(e.push(JSON.stringify(n)),e)},[]).join("")},getCompileVar:function(e,t,r){void 0===r&&(r="data_1");var a,n,o=t,i=0;0===e.indexOf("../")?(i=e.split("../").length-1,n=o.split("_")[1]-i,o="ctx_"+(n>=1?n:1),a=e.split("../")[i].split(".")):0===e.indexOf("@global")?(o="Template7.global",a=e.split("@global.")[1].split(".")):0===e.indexOf("@root")?(o="root",a=e.split("@root.")[1].split(".")):a=e.split(".");for(var s=0;s<a.length;s+=1){var l=a[s];if(0===l.indexOf("@")){var c=r.split("_")[1];i>0&&(c=n),s>0?o+="[(data_"+c+" && data_"+c+"."+l.replace("@","")+")]":o="(data_"+c+" && data_"+c+"."+l.replace("@","")+")"}else(Number.isFinite?Number.isFinite(l):Template7Context.isFinite(l))?o+="["+l+"]":"this"===l||l.indexOf("this.")>=0||l.indexOf("this[")>=0||l.indexOf("this(")>=0?o=l.replace("this",t):o+="."+l}return o},getCompiledArguments:function(e,t,r){for(var a=[],n=0;n<e.length;n+=1)/^['"]/.test(e[n])?a.push(e[n]):/^(true|false|\d+)$/.test(e[n])?a.push(e[n]):a.push(Template7Utils.getCompileVar(e[n],t,r));return a.join(", ")}},Template7Helpers={_partial:function(e,t){var r=this,a=Template7Class.partials[e];return!a||a&&!a.template?"":(a.compiled||(a.compiled=new Template7Class(a.template).compile()),Object.keys(t.hash).forEach(function(e){r[e]=t.hash[e]}),a.compiled(r,t.data,t.root))},escape:function(e){if("string"!=typeof e)throw new Error('Template7: Passed context to "escape" helper should be a string');return Template7Utils.escape(e)},if:function(e,t){var r=e;return Template7Utils.isFunction(r)&&(r=r.call(this)),r?t.fn(this,t.data):t.inverse(this,t.data)},unless:function(e,t){var r=e;return Template7Utils.isFunction(r)&&(r=r.call(this)),r?t.inverse(this,t.data):t.fn(this,t.data)},each:function(e,t){var r=e,a="",n=0;if(Template7Utils.isFunction(r)&&(r=r.call(this)),Array.isArray(r)){for(t.hash.reverse&&(r=r.reverse()),n=0;n<r.length;n+=1)a+=t.fn(r[n],{first:0===n,last:n===r.length-1,index:n});t.hash.reverse&&(r=r.reverse())}else for(var o in r)n+=1,a+=t.fn(r[o],{key:o});return n>0?a:t.inverse(this)},with:function(e,t){var r=e;return Template7Utils.isFunction(r)&&(r=e.call(this)),t.fn(r)},join:function(e,t){var r=e;return Template7Utils.isFunction(r)&&(r=r.call(this)),r.join(t.hash.delimiter||t.hash.delimeter)},js:function js(expression,options){var data=options.data,func,execute=expression;return"index first last key".split(" ").forEach(function(e){if(void 0!==data[e]){var t=new RegExp("this.@"+e,"g"),r=new RegExp("@"+e,"g");execute=execute.replace(t,JSON.stringify(data[e])).replace(r,JSON.stringify(data[e]))}}),options.root&&execute.indexOf("@root")>=0&&(execute=Template7Utils.parseJsVariable(execute,"@root",options.root)),execute.indexOf("@global")>=0&&(execute=Template7Utils.parseJsVariable(execute,"@global",Template7Context.Template7.global)),execute.indexOf("../")>=0&&(execute=Template7Utils.parseJsParents(execute,options.parents)),func=execute.indexOf("return")>=0?"(function(){"+execute+"})":"(function(){return ("+execute+")})",eval(func).call(this)},js_if:function js_if(expression,options){var data=options.data,func,execute=expression;"index first last key".split(" ").forEach(function(e){if(void 0!==data[e]){var t=new RegExp("this.@"+e,"g"),r=new RegExp("@"+e,"g");execute=execute.replace(t,JSON.stringify(data[e])).replace(r,JSON.stringify(data[e]))}}),options.root&&execute.indexOf("@root")>=0&&(execute=Template7Utils.parseJsVariable(execute,"@root",options.root)),execute.indexOf("@global")>=0&&(execute=Template7Utils.parseJsVariable(execute,"@global",Template7Context.Template7.global)),execute.indexOf("../")>=0&&(execute=Template7Utils.parseJsParents(execute,options.parents)),func=execute.indexOf("return")>=0?"(function(){"+execute+"})":"(function(){return ("+execute+")})";var condition=eval(func).call(this);return condition?options.fn(this,options.data):options.inverse(this,options.data)}};Template7Helpers.js_compare=Template7Helpers.js_if;var Template7Options={},Template7Partials={},Template7Class=function(e){this.template=e},staticAccessors={options:{configurable:!0},partials:{configurable:!0},helpers:{configurable:!0}};function Template7(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];var r=e[0],a=e[1];if(2===e.length){var n=new Template7Class(r),o=n.compile()(a);return n=null,o}return new Template7Class(r)}Template7Class.prototype.compile=function compile(template,depth){void 0===template&&(template=this.template),void 0===depth&&(depth=1);var t=this;if(t.compiled)return t.compiled;if("string"!=typeof template)throw new Error("Template7: Template must be a string");var stringToBlocks=Template7Utils.stringToBlocks,getCompileVar=Template7Utils.getCompileVar,getCompiledArguments=Template7Utils.getCompiledArguments,blocks=stringToBlocks(template),ctx="ctx_"+depth,data="data_"+depth;if(0===blocks.length)return function(){return""};function getCompileFn(e,r){return e.content?t.compile(e.content,r):function(){return""}}function getCompileInverse(e,r){return e.inverseContent?t.compile(e.inverseContent,r):function(){return""}}var resultString="",i;for(resultString+=1===depth?"(function ("+ctx+", "+data+", root) {\n":"(function ("+ctx+", "+data+") {\n",1===depth&&(resultString+="function isArray(arr){return Array.isArray(arr);}\n",resultString+="function isFunction(func){return (typeof func === 'function');}\n",resultString+='function c(val, ctx) {if (typeof val !== "undefined" && val !== null) {if (isFunction(val)) {return val.call(ctx);} else return val;} else return "";}\n',resultString+="root = root || ctx_1 || {};\n"),resultString+="var r = '';\n",i=0;i<blocks.length;i+=1){var block=blocks[i];if("plain"!==block.type){var variable=void 0,compiledArguments=void 0;if("variable"===block.type&&(variable=getCompileVar(block.contextName,ctx,data),resultString+="r += c("+variable+", "+ctx+");"),"helper"===block.type){var parents=void 0;if("ctx_1"!==ctx){for(var level=ctx.split("_")[1],parentsString="ctx_"+(level-1),j=level-2;j>=1;j-=1)parentsString+=", ctx_"+j;parents="["+parentsString+"]"}else parents="["+ctx+"]";var dynamicHelper=void 0;if(0===block.helperName.indexOf("[")&&(block.helperName=getCompileVar(block.helperName.replace(/[[\]]/g,""),ctx,data),dynamicHelper=!0),dynamicHelper||block.helperName in Template7Helpers)compiledArguments=getCompiledArguments(block.contextName,ctx,data),resultString+="r += (Template7Helpers"+(dynamicHelper?"["+block.helperName+"]":"."+block.helperName)+").call("+ctx+", "+(compiledArguments&&compiledArguments+", ")+"{hash:"+JSON.stringify(block.hash)+", data: "+data+" || {}, fn: "+getCompileFn(block,depth+1)+", inverse: "+getCompileInverse(block,depth+1)+", root: root, parents: "+parents+"});";else{if(block.contextName.length>0)throw new Error('Template7: Missing helper: "'+block.helperName+'"');variable=getCompileVar(block.helperName,ctx,data),resultString+="if ("+variable+") {",resultString+="if (isArray("+variable+")) {",resultString+="r += (Template7Helpers.each).call("+ctx+", "+variable+", {hash:"+JSON.stringify(block.hash)+", data: "+data+" || {}, fn: "+getCompileFn(block,depth+1)+", inverse: "+getCompileInverse(block,depth+1)+", root: root, parents: "+parents+"});",resultString+="}else {",resultString+="r += (Template7Helpers.with).call("+ctx+", "+variable+", {hash:"+JSON.stringify(block.hash)+", data: "+data+" || {}, fn: "+getCompileFn(block,depth+1)+", inverse: "+getCompileInverse(block,depth+1)+", root: root, parents: "+parents+"});",resultString+="}}"}}}else resultString+="r +='"+block.content.replace(/\r/g,"\\r").replace(/\n/g,"\\n").replace(/'/g,"\\'")+"';"}return resultString+="\nreturn r;})",1===depth?(t.compiled=eval(resultString),t.compiled):resultString},staticAccessors.options.get=function(){return Template7Options},staticAccessors.partials.get=function(){return Template7Partials},staticAccessors.helpers.get=function(){return Template7Helpers},Object.defineProperties(Template7Class,staticAccessors),Template7.registerHelper=function(e,t){Template7Class.helpers[e]=t},Template7.unregisterHelper=function(e){Template7Class.helpers[e]=void 0,delete Template7Class.helpers[e]},Template7.registerPartial=function(e,t){Template7Class.partials[e]={template:t}},Template7.unregisterPartial=function(e){Template7Class.partials[e]&&(Template7Class.partials[e]=void 0,delete Template7Class.partials[e])},Template7.compile=function(e,t){return new Template7Class(e,t).compile()},Template7.options=Template7Class.options,Template7.helpers=Template7Class.helpers,Template7.partials=Template7Class.partials;var doc="undefined"==typeof document?{body:{},addEventListener:function(){},removeEventListener:function(){},activeElement:{blur:function(){},nodeName:""},querySelector:function(){return null},querySelectorAll:function(){return[]},getElementById:function(){return null},createEvent:function(){return{initEvent:function(){}}},createElement:function(){return{children:[],childNodes:[],style:{},setAttribute:function(){},getElementsByTagName:function(){return[]}}},location:{hash:""}}:document,win="undefined"==typeof window?{document:doc,navigator:{userAgent:""},location:{},history:{},CustomEvent:function(){return this},addEventListener:function(){},removeEventListener:function(){},getComputedStyle:function(){return{getPropertyValue:function(){return""}}},Image:function(){},Date:function(){},screen:{},setTimeout:function(){},clearTimeout:function(){}}:window,Dom7=function(e){for(var t=0;t<e.length;t+=1)this[t]=e[t];return this.length=e.length,this};function $(e,t){var r=[],a=0;if(e&&!t&&e instanceof Dom7)return e;if(e)if("string"==typeof e){var n,o,i=e.trim();if(i.indexOf("<")>=0&&i.indexOf(">")>=0){var s="div";for(0===i.indexOf("<li")&&(s="ul"),0===i.indexOf("<tr")&&(s="tbody"),0!==i.indexOf("<td")&&0!==i.indexOf("<th")||(s="tr"),0===i.indexOf("<tbody")&&(s="table"),0===i.indexOf("<option")&&(s="select"),(o=doc.createElement(s)).innerHTML=i,a=0;a<o.childNodes.length;a+=1)r.push(o.childNodes[a])}else for(n=t||"#"!==e[0]||e.match(/[ .<>:~]/)?(t||doc).querySelectorAll(e.trim()):[doc.getElementById(e.trim().split("#")[1])],a=0;a<n.length;a+=1)n[a]&&r.push(n[a])}else if(e.nodeType||e===win||e===doc)r.push(e);else if(e.length>0&&e[0].nodeType)for(a=0;a<e.length;a+=1)r.push(e[a]);return new Dom7(r)}function unique(e){for(var t=[],r=0;r<e.length;r+=1)-1===t.indexOf(e[r])&&t.push(e[r]);return t}function toCamelCase(e){return e.toLowerCase().replace(/-(.)/g,function(e,t){return t.toUpperCase()})}function requestAnimationFrame(e){return win.requestAnimationFrame?win.requestAnimationFrame(e):win.webkitRequestAnimationFrame?win.webkitRequestAnimationFrame(e):win.setTimeout(e,1e3/60)}function cancelAnimationFrame(e){return win.cancelAnimationFrame?win.cancelAnimationFrame(e):win.webkitCancelAnimationFrame?win.webkitCancelAnimationFrame(e):win.clearTimeout(e)}function addClass(e){if(void 0===e)return this;for(var t=e.split(" "),r=0;r<t.length;r+=1)for(var a=0;a<this.length;a+=1)void 0!==this[a]&&void 0!==this[a].classList&&this[a].classList.add(t[r]);return this}function removeClass(e){for(var t=e.split(" "),r=0;r<t.length;r+=1)for(var a=0;a<this.length;a+=1)void 0!==this[a]&&void 0!==this[a].classList&&this[a].classList.remove(t[r]);return this}function hasClass(e){return!!this[0]&&this[0].classList.contains(e)}function toggleClass(e){for(var t=e.split(" "),r=0;r<t.length;r+=1)for(var a=0;a<this.length;a+=1)void 0!==this[a]&&void 0!==this[a].classList&&this[a].classList.toggle(t[r]);return this}function attr(e,t){var r=arguments;if(1===arguments.length&&"string"==typeof e)return this[0]?this[0].getAttribute(e):void 0;for(var a=0;a<this.length;a+=1)if(2===r.length)this[a].setAttribute(e,t);else for(var n in e)this[a][n]=e[n],this[a].setAttribute(n,e[n]);return this}function removeAttr(e){for(var t=0;t<this.length;t+=1)this[t].removeAttribute(e);return this}function prop(e,t){var r=arguments;if(1!==arguments.length||"string"!=typeof e){for(var a=0;a<this.length;a+=1)if(2===r.length)this[a][e]=t;else for(var n in e)this[a][n]=e[n];return this}if(this[0])return this[0][e]}function data(e,t){var r;if(void 0!==t){for(var a=0;a<this.length;a+=1)(r=this[a]).dom7ElementDataStorage||(r.dom7ElementDataStorage={}),r.dom7ElementDataStorage[e]=t;return this}if(r=this[0]){if(r.dom7ElementDataStorage&&e in r.dom7ElementDataStorage)return r.dom7ElementDataStorage[e];var n=r.getAttribute("data-"+e);return n||void 0}}function removeData(e){for(var t=0;t<this.length;t+=1){var r=this[t];r.dom7ElementDataStorage&&r.dom7ElementDataStorage[e]&&(r.dom7ElementDataStorage[e]=null,delete r.dom7ElementDataStorage[e])}}function dataset(){var e=this[0];if(e){var t={};if(e.dataset)for(var r in e.dataset)t[r]=e.dataset[r];else for(var a=0;a<e.attributes.length;a+=1){var n=e.attributes[a];n.name.indexOf("data-")>=0&&(t[toCamelCase(n.name.split("data-")[1])]=n.value)}for(var o in t)"false"===t[o]?t[o]=!1:"true"===t[o]?t[o]=!0:parseFloat(t[o])===1*t[o]&&(t[o]*=1);return t}}function val(e){if(void 0!==e){for(var t=0;t<this.length;t+=1){var r=this[t];if(Array.isArray(e)&&r.multiple&&"select"===r.nodeName.toLowerCase())for(var a=0;a<r.options.length;a+=1)r.options[a].selected=e.indexOf(r.options[a].value)>=0;else r.value=e}return this}if(this[0]){if(this[0].multiple&&"select"===this[0].nodeName.toLowerCase()){for(var n=[],o=0;o<this[0].selectedOptions.length;o+=1)n.push(this[0].selectedOptions[o].value);return n}return this[0].value}}function transform(e){for(var t=0;t<this.length;t+=1){var r=this[t].style;r.webkitTransform=e,r.transform=e}return this}function transition(e){"string"!=typeof e&&(e+="ms");for(var t=0;t<this.length;t+=1){var r=this[t].style;r.webkitTransitionDuration=e,r.transitionDuration=e}return this}function on(){for(var e,t=[],r=arguments.length;r--;)t[r]=arguments[r];var a=t[0],n=t[1],o=t[2],i=t[3];function s(e){var t=e.target;if(t){var r=e.target.dom7EventData||[];if(r.indexOf(e)<0&&r.unshift(e),$(t).is(n))o.apply(t,r);else for(var a=$(t).parents(),i=0;i<a.length;i+=1)$(a[i]).is(n)&&o.apply(a[i],r)}}function l(e){var t=e&&e.target&&e.target.dom7EventData||[];t.indexOf(e)<0&&t.unshift(e),o.apply(this,t)}"function"==typeof t[1]&&(a=(e=t)[0],o=e[1],i=e[2],n=void 0),i||(i=!1);for(var c,u=a.split(" "),p=0;p<this.length;p+=1){var d=this[p];if(n)for(c=0;c<u.length;c+=1){var h=u[c];d.dom7LiveListeners||(d.dom7LiveListeners={}),d.dom7LiveListeners[h]||(d.dom7LiveListeners[h]=[]),d.dom7LiveListeners[h].push({listener:o,proxyListener:s}),d.addEventListener(h,s,i)}else for(c=0;c<u.length;c+=1){var f=u[c];d.dom7Listeners||(d.dom7Listeners={}),d.dom7Listeners[f]||(d.dom7Listeners[f]=[]),d.dom7Listeners[f].push({listener:o,proxyListener:l}),d.addEventListener(f,l,i)}}return this}function off(){for(var e,t=[],r=arguments.length;r--;)t[r]=arguments[r];var a=t[0],n=t[1],o=t[2],i=t[3];"function"==typeof t[1]&&(a=(e=t)[0],o=e[1],i=e[2],n=void 0),i||(i=!1);for(var s=a.split(" "),l=0;l<s.length;l+=1)for(var c=s[l],u=0;u<this.length;u+=1){var p=this[u],d=void 0;if(!n&&p.dom7Listeners?d=p.dom7Listeners[c]:n&&p.dom7LiveListeners&&(d=p.dom7LiveListeners[c]),d&&d.length)for(var h=d.length-1;h>=0;h-=1){var f=d[h];o&&f.listener===o?(p.removeEventListener(c,f.proxyListener,i),d.splice(h,1)):o&&f.listener&&f.listener.dom7proxy&&f.listener.dom7proxy===o?(p.removeEventListener(c,f.proxyListener,i),d.splice(h,1)):o||(p.removeEventListener(c,f.proxyListener,i),d.splice(h,1))}}return this}function once(){for(var e,t=[],r=arguments.length;r--;)t[r]=arguments[r];var a=this,n=t[0],o=t[1],i=t[2],s=t[3];function l(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];i.apply(this,e),a.off(n,o,l,s),l.dom7proxy&&delete l.dom7proxy}return"function"==typeof t[1]&&(n=(e=t)[0],i=e[1],s=e[2],o=void 0),l.dom7proxy=i,a.on(n,o,l,s)}function trigger(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];for(var r=e[0].split(" "),a=e[1],n=0;n<r.length;n+=1)for(var o=r[n],i=0;i<this.length;i+=1){var s=this[i],l=void 0;try{l=new win.CustomEvent(o,{detail:a,bubbles:!0,cancelable:!0})}catch(e){(l=doc.createEvent("Event")).initEvent(o,!0,!0),l.detail=a}s.dom7EventData=e.filter(function(e,t){return t>0}),s.dispatchEvent(l),s.dom7EventData=[],delete s.dom7EventData}return this}function transitionEnd(e){var t,r=["webkitTransitionEnd","transitionend"],a=this;function n(o){if(o.target===this)for(e.call(this,o),t=0;t<r.length;t+=1)a.off(r[t],n)}if(e)for(t=0;t<r.length;t+=1)a.on(r[t],n);return this}function animationEnd(e){var t,r=["webkitAnimationEnd","animationend"],a=this;function n(o){if(o.target===this)for(e.call(this,o),t=0;t<r.length;t+=1)a.off(r[t],n)}if(e)for(t=0;t<r.length;t+=1)a.on(r[t],n);return this}function width(){return this[0]===win?win.innerWidth:this.length>0?parseFloat(this.css("width")):null}function outerWidth(e){if(this.length>0){if(e){var t=this.styles();return this[0].offsetWidth+parseFloat(t.getPropertyValue("margin-right"))+parseFloat(t.getPropertyValue("margin-left"))}return this[0].offsetWidth}return null}function height(){return this[0]===win?win.innerHeight:this.length>0?parseFloat(this.css("height")):null}function outerHeight(e){if(this.length>0){if(e){var t=this.styles();return this[0].offsetHeight+parseFloat(t.getPropertyValue("margin-top"))+parseFloat(t.getPropertyValue("margin-bottom"))}return this[0].offsetHeight}return null}function offset(){if(this.length>0){var e=this[0],t=e.getBoundingClientRect(),r=doc.body,a=e.clientTop||r.clientTop||0,n=e.clientLeft||r.clientLeft||0,o=e===win?win.scrollY:e.scrollTop,i=e===win?win.scrollX:e.scrollLeft;return{top:t.top+o-a,left:t.left+i-n}}return null}function hide(){for(var e=0;e<this.length;e+=1)this[e].style.display="none";return this}function show(){for(var e=0;e<this.length;e+=1){var t=this[e];"none"===t.style.display&&(t.style.display=""),"none"===win.getComputedStyle(t,null).getPropertyValue("display")&&(t.style.display="block")}return this}function styles(){return this[0]?win.getComputedStyle(this[0],null):{}}function css(e,t){var r;if(1===arguments.length){if("string"!=typeof e){for(r=0;r<this.length;r+=1)for(var a in e)this[r].style[a]=e[a];return this}if(this[0])return win.getComputedStyle(this[0],null).getPropertyValue(e)}if(2===arguments.length&&"string"==typeof e){for(r=0;r<this.length;r+=1)this[r].style[e]=t;return this}return this}function toArray(){for(var e=[],t=0;t<this.length;t+=1)e.push(this[t]);return e}function each(e){if(!e)return this;for(var t=0;t<this.length;t+=1)if(!1===e.call(this[t],t,this[t]))return this;return this}function forEach(e){if(!e)return this;for(var t=0;t<this.length;t+=1)if(!1===e.call(this[t],this[t],t))return this;return this}function filter(e){for(var t=[],r=0;r<this.length;r+=1)e.call(this[r],r,this[r])&&t.push(this[r]);return new Dom7(t)}function map(e){for(var t=[],r=0;r<this.length;r+=1)t.push(e.call(this[r],r,this[r]));return new Dom7(t)}function html(e){if(void 0===e)return this[0]?this[0].innerHTML:void 0;for(var t=0;t<this.length;t+=1)this[t].innerHTML=e;return this}function text(e){if(void 0===e)return this[0]?this[0].textContent.trim():null;for(var t=0;t<this.length;t+=1)this[t].textContent=e;return this}function is(e){var t,r,a=this[0];if(!a||void 0===e)return!1;if("string"==typeof e){if(a.matches)return a.matches(e);if(a.webkitMatchesSelector)return a.webkitMatchesSelector(e);if(a.msMatchesSelector)return a.msMatchesSelector(e);for(t=$(e),r=0;r<t.length;r+=1)if(t[r]===a)return!0;return!1}if(e===doc)return a===doc;if(e===win)return a===win;if(e.nodeType||e instanceof Dom7){for(t=e.nodeType?[e]:e,r=0;r<t.length;r+=1)if(t[r]===a)return!0;return!1}return!1}function indexOf(e){for(var t=0;t<this.length;t+=1)if(this[t]===e)return t;return-1}function index(){var e,t=this[0];if(t){for(e=0;null!==(t=t.previousSibling);)1===t.nodeType&&(e+=1);return e}}function eq(e){if(void 0===e)return this;var t,r=this.length;return new Dom7(e>r-1?[]:e<0?(t=r+e)<0?[]:[this[t]]:[this[e]])}function append(){for(var e,t=[],r=arguments.length;r--;)t[r]=arguments[r];for(var a=0;a<t.length;a+=1){e=t[a];for(var n=0;n<this.length;n+=1)if("string"==typeof e){var o=doc.createElement("div");for(o.innerHTML=e;o.firstChild;)this[n].appendChild(o.firstChild)}else if(e instanceof Dom7)for(var i=0;i<e.length;i+=1)this[n].appendChild(e[i]);else this[n].appendChild(e)}return this}function appendTo(e){return $(e).append(this),this}function prepend(e){var t,r;for(t=0;t<this.length;t+=1)if("string"==typeof e){var a=doc.createElement("div");for(a.innerHTML=e,r=a.childNodes.length-1;r>=0;r-=1)this[t].insertBefore(a.childNodes[r],this[t].childNodes[0])}else if(e instanceof Dom7)for(r=0;r<e.length;r+=1)this[t].insertBefore(e[r],this[t].childNodes[0]);else this[t].insertBefore(e,this[t].childNodes[0]);return this}function prependTo(e){return $(e).prepend(this),this}function insertBefore(e){for(var t=$(e),r=0;r<this.length;r+=1)if(1===t.length)t[0].parentNode.insertBefore(this[r],t[0]);else if(t.length>1)for(var a=0;a<t.length;a+=1)t[a].parentNode.insertBefore(this[r].cloneNode(!0),t[a])}function insertAfter(e){for(var t=$(e),r=0;r<this.length;r+=1)if(1===t.length)t[0].parentNode.insertBefore(this[r],t[0].nextSibling);else if(t.length>1)for(var a=0;a<t.length;a+=1)t[a].parentNode.insertBefore(this[r].cloneNode(!0),t[a].nextSibling)}function next(e){return this.length>0?e?this[0].nextElementSibling&&$(this[0].nextElementSibling).is(e)?new Dom7([this[0].nextElementSibling]):new Dom7([]):this[0].nextElementSibling?new Dom7([this[0].nextElementSibling]):new Dom7([]):new Dom7([])}function nextAll(e){var t=[],r=this[0];if(!r)return new Dom7([]);for(;r.nextElementSibling;){var a=r.nextElementSibling;e?$(a).is(e)&&t.push(a):t.push(a),r=a}return new Dom7(t)}function prev(e){if(this.length>0){var t=this[0];return e?t.previousElementSibling&&$(t.previousElementSibling).is(e)?new Dom7([t.previousElementSibling]):new Dom7([]):t.previousElementSibling?new Dom7([t.previousElementSibling]):new Dom7([])}return new Dom7([])}function prevAll(e){var t=[],r=this[0];if(!r)return new Dom7([]);for(;r.previousElementSibling;){var a=r.previousElementSibling;e?$(a).is(e)&&t.push(a):t.push(a),r=a}return new Dom7(t)}function siblings(e){return this.nextAll(e).add(this.prevAll(e))}function parent(e){for(var t=[],r=0;r<this.length;r+=1)null!==this[r].parentNode&&(e?$(this[r].parentNode).is(e)&&t.push(this[r].parentNode):t.push(this[r].parentNode));return $(unique(t))}function parents(e){for(var t=[],r=0;r<this.length;r+=1)for(var a=this[r].parentNode;a;)e?$(a).is(e)&&t.push(a):t.push(a),a=a.parentNode;return $(unique(t))}function closest(e){var t=this;return void 0===e?new Dom7([]):(t.is(e)||(t=t.parents(e).eq(0)),t)}function find(e){for(var t=[],r=0;r<this.length;r+=1)for(var a=this[r].querySelectorAll(e),n=0;n<a.length;n+=1)t.push(a[n]);return new Dom7(t)}function children(e){for(var t=[],r=0;r<this.length;r+=1)for(var a=this[r].childNodes,n=0;n<a.length;n+=1)e?1===a[n].nodeType&&$(a[n]).is(e)&&t.push(a[n]):1===a[n].nodeType&&t.push(a[n]);return new Dom7(unique(t))}function remove(){for(var e=0;e<this.length;e+=1)this[e].parentNode&&this[e].parentNode.removeChild(this[e]);return this}function detach(){return this.remove()}function add(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];var r,a;for(r=0;r<e.length;r+=1){var n=$(e[r]);for(a=0;a<n.length;a+=1)this[this.length]=n[a],this.length+=1}return this}function empty(){for(var e=0;e<this.length;e+=1){var t=this[e];if(1===t.nodeType){for(var r=0;r<t.childNodes.length;r+=1)t.childNodes[r].parentNode&&t.childNodes[r].parentNode.removeChild(t.childNodes[r]);t.textContent=""}}return this}$.fn=Dom7.prototype,$.Class=Dom7,$.Dom7=Dom7;var Methods=Object.freeze({addClass:addClass,removeClass:removeClass,hasClass:hasClass,toggleClass:toggleClass,attr:attr,removeAttr:removeAttr,prop:prop,data:data,removeData:removeData,dataset:dataset,val:val,transform:transform,transition:transition,on:on,off:off,once:once,trigger:trigger,transitionEnd:transitionEnd,animationEnd:animationEnd,width:width,outerWidth:outerWidth,height:height,outerHeight:outerHeight,offset:offset,hide:hide,show:show,styles:styles,css:css,toArray:toArray,each:each,forEach:forEach,filter:filter,map:map,html:html,text:text,is:is,indexOf:indexOf,index:index,eq:eq,append:append,appendTo:appendTo,prepend:prepend,prependTo:prependTo,insertBefore:insertBefore,insertAfter:insertAfter,next:next,nextAll:nextAll,prev:prev,prevAll:prevAll,siblings:siblings,parent:parent,parents:parents,closest:closest,find:find,children:children,remove:remove,detach:detach,add:add,empty:empty});function scrollTo(){for(var e,t=[],r=arguments.length;r--;)t[r]=arguments[r];var a=t[0],n=t[1],o=t[2],i=t[3],s=t[4];return 4===t.length&&"function"==typeof i&&(s=i,a=(e=t)[0],n=e[1],o=e[2],s=e[3],i=e[4]),void 0===i&&(i="swing"),this.each(function(){var e,t,r,l,c,u,p,d,h=this,f=n>0||0===n,v=a>0||0===a;if(void 0===i&&(i="swing"),f&&(e=h.scrollTop,o||(h.scrollTop=n)),v&&(t=h.scrollLeft,o||(h.scrollLeft=a)),o){f&&(r=h.scrollHeight-h.offsetHeight,c=Math.max(Math.min(n,r),0)),v&&(l=h.scrollWidth-h.offsetWidth,u=Math.max(Math.min(a,l),0));var m=null;f&&c===e&&(f=!1),v&&u===t&&(v=!1),requestAnimationFrame(function r(a){void 0===a&&(a=(new Date).getTime()),null===m&&(m=a);var n,l=Math.max(Math.min((a-m)/o,1),0),g="linear"===i?l:.5-Math.cos(l*Math.PI)/2;f&&(p=e+g*(c-e)),v&&(d=t+g*(u-t)),f&&c>e&&p>=c&&(h.scrollTop=c,n=!0),f&&c<e&&p<=c&&(h.scrollTop=c,n=!0),v&&u>t&&d>=u&&(h.scrollLeft=u,n=!0),v&&u<t&&d<=u&&(h.scrollLeft=u,n=!0),n?s&&s():(f&&(h.scrollTop=p),v&&(h.scrollLeft=d),requestAnimationFrame(r))})}})}function scrollTop(){for(var e,t=[],r=arguments.length;r--;)t[r]=arguments[r];var a=t[0],n=t[1],o=t[2],i=t[3];3===t.length&&"function"==typeof o&&(a=(e=t)[0],n=e[1],i=e[2],o=e[3]);return void 0===a?this.length>0?this[0].scrollTop:null:this.scrollTo(void 0,a,n,o,i)}function scrollLeft(){for(var e,t=[],r=arguments.length;r--;)t[r]=arguments[r];var a=t[0],n=t[1],o=t[2],i=t[3];3===t.length&&"function"==typeof o&&(a=(e=t)[0],n=e[1],i=e[2],o=e[3]);return void 0===a?this.length>0?this[0].scrollLeft:null:this.scrollTo(a,void 0,n,o,i)}var Scroll=Object.freeze({scrollTo:scrollTo,scrollTop:scrollTop,scrollLeft:scrollLeft});function animate(e,t){var r,a=this,n={props:Object.assign({},e),params:Object.assign({duration:300,easing:"swing"},t),elements:a,animating:!1,que:[],easingProgress:function(e,t){return"swing"===e?.5-Math.cos(t*Math.PI)/2:"function"==typeof e?e(t):t},stop:function(){n.frameId&&cancelAnimationFrame(n.frameId),n.animating=!1,n.elements.each(function(e,t){delete t.dom7AnimateInstance}),n.que=[]},done:function(e){if(n.animating=!1,n.elements.each(function(e,t){delete t.dom7AnimateInstance}),e&&e(a),n.que.length>0){var t=n.que.shift();n.animate(t[0],t[1])}},animate:function(e,t){if(n.animating)return n.que.push([e,t]),n;var r=[];n.elements.each(function(t,a){var o,i,s,l,c;a.dom7AnimateInstance||(n.elements[t].dom7AnimateInstance=n),r[t]={container:a},Object.keys(e).forEach(function(n){o=win.getComputedStyle(a,null).getPropertyValue(n).replace(",","."),i=parseFloat(o),s=o.replace(i,""),l=parseFloat(e[n]),c=e[n]+s,r[t][n]={initialFullValue:o,initialValue:i,unit:s,finalValue:l,finalFullValue:c,currentValue:i}})});var o,i,s=null,l=0,c=0,u=!1;return n.animating=!0,n.frameId=requestAnimationFrame(function p(){var d,h;o=(new Date).getTime(),u||(u=!0,t.begin&&t.begin(a)),null===s&&(s=o),t.progress&&t.progress(a,Math.max(Math.min((o-s)/t.duration,1),0),s+t.duration-o<0?0:s+t.duration-o,s),r.forEach(function(a){var u=a;i||u.done||Object.keys(e).forEach(function(a){if(!i&&!u.done){d=Math.max(Math.min((o-s)/t.duration,1),0),h=n.easingProgress(t.easing,d);var p=u[a],f=p.initialValue,v=p.finalValue,m=p.unit;u[a].currentValue=f+h*(v-f);var g=u[a].currentValue;(v>f&&g>=v||v<f&&g<=v)&&(u.container.style[a]=v+m,(c+=1)===Object.keys(e).length&&(u.done=!0,l+=1),l===r.length&&(i=!0)),i?n.done(t.complete):u.container.style[a]=g+m}})}),i||(n.frameId=requestAnimationFrame(p))}),n}};if(0===n.elements.length)return a;for(var o=0;o<n.elements.length;o+=1)n.elements[o].dom7AnimateInstance?r=n.elements[o].dom7AnimateInstance:n.elements[o].dom7AnimateInstance=n;return r||(r=n),"stop"===e?r.stop():r.animate(n.props,n.params),a}function stop(){for(var e=0;e<this.length;e+=1)this[e].dom7AnimateInstance&&this[e].dom7AnimateInstance.stop()}var Animate=Object.freeze({animate:animate,stop:stop}),noTrigger="resize scroll".split(" ");function eventShortcut(e){for(var t,r=[],a=arguments.length-1;a-- >0;)r[a]=arguments[a+1];if(void 0===r[0]){for(var n=0;n<this.length;n+=1)noTrigger.indexOf(e)<0&&(e in this[n]?this[n][e]():$(this[n]).trigger(e));return this}return(t=this).on.apply(t,[e].concat(r))}function click(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["click"].concat(e))}function blur(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["blur"].concat(e))}function focus(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["focus"].concat(e))}function focusin(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["focusin"].concat(e))}function focusout(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["focusout"].concat(e))}function keyup(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["keyup"].concat(e))}function keydown(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["keydown"].concat(e))}function keypress(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["keypress"].concat(e))}function submit(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["submit"].concat(e))}function change(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["change"].concat(e))}function mousedown(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["mousedown"].concat(e))}function mousemove(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["mousemove"].concat(e))}function mouseup(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["mouseup"].concat(e))}function mouseenter(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["mouseenter"].concat(e))}function mouseleave(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["mouseleave"].concat(e))}function mouseout(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["mouseout"].concat(e))}function mouseover(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["mouseover"].concat(e))}function touchstart(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["touchstart"].concat(e))}function touchend(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["touchend"].concat(e))}function touchmove(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["touchmove"].concat(e))}function resize(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["resize"].concat(e))}function scroll(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["scroll"].concat(e))}var eventShortcuts=Object.freeze({click:click,blur:blur,focus:focus,focusin:focusin,focusout:focusout,keyup:keyup,keydown:keydown,keypress:keypress,submit:submit,change:change,mousedown:mousedown,mousemove:mousemove,mouseup:mouseup,mouseenter:mouseenter,mouseleave:mouseleave,mouseout:mouseout,mouseover:mouseover,touchstart:touchstart,touchend:touchend,touchmove:touchmove,resize:resize,scroll:scroll});[Methods,Scroll,Animate,eventShortcuts].forEach(function(e){Object.keys(e).forEach(function(t){$.fn[t]=e[t]})});var NEWTON_ITERATIONS=4,NEWTON_MIN_SLOPE=.001,SUBDIVISION_PRECISION=1e-7,SUBDIVISION_MAX_ITERATIONS=10,kSplineTableSize=11,kSampleStepSize=1/(kSplineTableSize-1),float32ArraySupported="function"==typeof Float32Array;function A(e,t){return 1-3*t+3*e}function B(e,t){return 3*t-6*e}function C(e){return 3*e}function calcBezier(e,t,r){return((A(t,r)*e+B(t,r))*e+C(t))*e}function getSlope(e,t,r){return 3*A(t,r)*e*e+2*B(t,r)*e+C(t)}function binarySubdivide(e,t,r,a,n){var o,i,s=0;do{(o=calcBezier(i=t+(r-t)/2,a,n)-e)>0?r=i:t=i}while(Math.abs(o)>SUBDIVISION_PRECISION&&++s<SUBDIVISION_MAX_ITERATIONS);return i}function newtonRaphsonIterate(e,t,r,a){for(var n=0;n<NEWTON_ITERATIONS;++n){var o=getSlope(t,r,a);if(0===o)return t;t-=(calcBezier(t,r,a)-e)/o}return t}function bezier(e,t,r,a){if(!(0<=e&&e<=1&&0<=r&&r<=1))throw new Error("bezier x values must be in [0, 1] range");var n=float32ArraySupported?new Float32Array(kSplineTableSize):new Array(kSplineTableSize);if(e!==t||r!==a)for(var o=0;o<kSplineTableSize;++o)n[o]=calcBezier(o*kSampleStepSize,e,r);return function(o){return e===t&&r===a?o:0===o?0:1===o?1:calcBezier(function(t){for(var a=0,o=1,i=kSplineTableSize-1;o!==i&&n[o]<=t;++o)a+=kSampleStepSize;var s=a+(t-n[--o])/(n[o+1]-n[o])*kSampleStepSize,l=getSlope(s,e,r);return l>=NEWTON_MIN_SLOPE?newtonRaphsonIterate(t,s,e,r):0===l?s:binarySubdivide(t,a,a+kSampleStepSize,e,r)}(o),t,a)}}for(var defaultDiacriticsRemovalap=[{base:"A",letters:"AⒶＡÀÁÂẦẤẪẨÃĀĂẰẮẴẲȦǠÄǞẢÅǺǍȀȂẠẬẶḀĄȺⱯ"},{base:"AA",letters:"Ꜳ"},{base:"AE",letters:"ÆǼǢ"},{base:"AO",letters:"Ꜵ"},{base:"AU",letters:"Ꜷ"},{base:"AV",letters:"ꜸꜺ"},{base:"AY",letters:"Ꜽ"},{base:"B",letters:"BⒷＢḂḄḆɃƂƁ"},{base:"C",letters:"CⒸＣĆĈĊČÇḈƇȻꜾ"},{base:"D",letters:"DⒹＤḊĎḌḐḒḎĐƋƊƉꝹ"},{base:"DZ",letters:"ǱǄ"},{base:"Dz",letters:"ǲǅ"},{base:"E",letters:"EⒺＥÈÉÊỀẾỄỂẼĒḔḖĔĖËẺĚȄȆẸỆȨḜĘḘḚƐƎ"},{base:"F",letters:"FⒻＦḞƑꝻ"},{base:"G",letters:"GⒼＧǴĜḠĞĠǦĢǤƓꞠꝽꝾ"},{base:"H",letters:"HⒽＨĤḢḦȞḤḨḪĦⱧⱵꞍ"},{base:"I",letters:"IⒾＩÌÍÎĨĪĬİÏḮỈǏȈȊỊĮḬƗ"},{base:"J",letters:"JⒿＪĴɈ"},{base:"K",letters:"KⓀＫḰǨḲĶḴƘⱩꝀꝂꝄꞢ"},{base:"L",letters:"LⓁＬĿĹĽḶḸĻḼḺŁȽⱢⱠꝈꝆꞀ"},{base:"LJ",letters:"Ǉ"},{base:"Lj",letters:"ǈ"},{base:"M",letters:"MⓂＭḾṀṂⱮƜ"},{base:"N",letters:"NⓃＮǸŃÑṄŇṆŅṊṈȠƝꞐꞤ"},{base:"NJ",letters:"Ǌ"},{base:"Nj",letters:"ǋ"},{base:"O",letters:"OⓄＯÒÓÔỒỐỖỔÕṌȬṎŌṐṒŎȮȰÖȪỎŐǑȌȎƠỜỚỠỞỢỌỘǪǬØǾƆƟꝊꝌ"},{base:"OI",letters:"Ƣ"},{base:"OO",letters:"Ꝏ"},{base:"OU",letters:"Ȣ"},{base:"OE",letters:"Œ"},{base:"oe",letters:"œ"},{base:"P",letters:"PⓅＰṔṖƤⱣꝐꝒꝔ"},{base:"Q",letters:"QⓆＱꝖꝘɊ"},{base:"R",letters:"RⓇＲŔṘŘȐȒṚṜŖṞɌⱤꝚꞦꞂ"},{base:"S",letters:"SⓈＳẞŚṤŜṠŠṦṢṨȘŞⱾꞨꞄ"},{base:"T",letters:"TⓉＴṪŤṬȚŢṰṮŦƬƮȾꞆ"},{base:"TZ",letters:"Ꜩ"},{base:"U",letters:"UⓊＵÙÚÛŨṸŪṺŬÜǛǗǕǙỦŮŰǓȔȖƯỪỨỮỬỰỤṲŲṶṴɄ"},{base:"V",letters:"VⓋＶṼṾƲꝞɅ"},{base:"VY",letters:"Ꝡ"},{base:"W",letters:"WⓌＷẀẂŴẆẄẈⱲ"},{base:"X",letters:"XⓍＸẊẌ"},{base:"Y",letters:"YⓎＹỲÝŶỸȲẎŸỶỴƳɎỾ"},{base:"Z",letters:"ZⓏＺŹẐŻŽẒẔƵȤⱿⱫꝢ"},{base:"a",letters:"aⓐａẚàáâầấẫẩãāăằắẵẳȧǡäǟảåǻǎȁȃạậặḁąⱥɐ"},{base:"aa",letters:"ꜳ"},{base:"ae",letters:"æǽǣ"},{base:"ao",letters:"ꜵ"},{base:"au",letters:"ꜷ"},{base:"av",letters:"ꜹꜻ"},{base:"ay",letters:"ꜽ"},{base:"b",letters:"bⓑｂḃḅḇƀƃɓ"},{base:"c",letters:"cⓒｃćĉċčçḉƈȼꜿↄ"},{base:"d",letters:"dⓓｄḋďḍḑḓḏđƌɖɗꝺ"},{base:"dz",letters:"ǳǆ"},{base:"e",letters:"eⓔｅèéêềếễểẽēḕḗĕėëẻěȅȇẹệȩḝęḙḛɇɛǝ"},{base:"f",letters:"fⓕｆḟƒꝼ"},{base:"g",letters:"gⓖｇǵĝḡğġǧģǥɠꞡᵹꝿ"},{base:"h",letters:"hⓗｈĥḣḧȟḥḩḫẖħⱨⱶɥ"},{base:"hv",letters:"ƕ"},{base:"i",letters:"iⓘｉìíîĩīĭïḯỉǐȉȋịįḭɨı"},{base:"j",letters:"jⓙｊĵǰɉ"},{base:"k",letters:"kⓚｋḱǩḳķḵƙⱪꝁꝃꝅꞣ"},{base:"l",letters:"lⓛｌŀĺľḷḹļḽḻſłƚɫⱡꝉꞁꝇ"},{base:"lj",letters:"ǉ"},{base:"m",letters:"mⓜｍḿṁṃɱɯ"},{base:"n",letters:"nⓝｎǹńñṅňṇņṋṉƞɲŉꞑꞥ"},{base:"nj",letters:"ǌ"},{base:"o",letters:"oⓞｏòóôồốỗổõṍȭṏōṑṓŏȯȱöȫỏőǒȍȏơờớỡởợọộǫǭøǿɔꝋꝍɵ"},{base:"oi",letters:"ƣ"},{base:"ou",letters:"ȣ"},{base:"oo",letters:"ꝏ"},{base:"p",letters:"pⓟｐṕṗƥᵽꝑꝓꝕ"},{base:"q",letters:"qⓠｑɋꝗꝙ"},{base:"r",letters:"rⓡｒŕṙřȑȓṛṝŗṟɍɽꝛꞧꞃ"},{base:"s",letters:"sⓢｓßśṥŝṡšṧṣṩșşȿꞩꞅẛ"},{base:"t",letters:"tⓣｔṫẗťṭțţṱṯŧƭʈⱦꞇ"},{base:"tz",letters:"ꜩ"},{base:"u",letters:"uⓤｕùúûũṹūṻŭüǜǘǖǚủůűǔȕȗưừứữửựụṳųṷṵʉ"},{base:"v",letters:"vⓥｖṽṿʋꝟʌ"},{base:"vy",letters:"ꝡ"},{base:"w",letters:"wⓦｗẁẃŵẇẅẘẉⱳ"},{base:"x",letters:"xⓧｘẋẍ"},{base:"y",letters:"yⓨｙỳýŷỹȳẏÿỷẙỵƴɏỿ"},{base:"z",letters:"zⓩｚźẑżžẓẕƶȥɀⱬꝣ"}],diacriticsMap={},i=0;i<defaultDiacriticsRemovalap.length;i+=1)for(var letters=defaultDiacriticsRemovalap[i].letters,j=0;j<letters.length;j+=1)diacriticsMap[letters[j]]=defaultDiacriticsRemovalap[i].base;var uniqueNumber=1,Utils={uniqueNumber:function(){return uniqueNumber+=1},id:function(e,t){void 0===e&&(e="xxxxxxxxxx"),void 0===t&&(t="0123456789abcdef");var r=t.length;return e.replace(/x/g,function(){return t[Math.floor(Math.random()*r)]})},mdPreloaderContent:'\n    <span class="preloader-inner">\n      <span class="preloader-inner-gap"></span>\n      <span class="preloader-inner-left">\n          <span class="preloader-inner-half-circle"></span>\n      </span>\n      <span class="preloader-inner-right">\n          <span class="preloader-inner-half-circle"></span>\n      </span>\n    </span>\n  '.trim(),iosPreloaderContent:('\n    <span class="preloader-inner">\n      '+[0,1,2,3,4,5,6,7,8,9,10,11].map(function(){return'<span class="preloader-inner-line"></span>'}).join("")+"\n    </span>\n  ").trim(),auroraPreloaderContent:'\n    <span class="preloader-inner">\n      <span class="preloader-inner-circle"></span>\n    </span>\n  ',eventNameToColonCase:function(e){var t;return e.split("").map(function(e,r){return e.match(/[A-Z]/)&&0!==r&&!t?(t=!0,":"+e.toLowerCase()):e.toLowerCase()}).join("")},deleteProps:function(e){var t=e;Object.keys(t).forEach(function(e){try{t[e]=null}catch(e){}try{delete t[e]}catch(e){}})},bezier:function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return bezier.apply(void 0,e)},nextTick:function(e,t){return void 0===t&&(t=0),setTimeout(e,t)},nextFrame:function(e){return Utils.requestAnimationFrame(function(){Utils.requestAnimationFrame(e)})},now:function(){return Date.now()},requestAnimationFrame:function(e){return win.requestAnimationFrame(e)},cancelAnimationFrame:function(e){return win.cancelAnimationFrame(e)},removeDiacritics:function(e){return e.replace(/[^\u0000-\u007E]/g,function(e){return diacriticsMap[e]||e})},parseUrlQuery:function(e){var t,r,a,n,o={},i=e||win.location.href;if("string"==typeof i&&i.length)for(n=(r=(i=i.indexOf("?")>-1?i.replace(/\S*\?/,""):"").split("&").filter(function(e){return""!==e})).length,t=0;t<n;t+=1)a=r[t].replace(/#\S+/g,"").split("="),o[decodeURIComponent(a[0])]=void 0===a[1]?void 0:decodeURIComponent(a.slice(1).join("="))||"";return o},getTranslate:function(e,t){var r,a,n;void 0===t&&(t="x");var o=win.getComputedStyle(e,null);return win.WebKitCSSMatrix?((a=o.transform||o.webkitTransform).split(",").length>6&&(a=a.split(", ").map(function(e){return e.replace(",",".")}).join(", ")),n=new win.WebKitCSSMatrix("none"===a?"":a)):r=(n=o.MozTransform||o.OTransform||o.MsTransform||o.msTransform||o.transform||o.getPropertyValue("transform").replace("translate(","matrix(1, 0, 0, 1,")).toString().split(","),"x"===t&&(a=win.WebKitCSSMatrix?n.m41:16===r.length?parseFloat(r[12]):parseFloat(r[4])),"y"===t&&(a=win.WebKitCSSMatrix?n.m42:16===r.length?parseFloat(r[13]):parseFloat(r[5])),a||0},serializeObject:function(e,t){if(void 0===t&&(t=[]),"string"==typeof e)return e;var r,a=[];function n(e){if(t.length>0){for(var r="",a=0;a<t.length;a+=1)r+=0===a?t[a]:"["+encodeURIComponent(t[a])+"]";return r+"["+encodeURIComponent(e)+"]"}return encodeURIComponent(e)}function o(e){return encodeURIComponent(e)}return Object.keys(e).forEach(function(i){var s;if(Array.isArray(e[i])){s=[];for(var l=0;l<e[i].length;l+=1)Array.isArray(e[i][l])||"object"!=typeof e[i][l]?s.push(n(i)+"[]="+o(e[i][l])):((r=t.slice()).push(i),r.push(String(l)),s.push(Utils.serializeObject(e[i][l],r)));s.length>0&&a.push(s.join("&"))}else null===e[i]||""===e[i]?a.push(n(i)+"="):"object"==typeof e[i]?((r=t.slice()).push(i),""!==(s=Utils.serializeObject(e[i],r))&&a.push(s)):void 0!==e[i]&&""!==e[i]?a.push(n(i)+"="+o(e[i])):""===e[i]&&a.push(n(i))}),a.join("&")},isObject:function(e){return"object"==typeof e&&null!==e&&e.constructor&&e.constructor===Object},merge:function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];var r=e[0];e.splice(0,1);for(var a=e,n=0;n<a.length;n+=1){var o=e[n];if(null!=o)for(var i=Object.keys(Object(o)),s=0,l=i.length;s<l;s+=1){var c=i[s],u=Object.getOwnPropertyDescriptor(o,c);void 0!==u&&u.enumerable&&(r[c]=o[c])}}return r},extend:function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];var r,a,n=!0;"boolean"==typeof e[0]?(n=e[0],r=e[1],e.splice(0,2),a=e):(r=e[0],e.splice(0,1),a=e);for(var o=0;o<a.length;o+=1){var i=e[o];if(null!=i)for(var s=Object.keys(Object(i)),l=0,c=s.length;l<c;l+=1){var u=s[l],p=Object.getOwnPropertyDescriptor(i,u);void 0!==p&&p.enumerable&&(n?Utils.isObject(r[u])&&Utils.isObject(i[u])?Utils.extend(r[u],i[u]):!Utils.isObject(r[u])&&Utils.isObject(i[u])?(r[u]={},Utils.extend(r[u],i[u])):r[u]=i[u]:r[u]=i[u])}}return r},colorHexToRgb:function(e){var t=e.replace(/^#?([a-f\d])([a-f\d])([a-f\d])$/i,function(e,t,r,a){return t+t+r+r+a+a}),r=/^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(t);return r?r.slice(1).map(function(e){return parseInt(e,16)}):null},colorRgbToHex:function(e,t,r){return"#"+[e,t,r].map(function(e){var t=e.toString(16);return 1===t.length?"0"+t:t}).join("")},colorRgbToHsl:function(e,t,r){e/=255,t/=255,r/=255;var a,n=Math.max(e,t,r),o=Math.min(e,t,r),i=n-o;0===i?a=0:n===e?a=(t-r)/i%6:n===t?a=(r-e)/i+2:n===r&&(a=(e-t)/i+4);var s=(o+n)/2;return a<0&&(a=6+a),[60*a,0===i?0:i/(1-Math.abs(2*s-1)),s]},colorHslToRgb:function(e,t,r){var a,n=(1-Math.abs(2*r-1))*t,o=e/60,i=n*(1-Math.abs(o%2-1));Number.isNaN(e)||void 0===e?a=[0,0,0]:o<=1?a=[n,i,0]:o<=2?a=[i,n,0]:o<=3?a=[0,n,i]:o<=4?a=[0,i,n]:o<=5?a=[i,0,n]:o<=6&&(a=[n,0,i]);var s=r-n/2;return a.map(function(e){return Math.max(0,Math.min(255,Math.round(255*(e+s))))})},colorHsbToHsl:function(e,t,r){var a={h:e,s:0,l:0},n=t,o=r;return a.l=(2-n)*o/2,a.s=a.l&&a.l<1?n*o/(a.l<.5?2*a.l:2-2*a.l):a.s,[a.h,a.s,a.l]},colorHslToHsb:function(e,t,r){var a={h:e,s:0,b:0},n=r,o=t*(n<.5?n:1-n);return a.b=n+o,a.s=n>0?2*o/a.b:a.s,[a.h,a.s,a.b]},colorThemeCSSProperties:function(){for(var e,t,r=[],a=arguments.length;a--;)r[a]=arguments[a];if(1===r.length?(e=r[0],t=Utils.colorHexToRgb(e)):3===r.length&&(t=r,e=Utils.colorRgbToHex.apply(Utils,t)),!t)return{};var n=Utils.colorRgbToHsl.apply(Utils,t),o=[n[0],n[1],Math.max(0,n[2]-.08)],i=[n[0],n[1],Math.max(0,n[2]+.08)],s=Utils.colorRgbToHex.apply(Utils,Utils.colorHslToRgb.apply(Utils,o)),l=Utils.colorRgbToHex.apply(Utils,Utils.colorHslToRgb.apply(Utils,i));return{"--f7-theme-color":e,"--f7-theme-color-rgb":t.join(", "),"--f7-theme-color-shade":s,"--f7-theme-color-tint":l}}},Device=function(){var e=win.navigator.platform,t=win.navigator.userAgent,r={ios:!1,android:!1,androidChrome:!1,desktop:!1,windowsPhone:!1,iphone:!1,iphoneX:!1,ipod:!1,ipad:!1,edge:!1,ie:!1,firefox:!1,macos:!1,windows:!1,cordova:!(!win.cordova&&!win.phonegap),phonegap:!(!win.cordova&&!win.phonegap),electron:!1},a=win.screen.width,n=win.screen.height,o=t.match(/(Windows Phone);?[\s\/]+([\d.]+)?/),i=t.match(/(Android);?[\s\/]+([\d.]+)?/),s=t.match(/(iPad).*OS\s([\d_]+)/),l=t.match(/(iPod)(.*OS\s([\d_]+))?/),c=!s&&t.match(/(iPhone\sOS|iOS)\s([\d_]+)/),u=c&&(375===a&&812===n||414===a&&896===n),p=t.indexOf("MSIE ")>=0||t.indexOf("Trident/")>=0,d=t.indexOf("Edge/")>=0,h=t.indexOf("Gecko/")>=0&&t.indexOf("Firefox/")>=0,f="MacIntel"===e,v="Win32"===e,m=t.toLowerCase().indexOf("electron")>=0;r.ie=p,r.edge=d,r.firefox=h,o&&(r.os="windowsPhone",r.osVersion=o[2],r.windowsPhone=!0),i&&!v&&(r.os="android",r.osVersion=i[2],r.android=!0,r.androidChrome=t.toLowerCase().indexOf("chrome")>=0),(s||c||l)&&(r.os="ios",r.ios=!0),c&&!l&&(r.osVersion=c[2].replace(/_/g,"."),r.iphone=!0,r.iphoneX=u),s&&(r.osVersion=s[2].replace(/_/g,"."),r.ipad=!0),l&&(r.osVersion=l[3]?l[3].replace(/_/g,"."):null,r.ipod=!0),r.ios&&r.osVersion&&t.indexOf("Version/")>=0&&"10"===r.osVersion.split(".")[0]&&(r.osVersion=t.toLowerCase().split("version/")[1].split(" ")[0]),r.webView=!(!(c||s||l)||!t.match(/.*AppleWebKit(?!.*Safari)/i)&&!win.navigator.standalone)||win.matchMedia&&win.matchMedia("(display-mode: standalone)").matches,r.webview=r.webView,r.standalone=r.webView,r.desktop=!(r.ios||r.android||r.windowsPhone)||m,r.desktop&&(r.electron=m,r.macos=f,r.windows=v);var g=doc.querySelector('meta[name="apple-mobile-web-app-status-bar-style"]');r.needsStatusbarOverlay=function(){return!r.desktop&&(!!(r.standalone&&r.ios&&g&&"black-translucent"===g.content)||!(!(r.webView||r.android&&r.cordova)||win.innerWidth*win.innerHeight!=win.screen.width*win.screen.height)&&(!r.iphoneX||90!==win.orientation&&-90!==win.orientation))},r.statusbar=r.needsStatusbarOverlay(),r.pixelRatio=win.devicePixelRatio||1;return r.prefersColorScheme=function(){var e;return win.matchMedia&&win.matchMedia("(prefers-color-scheme: light)").matches&&(e="light"),win.matchMedia&&win.matchMedia("(prefers-color-scheme: dark)").matches&&(e="dark"),e},r}(),EventsClass=function(e){void 0===e&&(e=[]);this.eventsParents=e,this.eventsListeners={}};EventsClass.prototype.on=function(e,t,r){var a=this;if("function"!=typeof t)return a;var n=r?"unshift":"push";return e.split(" ").forEach(function(e){a.eventsListeners[e]||(a.eventsListeners[e]=[]),a.eventsListeners[e][n](t)}),a},EventsClass.prototype.once=function(e,t,r){var a=this;if("function"!=typeof t)return a;function n(){for(var r=[],o=arguments.length;o--;)r[o]=arguments[o];t.apply(a,r),a.off(e,n),n.f7proxy&&delete n.f7proxy}return n.f7proxy=t,a.on(e,n,r)},EventsClass.prototype.off=function(e,t){var r=this;return r.eventsListeners?(e.split(" ").forEach(function(e){void 0===t?r.eventsListeners[e]=[]:r.eventsListeners[e]&&r.eventsListeners[e].forEach(function(a,n){(a===t||a.f7proxy&&a.f7proxy===t)&&r.eventsListeners[e].splice(n,1)})}),r):r},EventsClass.prototype.emit=function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];var r,a,n,o,i=this;if(!i.eventsListeners)return i;"string"==typeof e[0]||Array.isArray(e[0])?(r=e[0],a=e.slice(1,e.length),n=i,o=i.eventsParents):(r=e[0].events,a=e[0].data,n=e[0].context||i,o=e[0].local?[]:e[0].parents||i.eventsParents);var s=Array.isArray(r)?r:r.split(" "),l=s.map(function(e){return e.replace("local::","")}),c=s.filter(function(e){return e.indexOf("local::")<0});return l.forEach(function(e){if(i.eventsListeners&&i.eventsListeners[e]){var t=[];i.eventsListeners[e].forEach(function(e){t.push(e)}),t.forEach(function(e){e.apply(n,a)})}}),o&&o.length>0&&o.forEach(function(e){e.emit.apply(e,[c].concat(a))}),i};var Framework7Class=function(e){function t(t,r){void 0===t&&(t={}),void 0===r&&(r=[]),e.call(this,r);var a=this;a.params=t,a.params&&a.params.on&&Object.keys(a.params.on).forEach(function(e){a.on(e,a.params.on[e])})}e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t;var r={components:{configurable:!0}};return t.prototype.useModuleParams=function(e,t){if(e.params){var r={};Object.keys(e.params).forEach(function(e){void 0!==t[e]&&(r[e]=Utils.extend({},t[e]))}),Utils.extend(t,e.params),Object.keys(r).forEach(function(e){Utils.extend(t[e],r[e])})}},t.prototype.useModulesParams=function(e){var t=this;t.modules&&Object.keys(t.modules).forEach(function(r){var a=t.modules[r];a.params&&Utils.extend(e,a.params)})},t.prototype.useModule=function(e,t){void 0===e&&(e=""),void 0===t&&(t={});var r=this;if(r.modules){var a="string"==typeof e?r.modules[e]:e;a&&(a.instance&&Object.keys(a.instance).forEach(function(e){var t=a.instance[e];r[e]="function"==typeof t?t.bind(r):t}),a.on&&r.on&&Object.keys(a.on).forEach(function(e){r.on(e,a.on[e])}),a.vnode&&(r.vnodeHooks||(r.vnodeHooks={}),Object.keys(a.vnode).forEach(function(e){Object.keys(a.vnode[e]).forEach(function(t){var n=a.vnode[e][t];r.vnodeHooks[t]||(r.vnodeHooks[t]={}),r.vnodeHooks[t][e]||(r.vnodeHooks[t][e]=[]),r.vnodeHooks[t][e].push(n.bind(r))})})),a.create&&a.create.bind(r)(t))}},t.prototype.useModules=function(e){void 0===e&&(e={});var t=this;t.modules&&Object.keys(t.modules).forEach(function(r){var a=e[r]||{};t.useModule(r,a)})},r.components.set=function(e){this.use&&this.use(e)},t.installModule=function(e){for(var t=[],r=arguments.length-1;r-- >0;)t[r]=arguments[r+1];var a=this;a.prototype.modules||(a.prototype.modules={});var n=e.name||Object.keys(a.prototype.modules).length+"_"+Utils.now();return a.prototype.modules[n]=e,e.proto&&Object.keys(e.proto).forEach(function(t){a.prototype[t]=e.proto[t]}),e.static&&Object.keys(e.static).forEach(function(t){a[t]=e.static[t]}),e.install&&e.install.apply(a,t),a},t.use=function(e){for(var t=[],r=arguments.length-1;r-- >0;)t[r]=arguments[r+1];var a=this;return Array.isArray(e)?(e.forEach(function(e){return a.installModule(e)}),a):a.installModule.apply(a,[e].concat(t))},Object.defineProperties(t,r),t}(EventsClass);function ConstructorMethods(e){void 0===e&&(e={});var t=e.defaultSelector,r=e.constructor,a=e.domProp,n=e.app,o=e.addMethods,i={create:function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return n?new(Function.prototype.bind.apply(r,[null].concat([n],e))):new(Function.prototype.bind.apply(r,[null].concat(e)))},get:function(e){if(void 0===e&&(e=t),e instanceof r)return e;var n=$(e);return 0!==n.length?n[0][a]:void 0},destroy:function(e){var t=i.get(e);if(t&&t.destroy)return t.destroy()}};return o&&Array.isArray(o)&&o.forEach(function(e){i[e]=function(r){void 0===r&&(r=t);for(var a=[],n=arguments.length-1;n-- >0;)a[n]=arguments[n+1];var o=i.get(r);if(o&&o[e])return o[e].apply(o,a)}}),i}function ModalMethods(e){void 0===e&&(e={});var t=e.defaultSelector,r=e.constructor,a=e.app;return Utils.extend(ConstructorMethods({defaultSelector:t,constructor:r,app:a,domProp:"f7Modal"}),{open:function(e,t){var n=$(e),o=n[0].f7Modal;return o||(o=new r(a,{el:n})),o.open(t)},close:function(e,n){void 0===e&&(e=t);var o=$(e);if(0!==o.length){var i=o[0].f7Modal;return i||(i=new r(a,{el:o})),i.close(n)}}})}var fetchedModules=[];function loadModule(e){var t=this;return new Promise(function(r,a){var n,o,i,s=t.instance;if(e){if("string"==typeof e){var l=e.match(/([a-z0-9-]*)/i);if(e.indexOf(".")<0&&l&&l[0].length===e.length){if(!s||s&&!s.params.lazyModulesPath)return void a(new Error('Framework7: "lazyModulesPath" app parameter must be specified to fetch module by name'));n=s.params.lazyModulesPath+"/"+e+".js"}else n=e}else"function"==typeof e?i=e:o=e;if(i){var c=i(t,!1);if(!c)return void a(new Error("Framework7: Can't find Framework7 component in specified component function"));if(t.prototype.modules&&t.prototype.modules[c.name])return void r();h(c),r()}if(o){var u=o;if(!u)return void a(new Error("Framework7: Can't find Framework7 component in specified component"));if(t.prototype.modules&&t.prototype.modules[u.name])return void r();h(u),r()}if(n){if(fetchedModules.indexOf(n)>=0)return void r();fetchedModules.push(n);var p=new Promise(function(e,r){t.request.get(n,function(a){var o="f7_component_loader_callback_"+Utils.id(),i=document.createElement("script");i.innerHTML="window."+o+" = function (Framework7, Framework7AutoInstallComponent) {return "+a.trim()+"}",$("head").append(i);var s=window[o];delete window[o],$(i).remove();var l=s(t,!1);l?t.prototype.modules&&t.prototype.modules[l.name]?e():(h(l),e()):r(new Error("Framework7: Can't find Framework7 component in "+n+" file"))},function(e,t){r(e,t)})}),d=new Promise(function(e){t.request.get(n.replace(".js",s.rtl?".rtl.css":".css"),function(t){var r=document.createElement("style");r.innerHTML=t,$("head").append(r),e()},function(){e()})});Promise.all([p,d]).then(function(){r()}).catch(function(e){a(e)})}}else a(new Error("Framework7: Lazy module must be specified"));function h(e){t.use(e),s&&(s.useModuleParams(e,s.params),s.useModule(e))}})}var Framework7=function(e){function t(r){if(e.call(this,r),t.instance)throw new Error("Framework7 is already initialized and can't be initialized more than once");var a=Utils.extend({},r),n=this;t.instance=n;var o={version:"1.0.0",id:"io.framework7.testapp",root:"body",theme:"auto",language:win.navigator.language,routes:[],name:"Framework7",lazyModulesPath:null,initOnDeviceReady:!0,init:!0,autoDarkTheme:!1};n.useModulesParams(o),n.params=Utils.extend(o,r);var i=$(n.params.root);Utils.extend(n,{id:n.params.id,name:n.params.name,version:n.params.version,routes:n.params.routes,language:n.params.language,root:i,rtl:"rtl"===i.css("direction"),theme:"auto"===n.params.theme?Device.ios?"ios":Device.desktop&&Device.electron?"aurora":"md":n.params.theme,passedParams:a}),n.root&&n.root[0]&&(n.root[0].f7=n),n.useModules(),n.initData();var s="(prefers-color-scheme: dark)",l="(prefers-color-scheme: light)";return n.mq={},win.matchMedia&&(n.mq.dark=win.matchMedia(s),n.mq.light=win.matchMedia(l)),n.colorSchemeListener=function(e){var t=e.matches,r=e.media;if(t){var a=doc.querySelector("html");r===s?a.classList.add("theme-dark"):r===l&&a.classList.remove("theme-dark")}},n.params.init&&(Device.cordova&&n.params.initOnDeviceReady?$(doc).on("deviceready",function(){n.init()}):n.init()),n}e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t;var r={$:{configurable:!0},t7:{configurable:!0}},a={Dom7:{configurable:!0},$:{configurable:!0},Template7:{configurable:!0},Class:{configurable:!0},Events:{configurable:!0}};return t.prototype.initData=function(){var e=this;e.data={},e.params.data&&"function"==typeof e.params.data?Utils.extend(e.data,e.params.data.bind(e)()):e.params.data&&Utils.extend(e.data,e.params.data),e.methods={},e.params.methods&&Object.keys(e.params.methods).forEach(function(t){"function"==typeof e.params.methods[t]?e.methods[t]=e.params.methods[t].bind(e):e.methods[t]=e.params.methods[t]})},t.prototype.enableAutoDarkTheme=function(){if(win.matchMedia){var e=this,t=doc.querySelector("html");e.mq.dark&&e.mq.light&&(e.mq.dark.addListener(e.colorSchemeListener),e.mq.light.addListener(e.colorSchemeListener)),e.mq.dark&&e.mq.dark.matches?t.classList.add("theme-dark"):e.mq.light&&e.mq.light.matches&&t.classList.remove("theme-dark")}},t.prototype.disableAutoDarkTheme=function(){if(win.matchMedia){this.mq.dark&&this.mq.dark.removeListener(this.colorSchemeListener),this.mq.light&&this.mq.light.removeListener(this.colorSchemeListener)}},t.prototype.init=function(){var e=this;return e.initialized?e:(e.root.addClass("framework7-initializing"),e.rtl&&$("html").attr("dir","rtl"),e.params.autoDarkTheme&&e.enableAutoDarkTheme(),e.root.addClass("framework7-root"),$("html").removeClass("ios md").addClass(e.theme),Utils.nextFrame(function(){e.root.removeClass("framework7-initializing")}),e.initialized=!0,e.emit("init"),e)},t.prototype.loadModule=function(){for(var e=[],r=arguments.length;r--;)e[r]=arguments[r];return t.loadModule.apply(t,e)},t.prototype.loadModules=function(){for(var e=[],r=arguments.length;r--;)e[r]=arguments[r];return t.loadModules.apply(t,e)},t.prototype.getVnodeHooks=function(e,t){return this.vnodeHooks&&this.vnodeHooks[e]&&this.vnodeHooks[e][t]||[]},r.$.get=function(){return $},r.t7.get=function(){return Template7},a.Dom7.get=function(){return $},a.$.get=function(){return $},a.Template7.get=function(){return Template7},a.Class.get=function(){return e},a.Events.get=function(){return EventsClass},Object.defineProperties(t.prototype,r),Object.defineProperties(t,a),t}(Framework7Class);Framework7.ModalMethods=ModalMethods,Framework7.ConstructorMethods=ConstructorMethods,Framework7.loadModule=loadModule,Framework7.loadModules=function(e){return Promise.all(e.map(function(e){return Framework7.loadModule(e)}))};var DeviceModule={name:"device",proto:{device:Device},static:{device:Device},on:{init:function(){var e=[],t=doc.querySelector("html"),r=doc.querySelector('meta[name="apple-mobile-web-app-status-bar-style"]');if(t){if(Device.standalone&&Device.ios&&r&&"black-translucent"===r.content&&e.push("device-full-viewport"),e.push("device-pixel-ratio-"+Math.floor(Device.pixelRatio)),Device.pixelRatio>=2&&e.push("device-retina"),Device.os){if(e.push("device-"+Device.os,"device-"+Device.os+"-"+Device.osVersion.split(".")[0],"device-"+Device.os+"-"+Device.osVersion.replace(/\./g,"-")),"ios"===Device.os){for(var a=parseInt(Device.osVersion.split(".")[0],10)-1;a>=6;a-=1)e.push("device-ios-gt-"+a);Device.iphoneX&&e.push("device-iphone-x")}}else Device.desktop&&(e.push("device-desktop"),Device.macos?e.push("device-macos"):Device.windows&&e.push("device-windows"));(Device.cordova||Device.phonegap)&&e.push("device-cordova"),e.forEach(function(e){t.classList.add(e)})}}}},Support=(testDiv=doc.createElement("div"),{touch:!!(win.navigator.maxTouchPoints>0||"ontouchstart"in win||win.DocumentTouch&&doc instanceof win.DocumentTouch),pointerEvents:!!(win.navigator.pointerEnabled||win.PointerEvent||"maxTouchPoints"in win.navigator&&win.navigator.maxTouchPoints>0),prefixedPointerEvents:!!win.navigator.msPointerEnabled,transition:(style=testDiv.style,"transition"in style||"webkitTransition"in style||"MozTransition"in style),transforms3d:win.Modernizr&&!0===win.Modernizr.csstransforms3d||function(){var e=testDiv.style;return"webkitPerspective"in e||"MozPerspective"in e||"OPerspective"in e||"MsPerspective"in e||"perspective"in e}(),flexbox:function(){for(var e=doc.createElement("div").style,t="alignItems webkitAlignItems webkitBoxAlign msFlexAlign mozBoxAlign webkitFlexDirection msFlexDirection mozBoxDirection mozBoxOrient webkitBoxDirection webkitBoxOrient".split(" "),r=0;r<t.length;r+=1)if(t[r]in e)return!0;return!1}(),observer:"MutationObserver"in win||"WebkitMutationObserver"in win,passiveListener:function(){var e=!1;try{var t=Object.defineProperty({},"passive",{get:function(){e=!0}});win.addEventListener("testPassiveListener",null,t)}catch(e){}return e}(),gestures:"ongesturestart"in win,intersectionObserver:"IntersectionObserver"in win}),style,testDiv,SupportModule={name:"support",proto:{support:Support},static:{support:Support},on:{init:function(){var e=doc.querySelector("html");if(e){[].forEach(function(t){e.classList.add(t)})}}}},UtilsModule={name:"utils",proto:{utils:Utils},static:{utils:Utils}},ResizeModule={name:"resize",instance:{getSize:function(){if(!this.root[0])return{width:0,height:0,left:0,top:0};var e=this.root.offset(),t=[this.root[0].offsetWidth,this.root[0].offsetHeight,e.left,e.top],r=t[0],a=t[1],n=t[2],o=t[3];return this.width=r,this.height=a,this.left=n,this.top=o,{width:r,height:a,left:n,top:o}}},on:{init:function(){var e=this;e.getSize(),win.addEventListener("resize",function(){e.emit("resize")},!1),win.addEventListener("orientationchange",function(){e.emit("orientationchange")})},orientationchange:function(){this.device.ipad&&(doc.body.scrollLeft=0,setTimeout(function(){doc.body.scrollLeft=0},0))},resize:function(){this.getSize()}}},globals={},jsonpRequests=0;function Request(e){var t=Utils.extend({},globals);"beforeCreate beforeOpen beforeSend error complete success statusCode".split(" ").forEach(function(e){delete t[e]});var r=Utils.extend({url:win.location.toString(),method:"GET",data:!1,async:!0,cache:!0,user:"",password:"",headers:{},xhrFields:{},statusCode:{},processData:!0,dataType:"text",contentType:"application/x-www-form-urlencoded",timeout:0},t),a=Utils.extend({},r,e);function n(e){for(var t,r,n=[],o=arguments.length-1;o-- >0;)n[o]=arguments[o+1];return globals[e]&&(t=globals[e].apply(globals,n)),a[e]&&(r=a[e].apply(a,n)),"boolean"!=typeof t&&(t=!0),"boolean"!=typeof r&&(r=!0),t&&r}if(!1!==n("beforeCreate",a)){a.type&&(a.method=a.type);var o,i=a.url.indexOf("?")>=0?"&":"?",s=a.method.toUpperCase();if(("GET"===s||"HEAD"===s||"OPTIONS"===s||"DELETE"===s)&&a.data)(o="string"==typeof a.data?a.data.indexOf("?")>=0?a.data.split("?")[1]:a.data:Utils.serializeObject(a.data)).length&&(a.url+=i+o,"?"===i&&(i="&"));if("json"===a.dataType&&a.url.indexOf("callback=")>=0){var l,c="f7jsonp_"+(Date.now()+(jsonpRequests+=1)),u=a.url.split("callback="),p=u[0]+"callback="+c;if(u[1].indexOf("&")>=0){var d=u[1].split("&").filter(function(e){return e.indexOf("=")>0}).join("&");d.length>0&&(p+="&"+d)}var h=doc.createElement("script");return h.type="text/javascript",h.onerror=function(){clearTimeout(l),n("error",null,"scripterror"),n("complete",null,"scripterror")},h.src=p,win[c]=function(e){clearTimeout(l),n("success",e),h.parentNode.removeChild(h),h=null,delete win[c]},doc.querySelector("head").appendChild(h),void(a.timeout>0&&(l=setTimeout(function(){h.parentNode.removeChild(h),h=null,n("error",null,"timeout")},a.timeout)))}"GET"!==s&&"HEAD"!==s&&"OPTIONS"!==s&&"DELETE"!==s||!1===a.cache&&(a.url+=i+"_nocache"+Date.now());var f=new XMLHttpRequest;if(f.requestUrl=a.url,f.requestParameters=a,!1===n("beforeOpen",f,a))return f;f.open(s,a.url,a.async,a.user,a.password);var v,m=null;if(("POST"===s||"PUT"===s||"PATCH"===s)&&a.data)if(a.processData)if([ArrayBuffer,Blob,Document,FormData].indexOf(a.data.constructor)>=0)m=a.data;else{var g="---------------------------"+Date.now().toString(16);"multipart/form-data"===a.contentType?f.setRequestHeader("Content-Type","multipart/form-data; boundary="+g):f.setRequestHeader("Content-Type",a.contentType),m="";var b=Utils.serializeObject(a.data);if("multipart/form-data"===a.contentType){b=b.split("&");for(var y=[],w=0;w<b.length;w+=1)y.push('Content-Disposition: form-data; name="'+b[w].split("=")[0]+'"\r\n\r\n'+b[w].split("=")[1]+"\r\n");m="--"+g+"\r\n"+y.join("--"+g+"\r\n")+"--"+g+"--\r\n"}else m="application/json"===a.contentType?JSON.stringify(a.data):b}else m=a.data,f.setRequestHeader("Content-Type",a.contentType);return"json"!==a.dataType||a.headers&&a.headers.Accept||f.setRequestHeader("Accept","application/json"),a.headers&&Object.keys(a.headers).forEach(function(e){f.setRequestHeader(e,a.headers[e])}),void 0===a.crossDomain&&(a.crossDomain=/^([\w-]+:)?\/\/([^\/]+)/.test(a.url)&&RegExp.$2!==win.location.host),a.crossDomain||f.setRequestHeader("X-Requested-With","XMLHttpRequest"),a.xhrFields&&Utils.extend(f,a.xhrFields),f.onload=function(){var e;if(v&&clearTimeout(v),f.status>=200&&f.status<300||0===f.status)if("json"===a.dataType){var t;try{e=JSON.parse(f.responseText)}catch(e){t=!0}t?n("error",f,"parseerror"):n("success",e,f.status,f)}else n("success",e="text"===f.responseType||""===f.responseType?f.responseText:f.response,f.status,f);else n("error",f,f.status);a.statusCode&&(globals.statusCode&&globals.statusCode[f.status]&&globals.statusCode[f.status](f),a.statusCode[f.status]&&a.statusCode[f.status](f)),n("complete",f,f.status)},f.onerror=function(){v&&clearTimeout(v),n("error",f,f.status),n("complete",f,"error")},a.timeout>0&&(f.onabort=function(){v&&clearTimeout(v)},v=setTimeout(function(){f.abort(),n("error",f,"timeout"),n("complete",f,"timeout")},a.timeout)),!1===n("beforeSend",f,a)?f:(f.send(m),f)}}function RequestShortcut(e){for(var t,r,a=[],n=arguments.length-1;n-- >0;)a[n]=arguments[n+1];var o=[],i=o[0],s=o[1],l=o[2],c=o[3],u=o[4];"function"==typeof a[1]?(i=(t=a)[0],l=t[1],c=t[2],u=t[3]):(i=(r=a)[0],s=r[1],l=r[2],c=r[3],u=r[4]),[l,c].forEach(function(e){"string"==typeof e&&(u=e,e===l?l=void 0:c=void 0)});var p={url:i,method:"post"===e||"postJSON"===e?"POST":"GET",data:s,success:l,error:c,dataType:u=u||("json"===e||"postJSON"===e?"json":void 0)};return"postJSON"===e&&Utils.extend(p,{contentType:"application/json",processData:!1,crossDomain:!0,data:"string"==typeof s?s:JSON.stringify(s)}),Request(p)}function RequestShortcutPromise(e){for(var t=[],r=arguments.length-1;r-- >0;)t[r]=arguments[r+1];var a=t[0],n=t[1],o=t[2];return new Promise(function(t,r){RequestShortcut(e,a,n,function(e){t(e)},function(e,t){r(t)},o)})}Object.assign(Request,{get:function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return RequestShortcut.apply(void 0,["get"].concat(e))},post:function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return RequestShortcut.apply(void 0,["post"].concat(e))},json:function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return RequestShortcut.apply(void 0,["json"].concat(e))},getJSON:function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return RequestShortcut.apply(void 0,["json"].concat(e))},postJSON:function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return RequestShortcut.apply(void 0,["postJSON"].concat(e))}}),Request.promise=function(e){return new Promise(function(t,r){Request(Object.assign(e,{success:function(e){t(e)},error:function(e,t){r(t)}}))})},Object.assign(Request.promise,{get:function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return RequestShortcutPromise.apply(void 0,["get"].concat(e))},post:function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return RequestShortcutPromise.apply(void 0,["post"].concat(e))},json:function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return RequestShortcutPromise.apply(void 0,["json"].concat(e))},getJSON:function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return RequestShortcutPromise.apply(void 0,["json"].concat(e))},postJSON:function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return RequestShortcutPromise.apply(void 0,["postJSON"].concat(e))}}),Request.setup=function(e){e.type&&!e.method&&Utils.extend(e,{method:e.type}),Utils.extend(globals,e)};var RequestModule={name:"request",proto:{request:Request},static:{request:Request}};function initTouch(){var e,t,r,a,n,o,i,s,l,c,u,p,d,h,f,v,m,g,b,y=this,w=y.params.touch,C=w[y.theme+"TouchRipple"];function x(e){var t,r=$(e),a=r.parents(w.activeStateElements);if(r.is(w.activeStateElements)&&(t=r),a.length>0&&(t=t?t.add(a):a),t&&t.length>1){for(var n,o=[],i=0;i<t.length;i+=1)n||(o.push(t[i]),(t.eq(i).hasClass("prevent-active-state-propagation")||t.eq(i).hasClass("no-active-state-propagation"))&&(n=!0));t=$(o)}return t||r}function k(e){return e.parents(".page-content").length>0}function S(){d&&d.addClass("active-state")}function E(){d&&(d.removeClass("active-state"),d=null)}function T(e,t,r){e&&(m=y.touchRipple.create(e,t,r))}function O(){m&&(m.remove(),m=void 0,g=void 0)}function P(r){(g=function(e){var t=w.touchRippleElements,r=$(e);if(r.is(t))return!r.hasClass("no-ripple")&&r;if(r.parents(t).length>0){var a=r.parents(t).eq(0);return!a.hasClass("no-ripple")&&a}return!1}(r))&&0!==g.length?(w.fastClicks?function(e){var t=e.parents(".page-content");return 0!==t.length&&("yes"!==t.prop("scrollHandlerSet")&&(t.on("scroll",function(){clearTimeout(h),clearTimeout(b)}),t.prop("scrollHandlerSet","yes")),!0)}(g):k(g))?(clearTimeout(b),b=setTimeout(function(){O(),T(g,e,t)},80)):(O(),T(g,e,t)):g=void 0}function R(){clearTimeout(b),O()}function D(){m||!g||l?O():(clearTimeout(b),T(g,e,t),setTimeout(O,0))}function N(e,t){y.emit({events:e,data:[t]})}function A(e){N("touchstart touchstart:active",e)}function L(e){N("touchmove touchmove:active",e)}function M(e){N("touchend touchend:active",e)}function U(e){N("touchstart:passive",e)}function B(e){N("touchmove:passive",e)}function H(e){N("touchend:passive",e)}Device.ios&&Device.webView&&win.addEventListener("touchstart",function(){});var q=!!Support.passiveListener&&{passive:!0},j=!!Support.passiveListener&&{passive:!1};doc.addEventListener("click",function(e){N("click",e)},!0),Support.passiveListener?(doc.addEventListener(y.touchEvents.start,A,j),doc.addEventListener(y.touchEvents.move,L,j),doc.addEventListener(y.touchEvents.end,M,j),doc.addEventListener(y.touchEvents.start,U,q),doc.addEventListener(y.touchEvents.move,B,q),doc.addEventListener(y.touchEvents.end,H,q)):(doc.addEventListener(y.touchEvents.start,function(e){A(e),U(e)},!1),doc.addEventListener(y.touchEvents.move,function(e){L(e),B(e)},!1),doc.addEventListener(y.touchEvents.end,function(e){M(e),H(e)},!1)),Support.touch?(w.fastClicks?(y.on("click",function(e){var t,r,o=!1;return n?(a=null,n=!1,!0):"submit"===e.target.type&&0===e.detail||"file"===e.target.type||(a||(t=e.target,r="input select textarea label".split(" "),t.nodeName&&r.indexOf(t.nodeName.toLowerCase())>=0||(o=!0)),f||(o=!0),doc.activeElement===a&&(o=!0),e.forwardedTouchEvent&&(o=!0),e.cancelable||(o=!0),w.tapHold&&w.tapHoldPreventClicks&&c&&(o=!1),o||(e.stopImmediatePropagation(),e.stopPropagation(),a?(function(e){var t=$(e),r=!0;return(t.is("label")||t.parents("label").length>0)&&(r=!Device.android&&!(!Device.ios||!t.is("input"))),r}(a)||l)&&e.preventDefault():e.preventDefault(),a=null),v=setTimeout(function(){f=!1},Device.ios||Device.androidChrome?100:400),w.tapHold&&(u=setTimeout(function(){c=!1},Device.ios||Device.androidChrome?100:400)),o)}),y.on("touchstart",function(p){var m,g,b=this;if(l=!1,c=!1,p.targetTouches.length>1)return d&&E(),!0;if(p.touches.length>1&&d&&E(),w.tapHold&&(u&&clearTimeout(u),u=setTimeout(function(){p&&p.touches&&p.touches.length>1||(c=!0,p.preventDefault(),$(p.target).trigger("taphold"))},w.tapHoldDelay)),v&&clearTimeout(v),m=p.target,g=$(m),!(f=!("input"===m.nodeName.toLowerCase()&&("file"===m.type||"range"===m.type)||"select"===m.nodeName.toLowerCase()&&Device.android||g.hasClass("no-fastclick")||g.parents(".no-fastclick").length>0||w.fastClicksExclude&&g.closest(w.fastClicksExclude).length>0)))return n=!1,!0;if(Device.ios||Device.android&&"getSelection"in win){var y=win.getSelection();if(y.rangeCount&&y.focusNode!==doc.body&&(!y.isCollapsed||doc.activeElement===y.focusNode))return o=!0,!0;o=!1}return Device.android&&function(e){var t="button input textarea select".split(" ");return!(!doc.activeElement||e===doc.activeElement||doc.activeElement===doc.body||t.indexOf(e.nodeName.toLowerCase())>=0)}(p.target)&&doc.activeElement.blur(),n=!0,a=p.target,r=(new Date).getTime(),e=p.targetTouches[0].pageX,t=p.targetTouches[0].pageY,Device.ios&&(i=void 0,$(a).parents().each(function(){var e=b;e.scrollHeight>e.offsetHeight&&!i&&((i=e).f7ScrollTop=i.scrollTop)})),r-s<w.fastClicksDelayBetweenClicks&&p.preventDefault(),w.activeState&&(d=x(a),h=setTimeout(S,0)),C&&P(a),!0}),y.on("touchmove",function(r){if(n){var o=w.fastClicksDistanceThreshold;if(o){var i=r.targetTouches[0].pageX,s=r.targetTouches[0].pageY;(Math.abs(i-e)>o||Math.abs(s-t)>o)&&(l=!0)}else l=!0;l&&(n=!1,a=null,l=!0,w.tapHold&&clearTimeout(u),w.activeState&&(clearTimeout(h),E()),C&&R())}}),y.on("touchend",function(e){clearTimeout(h),clearTimeout(u);var t=(new Date).getTime();if(!n)return!o&&f&&(Device.android&&!e.cancelable||!e.cancelable||e.preventDefault()),w.activeState&&E(),C&&D(),!0;if(doc.activeElement===e.target)return w.activeState&&E(),C&&D(),!0;if(o||e.preventDefault(),t-s<w.fastClicksDelayBetweenClicks)return setTimeout(E,0),C&&D(),!0;if(s=t,n=!1,Device.ios&&i&&i.scrollTop!==i.f7ScrollTop)return!1;if(w.activeState&&(S(),setTimeout(E,0)),C&&D(),function(e){if(doc.activeElement===e)return!1;var t=e.nodeName.toLowerCase(),r="button checkbox file image radio submit".split(" ");return!e.disabled&&!e.readOnly&&("textarea"===t||("select"===t?!Device.android:"input"===t&&r.indexOf(e.type)<0))}(a)){if(Device.ios&&Device.webView)return a.focus(),!1;a.focus()}return doc.activeElement&&a!==doc.activeElement&&doc.activeElement!==doc.body&&"label"!==a.nodeName.toLowerCase()&&doc.activeElement.blur(),e.preventDefault(),!(w.tapHoldPreventClicks&&c||(function(e){var t=e.changedTouches[0],r=doc.createEvent("MouseEvents"),n="click";Device.android&&"select"===a.nodeName.toLowerCase()&&(n="mousedown"),r.initMouseEvent(n,!0,!0,win,1,t.screenX,t.screenY,t.clientX,t.clientY,!1,!1,!1,!1,0,null),r.forwardedTouchEvent=!0,y.device.ios&&win.navigator.standalone?setTimeout(function(){(a=doc.elementFromPoint(e.changedTouches[0].clientX,e.changedTouches[0].clientY))&&a.dispatchEvent(r)},10):a.dispatchEvent(r)}(e),1))})):(y.on("click",function(e){var t=p;return a&&e.target!==a&&(t=!0),w.tapHold&&w.tapHoldPreventClicks&&c&&(t=!0),t&&(e.stopImmediatePropagation(),e.stopPropagation(),e.preventDefault()),w.tapHold&&(u=setTimeout(function(){c=!1},Device.ios||Device.androidChrome?100:400)),p=!1,a=null,!t}),y.on("touchstart",function(r){return l=!1,c=!1,p=!1,r.targetTouches.length>1?(d&&E(),!0):(r.touches.length>1&&d&&E(),w.tapHold&&(u&&clearTimeout(u),u=setTimeout(function(){r&&r.touches&&r.touches.length>1||(c=!0,r.preventDefault(),p=!0,$(r.target).trigger("taphold"))},w.tapHoldDelay)),a=r.target,e=r.targetTouches[0].pageX,t=r.targetTouches[0].pageY,w.activeState&&(k(d=x(a))?h=setTimeout(S,80):S()),C&&P(a),!0)}),y.on("touchmove",function(r){var a,n;if("touchmove"===r.type&&(a=r.targetTouches[0],n=w.touchClicksDistanceThreshold),n&&a){var o=a.pageX,i=a.pageY;(Math.abs(o-e)>n||Math.abs(i-t)>n)&&(l=!0)}else l=!0;l&&(p=!0,w.tapHold&&clearTimeout(u),w.activeState&&(clearTimeout(h),E()),C&&R())}),y.on("touchend",function(e){return clearTimeout(h),clearTimeout(u),doc.activeElement===e.target?(w.activeState&&E(),C&&D(),!0):(w.activeState&&(S(),setTimeout(E,0)),C&&D(),!(w.tapHoldPreventClicks&&c||p)||(e.cancelable&&e.preventDefault(),p=!0,!1))})),doc.addEventListener("touchcancel",function(){n=!1,a=null,clearTimeout(h),clearTimeout(u),w.activeState&&E(),C&&D()},{passive:!0})):w.activeState&&(y.on("touchstart",function(r){x(r.target).addClass("active-state"),"which"in r&&3===r.which&&setTimeout(function(){$(".active-state").removeClass("active-state")},0),C&&(e=r.pageX,t=r.pageY,P(r.target,r.pageX,r.pageY))}),y.on("touchmove",function(){$(".active-state").removeClass("active-state"),C&&R()}),y.on("touchend",function(){$(".active-state").removeClass("active-state"),C&&D()})),doc.addEventListener("contextmenu",function(e){w.disableContextMenu&&(Device.ios||Device.android||Device.cordova)&&e.preventDefault(),C&&(d&&E(),D())})}var TouchModule={name:"touch",params:{touch:{fastClicks:!1,fastClicksDistanceThreshold:10,fastClicksDelayBetweenClicks:50,fastClicksExclude:"",touchClicksDistanceThreshold:5,disableContextMenu:!1,tapHold:!1,tapHoldDelay:750,tapHoldPreventClicks:!0,activeState:!0,activeStateElements:"a, button, label, span, .actions-button, .stepper-button, .stepper-button-plus, .stepper-button-minus, .card-expandable, .menu-item, .link, .item-link",mdTouchRipple:!0,iosTouchRipple:!1,auroraTouchRipple:!1,touchRippleElements:".ripple, .link, .item-link, .list-button, .links-list a, .button, button, .input-clear-button, .dialog-button, .tab-link, .item-radio, .item-checkbox, .actions-button, .searchbar-disable-button, .fab a, .checkbox, .radio, .data-table .sortable-cell:not(.input-cell), .notification-close-button, .stepper-button, .stepper-button-minus, .stepper-button-plus, .menu-item-content"}},instance:{touchEvents:{start:Support.touch?"touchstart":"mousedown",move:Support.touch?"touchmove":"mousemove",end:Support.touch?"touchend":"mouseup"}},on:{init:initTouch}},pathToRegexp_1=pathToRegexp,parse_1=parse,compile_1=compile,tokensToFunction_1=tokensToFunction,tokensToRegExp_1=tokensToRegExp,DEFAULT_DELIMITER="/",PATH_REGEXP=new RegExp(["(\\\\.)","(?:\\:(\\w+)(?:\\(((?:\\\\.|[^\\\\()])+)\\))?|\\(((?:\\\\.|[^\\\\()])+)\\))([+*?])?"].join("|"),"g");function parse(e,t){for(var r,a=[],n=0,o=0,i="",s=t&&t.delimiter||DEFAULT_DELIMITER,l=t&&t.whitelist||void 0,c=!1;null!==(r=PATH_REGEXP.exec(e));){var u=r[0],p=r[1],d=r.index;if(i+=e.slice(o,d),o=d+u.length,p)i+=p[1],c=!0;else{var h="",f=r[2],v=r[3],m=r[4],g=r[5];if(!c&&i.length){var b=i.length-1,y=i[b];(!l||l.indexOf(y)>-1)&&(h=y,i=i.slice(0,b))}i&&(a.push(i),i="",c=!1);var w="+"===g||"*"===g,C="?"===g||"*"===g,x=v||m,k=h||s;a.push({name:f||n++,prefix:h,delimiter:k,optional:C,repeat:w,pattern:x?escapeGroup(x):"[^"+escapeString(k===s?k:k+s)+"]+?"})}}return(i||o<e.length)&&a.push(i+e.substr(o)),a}function compile(e,t){return tokensToFunction(parse(e,t))}function tokensToFunction(e){for(var t=new Array(e.length),r=0;r<e.length;r++)"object"==typeof e[r]&&(t[r]=new RegExp("^(?:"+e[r].pattern+")$"));return function(r,a){for(var n="",o=a&&a.encode||encodeURIComponent,i=0;i<e.length;i++){var s=e[i];if("string"!=typeof s){var l,c=r?r[s.name]:void 0;if(Array.isArray(c)){if(!s.repeat)throw new TypeError('Expected "'+s.name+'" to not repeat, but got array');if(0===c.length){if(s.optional)continue;throw new TypeError('Expected "'+s.name+'" to not be empty')}for(var u=0;u<c.length;u++){if(l=o(c[u],s),!t[i].test(l))throw new TypeError('Expected all "'+s.name+'" to match "'+s.pattern+'"');n+=(0===u?s.prefix:s.delimiter)+l}}else if("string"!=typeof c&&"number"!=typeof c&&"boolean"!=typeof c){if(!s.optional)throw new TypeError('Expected "'+s.name+'" to be '+(s.repeat?"an array":"a string"))}else{if(l=o(String(c),s),!t[i].test(l))throw new TypeError('Expected "'+s.name+'" to match "'+s.pattern+'", but got "'+l+'"');n+=s.prefix+l}}else n+=s}return n}}function escapeString(e){return e.replace(/([.+*?=^!:${}()[\]|\/\\])/g,"\\$1")}function escapeGroup(e){return e.replace(/([=!:$\/()])/g,"\\$1")}function flags(e){return e&&e.sensitive?"":"i"}function regexpToRegexp(e,t){if(!t)return e;var r=e.source.match(/\((?!\?)/g);if(r)for(var a=0;a<r.length;a++)t.push({name:a,prefix:null,delimiter:null,optional:!1,repeat:!1,pattern:null});return e}function arrayToRegexp(e,t,r){for(var a=[],n=0;n<e.length;n++)a.push(pathToRegexp(e[n],t,r).source);return new RegExp("(?:"+a.join("|")+")",flags(r))}function stringToRegexp(e,t,r){return tokensToRegExp(parse(e,r),t,r)}function tokensToRegExp(e,t,r){for(var a=(r=r||{}).strict,n=!1!==r.start,o=!1!==r.end,i=r.delimiter||DEFAULT_DELIMITER,s=[].concat(r.endsWith||[]).map(escapeString).concat("$").join("|"),l=n?"^":"",c=0;c<e.length;c++){var u=e[c];if("string"==typeof u)l+=escapeString(u);else{var p=u.repeat?"(?:"+u.pattern+")(?:"+escapeString(u.delimiter)+"(?:"+u.pattern+"))*":u.pattern;t&&t.push(u),u.optional?u.prefix?l+="(?:"+escapeString(u.prefix)+"("+p+"))?":l+="("+p+")?":l+=escapeString(u.prefix)+"("+p+")"}}if(o)a||(l+="(?:"+escapeString(i)+")?"),l+="$"===s?"$":"(?="+s+")";else{var d=e[e.length-1],h="string"==typeof d?d[d.length-1]===i:void 0===d;a||(l+="(?:"+escapeString(i)+"(?="+s+"))?"),h||(l+="(?="+escapeString(i)+"|"+s+")")}return new RegExp(l,flags(r))}function pathToRegexp(e,t,r){return e instanceof RegExp?regexpToRegexp(e,t):Array.isArray(e)?arrayToRegexp(e,t,r):stringToRegexp(e,t,r)}pathToRegexp_1.parse=parse_1,pathToRegexp_1.compile=compile_1,pathToRegexp_1.tokensToFunction=tokensToFunction_1,pathToRegexp_1.tokensToRegExp=tokensToRegExp_1;var History={queue:[],clearQueue:function(){0!==History.queue.length&&History.queue.shift()()},routerQueue:[],clearRouterQueue:function(){if(0!==History.routerQueue.length){var e=History.routerQueue.pop(),t=e.router,r=e.stateUrl,a=e.action,n=t.params.animate;!1===t.params.pushStateAnimate&&(n=!1),"back"===a&&t.back({animate:n,pushState:!1}),"load"===a&&t.navigate(r,{animate:n,pushState:!1})}},handle:function(e){if(!History.blockPopstate){var t=e.state;History.previousState=History.state,History.state=t,History.allowChange=!0,History.clearQueue(),(t=History.state)||(t={}),this.views.forEach(function(e){var r=e.router,a=t[e.id];if(!a&&e.params.pushState&&(a={url:e.router.history[0]}),a){var n=a.url||void 0,o=r.params.animate;!1===r.params.pushStateAnimate&&(o=!1),n!==r.url&&(r.history.indexOf(n)>=0?r.allowPageChange?r.back({animate:o,pushState:!1}):History.routerQueue.push({action:"back",router:r}):r.allowPageChange?r.navigate(n,{animate:o,pushState:!1}):History.routerQueue.unshift({action:"load",stateUrl:n,router:r}))}})}},initViewState:function(e,t){var r,a=Utils.extend({},History.state||{},((r={})[e]=t,r));History.state=a,win.history.replaceState(a,"")},push:function(e,t,r){var a;if(History.allowChange){History.previousState=History.state;var n=Utils.extend({},History.previousState||{},((a={})[e]=t,a));History.state=n,win.history.pushState(n,"",r)}else History.queue.push(function(){History.push(e,t,r)})},replace:function(e,t,r){var a;if(History.allowChange){History.previousState=History.state;var n=Utils.extend({},History.previousState||{},((a={})[e]=t,a));History.state=n,win.history.replaceState(n,"",r)}else History.queue.push(function(){History.replace(e,t,r)})},go:function(e){History.allowChange=!1,win.history.go(e)},back:function(){History.allowChange=!1,win.history.back()},allowChange:!0,previousState:{},state:win.history.state,blockPopstate:!0,init:function(e){$(win).on("load",function(){setTimeout(function(){History.blockPopstate=!1},0)}),doc.readyState&&"complete"===doc.readyState&&(History.blockPopstate=!1),$(win).on("popstate",History.handle.bind(e))}};function SwipeBack(e){var t,r,a,n,o,i,s,l,c,u,p=e,d=p.$el,h=p.$navbarEl,f=p.app,v=p.params,m=!1,g=!1,b={},y=[],w=[],C=!0,x=[],k=[],S=v[f.theme+"SwipeBackAnimateShadow"],E=v[f.theme+"SwipeBackAnimateOpacity"],T=v[f.theme+"SwipeBackActiveArea"],O=v[f.theme+"SwipeBackThreshold"],P=f.rtl?"right center":"left center";function R(e){void 0===e&&(e={});for(var t=e.progress,r=e.reset,a=e.transition,n=["overflow","transform","transform-origin","opacity"],o=0;o<c.length;o+=1){var i=c[o];if(i&&i.el){!0===a&&i.el.classList.add("navbar-page-transitioning"),!1===a&&i.el.classList.remove("navbar-page-transitioning");for(var s=0;s<n.length;s+=1){var l=n[s];i[l]&&(r?i.el.style[l]="":"function"==typeof i[l]?i.el.style[l]=i[l](t):i.el.style[l]=i[l])}}}}function D(e){var r=v[f.theme+"SwipeBack"];!C||!r||m||f.swipeout&&f.swipeout.el||!p.allowPageChange||$(e.target).closest(".range-slider, .calendar-months").length>0||$(e.target).closest(".page-master, .page-master-detail").length>0&&v.masterDetailBreakpoint>0&&f.width>=v.masterDetailBreakpoint||(g=!1,m=!0,t=void 0,b.x="touchstart"===e.type?e.targetTouches[0].pageX:e.pageX,b.y="touchstart"===e.type?e.targetTouches[0].pageY:e.pageY,n=Utils.now(),o=p.dynamicNavbar,i=p.separateNavbar)}function N(e){if(m){var n="touchmove"===e.type?e.targetTouches[0].pageX:e.pageX,u="touchmove"===e.type?e.targetTouches[0].pageY:e.pageY;if(void 0===t&&(t=!!(t||Math.abs(u-b.y)>Math.abs(n-b.x))||n<b.x&&!f.rtl||n>b.x&&f.rtl),t||e.f7PreventSwipeBack||f.preventSwipeBack)m=!1;else{if(!g){var C=!1,D=$(e.target),N=D.closest(".swipeout");N.length>0&&(!f.rtl&&N.find(".swipeout-actions-left").length>0&&(C=!0),f.rtl&&N.find(".swipeout-actions-right").length>0&&(C=!0)),((y=D.closest(".page")).hasClass("no-swipeback")||D.closest(".no-swipeback, .card-opened").length>0)&&(C=!0),(w=d.find(".page-previous:not(.stacked)")).length>1&&(w=w.eq(w.length-1));b.x,d.offset().left;if(r=d.width(),(f.rtl?b.x<d.offset().left-d[0].scrollLeft+(r-T):b.x-d.offset().left>T)&&(C=!0),0!==w.length&&0!==y.length||(C=!0),C)return void(m=!1);S&&0===(s=y.find(".page-shadow-effect")).length&&(s=$('<div class="page-shadow-effect"></div>'),y.append(s)),E&&0===(l=w.find(".page-opacity-effect")).length&&(l=$('<div class="page-opacity-effect"></div>'),w.append(l)),o&&(i?(x=h.find(".navbar-current:not(.stacked)"),k=h.find(".navbar-previous:not(.stacked)")):(x=y.children(".navbar").children(".navbar-inner"),k=w.children(".navbar").children(".navbar-inner")),k.length>1&&(k=k.eq(k.length-1)),c=function(){var e,t,r=[],a=f.rtl?-1:1,n=x.hasClass("navbar-inner-large"),o=k.hasClass("navbar-inner-large"),s=n&&!x.hasClass("navbar-inner-large-collapsed"),l=o&&!k.hasClass("navbar-inner-large-collapsed"),c=x.children(".left, .title, .right, .subnavbar, .fading, .title-large"),u=k.children(".left, .title, .right, .subnavbar, .fading, .title-large");return v.iosAnimateNavbarBackIcon&&(e=x.hasClass("sliding")?x.children(".left").find(".back .icon + span").eq(0):x.children(".left.sliding").find(".back .icon + span").eq(0),t=k.hasClass("sliding")?k.children(".left").find(".back .icon + span").eq(0):k.children(".left.sliding").find(".back .icon + span").eq(0),e.length&&u.each(function(t,r){$(r).hasClass("title")&&(r.f7NavbarLeftOffset+=e.prev(".icon")[0].offsetWidth)})),c.each(function(t,o){var c=$(o),u=c.hasClass("subnavbar"),p=c.hasClass("left"),d=c.hasClass("title");if(s||!c.hasClass(".title-large")){var h={el:o};if(s){if(d)return;if(c.hasClass("title-large")){if(!i)return;return void(l?(r.indexOf(h)<0&&r.push(h),h.overflow="visible",h.transform="translateX(100%)",c.find(".title-large-text, .title-large-inner").each(function(e,t){r.push({el:t,transform:function(e){return"translateX("+(100*e*a-100)+"%)"}})})):(r.indexOf(h)<0&&r.push(h),h.overflow="hidden",h.transform=function(e){return"translateY(calc("+-e+" * var(--f7-navbar-large-title-height)))"},c.find(".title-large-text, .title-large-inner").each(function(e,t){r.push({el:t,transform:function(e){return"translateX("+100*e*a+"%) translateY(calc("+e+" * var(--f7-navbar-large-title-height)))"}})})))}}if(l){if(!s&&c.hasClass("title-large")){if(!i)return;r.indexOf(h)<0&&r.push(h),h.opacity=0}if(p&&i)return r.indexOf(h)<0&&r.push(h),h.opacity=function(e){return 1-Math.pow(e,.33)},void c.find(".back span").each(function(e,t){r.push({el:t,"transform-origin":P,transform:function(e){return"translateY(calc(var(--f7-navbar-height) * "+e+")) scale("+(1+1*e)+")"}})})}if(!c.hasClass("title-large")){var f=c.hasClass("sliding")||x.hasClass("sliding");if(r.indexOf(h)<0&&r.push(h),(!u||u&&!f)&&(h.opacity=function(e){return 1-Math.pow(e,.33)}),f){var m=h;if(p&&e.length&&v.iosAnimateNavbarBackIcon){var g={el:e[0]};m=g,r.push(g)}m.transform=function(e){var t=e*m.el.f7NavbarRightOffset;return 1===Device.pixelRatio&&(t=Math.round(t)),u&&n&&i?"translate3d("+t+"px, calc(-1 * var(--f7-navbar-large-collapse-progress) * var(--f7-navbar-large-title-height)), 0)":"translate3d("+t+"px,0,0)"}}}}}),u.each(function(e,n){var c=$(n),u=c.hasClass("subnavbar"),p=c.hasClass("left"),d=c.hasClass("title"),h={el:n};if(l){if(d)return;if(r.indexOf(h)<0&&r.push(h),c.hasClass("title-large")){if(!i)return;return s?(h.opacity=1,h.overflow="visible",h.transform="translateY(0)",c.find(".title-large-text").each(function(e,t){r.push({el:t,"transform-origin":P,opacity:function(e){return Math.pow(e,3)},transform:function(e){return"translateY(calc("+(1*e-1)+" * var(--f7-navbar-large-title-height))) scale("+(.5+.5*e)+")"}})})):(h.transform=function(e){return"translateY(calc("+(e-1)+" * var(--f7-navbar-large-title-height)))"},h.opacity=1,h.overflow="hidden",c.find(".title-large-text").each(function(e,t){r.push({el:t,"transform-origin":P,opacity:function(e){return Math.pow(e,3)},transform:function(e){return"scale("+(.5+.5*e)+")"}})})),void c.find(".title-large-inner").each(function(e,t){r.push({el:t,"transform-origin":P,opacity:function(e){return Math.pow(e,3)},transform:function(e){return"translateX("+-100*(1-e)*a+"%)"}})})}}if(!c.hasClass("title-large")){var f=c.hasClass("sliding")||k.hasClass("sliding");if(r.indexOf(h)<0&&r.push(h),(!u||u&&!f)&&(h.opacity=function(e){return Math.pow(e,3)}),f){var m=h;if(p&&t.length&&v.iosAnimateNavbarBackIcon){var g={el:t[0]};m=g,r.push(g)}m.transform=function(e){var t=m.el.f7NavbarLeftOffset*(1-e);return 1===Device.pixelRatio&&(t=Math.round(t)),u&&o&&i?"translate3d("+t+"px, calc(-1 * var(--f7-navbar-large-collapse-progress) * var(--f7-navbar-large-title-height)), 0)":"translate3d("+t+"px,0,0)"}}}}),r}()),$(".sheet.modal-in").length>0&&f.sheet&&f.sheet.close($(".sheet.modal-in"))}e.f7PreventPanelSwipe=!0,g=!0,f.preventSwipePanelBySwipeBack=!0,e.preventDefault();var A=f.rtl?-1:1;(a=(n-b.x-O)*A)<0&&(a=0);var L=Math.min(Math.max(a/r,0),1),M={percentage:L,progress:L,currentPageEl:y[0],previousPageEl:w[0],currentNavbarEl:x[0],previousNavbarEl:k[0]};d.trigger("swipeback:move",M),p.emit("swipebackMove",M);var U=a*A,B=(a/5-r/5)*A;f.rtl?(U=Math.max(U,-r),B=Math.max(B,0)):(U=Math.min(U,r),B=Math.min(B,0)),1===Device.pixelRatio&&(U=Math.round(U),B=Math.round(B)),p.swipeBackActive=!0,$([y[0],w[0]]).addClass("page-swipeback-active"),y.transform("translate3d("+U+"px,0,0)"),S&&(s[0].style.opacity=1-1*L),"ios"===f.theme&&w.transform("translate3d("+B+"px,0,0)"),E&&(s[0].style.opacity=1-1*L),o&&R({progress:L})}}}function A(){if(f.preventSwipePanelBySwipeBack=!1,!m||!g)return m=!1,void(g=!1);if(m=!1,g=!1,p.swipeBackActive=!1,$([y[0],w[0]]).removeClass("page-swipeback-active"),0===a)return $([y[0],w[0]]).transform(""),s&&s.length>0&&s.remove(),l&&l.length>0&&l.remove(),void(o&&R({reset:!0}));var e=Utils.now()-n,t=!1;(e<300&&a>10||e>=300&&a>r/2)&&(y.removeClass("page-current").addClass("page-next"+("ios"!==f.theme?" page-next-on-right":"")),w.removeClass("page-previous").addClass("page-current").removeAttr("aria-hidden"),s&&(s[0].style.opacity=""),l&&(l[0].style.opacity=""),o&&(x.removeClass("navbar-current").addClass("navbar-next"),k.removeClass("navbar-previous").addClass("navbar-current").removeAttr("aria-hidden")),t=!0),$([y[0],w[0]]).addClass("page-transitioning page-transitioning-swipeback").transform(""),o&&R({progress:t?1:0,transition:!0}),C=!1,p.allowPageChange=!1;var c={currentPageEl:y[0],previousPageEl:w[0],currentNavbarEl:x[0],previousNavbarEl:k[0]};t?(p.currentRoute=w[0].f7Page.route,p.currentPage=w[0],p.pageCallback("beforeOut",y,x,"current","next",{route:y[0].f7Page.route,swipeBack:!0}),p.pageCallback("beforeIn",w,k,"previous","current",{route:w[0].f7Page.route,swipeBack:!0},y[0]),d.trigger("swipeback:beforechange",c),p.emit("swipebackBeforeChange",c)):(d.trigger("swipeback:beforereset",c),p.emit("swipebackBeforeReset",c)),y.transitionEnd(function(){$([y[0],w[0]]).removeClass("page-transitioning page-transitioning-swipeback"),o&&R({reset:!0,transition:!1}),C=!0,p.allowPageChange=!0,t?(1===p.history.length&&p.history.unshift(p.url),p.history.pop(),p.saveHistory(),v.pushState&&History.back(),p.pageCallback("afterOut",y,x,"current","next",{route:y[0].f7Page.route,swipeBack:!0}),p.pageCallback("afterIn",w,k,"previous","current",{route:w[0].f7Page.route,swipeBack:!0}),v.stackPages&&p.initialPages.indexOf(y[0])>=0?(y.addClass("stacked"),i&&x.addClass("stacked")):(p.pageCallback("beforeRemove",y,x,"next",{swipeBack:!0}),p.removePage(y),i&&p.removeNavbar(x)),d.trigger("swipeback:afterchange",c),p.emit("swipebackAfterChange",c),p.emit("routeChanged",p.currentRoute,p.previousRoute,p),v.preloadPreviousPage&&p.back(p.history[p.history.length-2],{preload:!0})):(d.trigger("swipeback:afterreset",c),p.emit("swipebackAfterReset",c)),s&&s.length>0&&s.remove(),l&&l.length>0&&l.remove()})}u=!("touchstart"!==f.touchEvents.start||!Support.passiveListener)&&{passive:!0,capture:!1},d.on(f.touchEvents.start,D,u),f.on("touchmove:active",N),f.on("touchend:passive",A),p.on("routerDestroy",function(){var e=!("touchstart"!==f.touchEvents.start||!Support.passiveListener)&&{passive:!0,capture:!1};d.off(f.touchEvents.start,D,e),f.off("touchmove:active",N),f.off("touchend:passive",A)})}function redirect(e,t,r){var a=this,n=t.route.redirect;if(r.initial&&a.params.pushState&&(r.replaceState=!0,r.history=!0),"function"==typeof n){a.allowPageChange=!1;var o=n.call(a,t,function(t,n){void 0===n&&(n={}),a.allowPageChange=!0,a[e](t,Utils.extend({},r,n))},function(){a.allowPageChange=!0});return o&&"string"==typeof o?(a.allowPageChange=!0,a[e](o,r)):a}return a[e](n,r)}function processQueue(e,t,r,a,n,o,i){var s=[];Array.isArray(r)?s.push.apply(s,r):r&&"function"==typeof r&&s.push(r),t&&(Array.isArray(t)?s.push.apply(s,t):s.push(t)),function t(){0!==s.length?s.shift().call(e,a,n,function(){t()},function(){i()}):o()}()}function processRouteQueue(e,t,r,a){var n=this;function o(){e&&e.route&&(n.params.routesBeforeEnter||e.route.beforeEnter)?(n.allowPageChange=!1,processQueue(n,n.params.routesBeforeEnter,e.route.beforeEnter,e,t,function(){n.allowPageChange=!0,r()},function(){a()})):r()}t&&t.route&&(n.params.routesBeforeLeave||t.route.beforeLeave)?(n.allowPageChange=!1,processQueue(n,n.params.routesBeforeLeave,t.route.beforeLeave,e,t,function(){n.allowPageChange=!0,o()},function(){a()})):o()}function appRouterCheck(e,t){if(!e.view)throw new Error("Framework7: it is not allowed to use router methods on global app router. Use router methods only on related View, e.g. app.views.main.router."+t+"(...)")}function refreshPage(){return appRouterCheck(this,"refreshPage"),this.navigate(this.currentRoute.url,{ignoreCache:!0,reloadCurrent:!0})}function forward(e,t){void 0===t&&(t={});var r,a,n,o=this,i=$(e),s=o.app,l=o.view,c=Utils.extend(!1,{animate:o.params.animate,pushState:!0,replaceState:!1,history:!0,reloadCurrent:o.params.reloadPages,reloadPrevious:!1,reloadAll:!1,clearPreviousHistory:!1,reloadDetail:o.params.reloadDetail,on:{}},t),u=o.params.masterDetailBreakpoint>0,p=u&&c.route&&c.route.route&&!0===c.route.route.master,d=o.currentRoute.modal;if(d||"popup popover sheet loginScreen actions customModal panel".split(" ").forEach(function(e){o.currentRoute&&o.currentRoute.route&&o.currentRoute.route[e]&&(d=!0,n=e)}),d){var h=o.currentRoute.modal||o.currentRoute.route.modalInstance||s[n].get(),f=o.history[o.history.length-2],v=o.findMatchingRoute(f);!v&&f&&(v={url:f,path:f.split("?")[0],query:Utils.parseUrlQuery(f),route:{path:f.split("?")[0],url:f}}),o.modalRemove(h)}var m,g,b,y,w=o.dynamicNavbar,C=o.separateNavbar,x=o.$el,k=i,S=c.reloadPrevious||c.reloadCurrent||c.reloadAll;if(o.allowPageChange=!1,0===k.length)return o.allowPageChange=!0,o;k.length&&o.removeThemeElements(k),w&&(b=k.children(".navbar").children(".navbar-inner"),C&&(g=o.$navbarEl,b.length>0&&k.children(".navbar").remove(),0===b.length&&k[0]&&k[0].f7Page&&(b=k[0].f7Page.$navbarEl))),c.route&&c.route.route&&c.route.route.keepAlive&&!c.route.route.keepAliveData&&(c.route.route.keepAliveData={pageEl:i[0]});var E,T,O,P=x.children(".page:not(.stacked)").filter(function(e,t){return t!==k[0]});if(C&&(E=g.children(".navbar-inner:not(.stacked)").filter(function(e,t){return t!==b[0]})),c.reloadPrevious&&P.length<2)return o.allowPageChange=!0,o;if(u&&!c.reloadAll){for(var R=0;R<P.length;R+=1)r||!P[R].classList.contains("page-master")||(r=P[R]);if((T=!p&&r)&&r)for(var D=0;D<P.length;D+=1)P[D].classList.contains("page-master-detail")&&(a=P[D]);O=T&&c.reloadDetail&&s.width>=o.params.masterDetailBreakpoint&&r}var N="next";if(c.reloadCurrent||c.reloadAll||O?N="current":c.reloadPrevious&&(N="previous"),k.removeClass("page-previous page-current page-next").addClass("page-"+N+(p?" page-master":"")+(T?" page-master-detail":"")).removeClass("stacked").trigger("page:unstack").trigger("page:position",{position:N}),(p||T)&&k.trigger("page:role",{role:p?"master":"detail"}),w&&b.length&&b.removeClass("navbar-previous navbar-current navbar-next").addClass("navbar-"+N+(p?" navbar-master":"")+(T?" navbar-master-detail":"")).removeClass("stacked"),c.reloadCurrent||O)m=P.eq(P.length-1),C&&(y=$(s.navbar.getElByPage(m)));else if(c.reloadPrevious)m=P.eq(P.length-2),C&&(y=$(s.navbar.getElByPage(m)));else if(c.reloadAll)m=P.filter(function(e,t){return t!==k[0]}),C&&(y=E.filter(function(e,t){return t!==b[0]}));else{if(P.length>1){var A=0;for(A=0;A<P.length-1;A+=1)if(r&&P[A]===r)P.eq(A).addClass("page-master-stacked"),P.eq(A).trigger("page:masterstack"),C&&$(s.navbar.getElByPage(r)).addClass("navbar-master-stacked");else{var L=s.navbar.getElByPage(P.eq(A));o.params.stackPages?(P.eq(A).addClass("stacked"),P.eq(A).trigger("page:stack"),C&&$(L).addClass("stacked")):(o.pageCallback("beforeRemove",P[A],E&&E[A],"previous",void 0,c),o.removePage(P[A]),C&&L&&o.removeNavbar(L))}}m=x.children(".page:not(.stacked)").filter(function(e,t){return t!==k[0]}),C&&(y=g.children(".navbar-inner:not(.stacked)").filter(function(e,t){return t!==b[0]}))}if(w&&!C&&(y=m.children(".navbar").children(".navbar-inner")),T&&!c.reloadAll&&((m.length>1||O)&&(m=m.filter(function(e,t){return!t.classList.contains("page-master")})),y&&(y.length>1||O)&&(y=y.filter(function(e,t){return!t.classList.contains("navbar-master")}))),o.params.pushState&&(c.pushState||c.replaceState)&&!c.reloadPrevious){var M=o.params.pushStateRoot||"";History[c.reloadCurrent||O&&a||c.reloadAll||c.replaceState?"replace":"push"](l.id,{url:c.route.url},M+o.params.pushStateSeparator+c.route.url)}c.reloadPrevious||(o.currentPageEl=k[0],w&&b.length?o.currentNavbarEl=b[0]:delete o.currentNavbarEl,o.currentRoute=c.route);var U=c.route.url;c.history&&(((c.reloadCurrent||O&&a)&&o.history.length)>0||c.replaceState?o.history[o.history.length-(c.reloadPrevious?2:1)]=U:c.reloadPrevious?o.history[o.history.length-2]=U:c.reloadAll?o.history=[U]:o.history.push(U)),o.saveHistory();var B=k.parents(doc).length>0,H=k[0].f7Component;if(c.reloadPrevious?(H&&!B?H.$mount(function(e){$(e).insertBefore(m)}):k.insertBefore(m),C&&b.length&&(b.children(".title-large").length&&b.addClass("navbar-inner-large"),y.length?b.insertBefore(y):(o.$navbarEl.parents(doc).length||o.$el.prepend(o.$navbarEl),g.append(b)))):(m.next(".page")[0]!==k[0]&&(H&&!B?H.$mount(function(e){x.append(e)}):x.append(k[0])),C&&b.length&&(b.children(".title-large").length&&b.addClass("navbar-inner-large"),o.$navbarEl.parents(doc).length||o.$el.prepend(o.$navbarEl),g.append(b[0]))),B?c.route&&c.route.route&&c.route.route.keepAlive&&!k[0].f7PageMounted&&(k[0].f7PageMounted=!0,o.pageCallback("mounted",k,b,N,S?N:"current",c,m)):o.pageCallback("mounted",k,b,N,S?N:"current",c,m),(c.reloadCurrent||O)&&m.length>0?o.params.stackPages&&o.initialPages.indexOf(m[0])>=0?(m.addClass("stacked"),m.trigger("page:stack"),C&&y.addClass("stacked")):(o.pageCallback("beforeOut",m,y,"current",void 0,c),o.pageCallback("afterOut",m,y,"current",void 0,c),o.pageCallback("beforeRemove",m,y,"current",void 0,c),o.removePage(m),C&&y&&y.length&&o.removeNavbar(y)):c.reloadAll?m.each(function(e,t){var r=$(t),a=$(s.navbar.getElByPage(r));o.params.stackPages&&o.initialPages.indexOf(r[0])>=0?(r.addClass("stacked"),r.trigger("page:stack"),C&&a.addClass("stacked")):(r.hasClass("page-current")&&(o.pageCallback("beforeOut",m,y,"current",void 0,c),o.pageCallback("afterOut",m,y,"current",void 0,c)),o.pageCallback("beforeRemove",r,y&&y.eq(e),"previous",void 0,c),o.removePage(r),C&&a.length&&o.removeNavbar(a))}):c.reloadPrevious&&(o.params.stackPages&&o.initialPages.indexOf(m[0])>=0?(m.addClass("stacked"),m.trigger("page:stack"),C&&y.addClass("stacked")):(o.pageCallback("beforeRemove",m,y,"previous",void 0,c),o.removePage(m),C&&y&&y.length&&o.removeNavbar(y))),c.route.route.tab&&o.tabLoad(c.route.route.tab,Utils.extend({},c,{history:!1,pushState:!1})),o.pageCallback("init",k,b,N,S?N:"current",c,m),c.reloadCurrent||c.reloadAll||O)return o.allowPageChange=!0,o.pageCallback("beforeIn",k,b,N,"current",c),k.removeAttr("aria-hidden"),w&&b&&b.removeAttr("aria-hidden"),o.pageCallback("afterIn",k,b,N,"current",c),c.reloadCurrent&&c.clearPreviousHistory&&o.clearPreviousHistory(),O&&(r.classList.add("page-previous"),r.classList.remove("page-current"),$(r).trigger("page:position",{position:"previous"}),r.f7Page&&r.f7Page.navbarEl&&(r.f7Page.navbarEl.classList.add("navbar-previous"),r.f7Page.navbarEl.classList.remove("navbar-current"))),o;if(c.reloadPrevious)return o.allowPageChange=!0,o;function q(){var e="page-previous page-current page-next",t="navbar-previous navbar-current navbar-next";k.removeClass(e).addClass("page-current").removeAttr("aria-hidden").trigger("page:position",{position:"current"}),m.removeClass(e).addClass("page-previous").trigger("page:position",{position:"previous"}),m.hasClass("page-master")||m.attr("aria-hidden","true"),w&&(b.removeClass(t).addClass("navbar-current").removeAttr("aria-hidden"),y.removeClass(t).addClass("navbar-previous"),y.hasClass("navbar-master")||y.attr("aria-hidden","true")),o.allowPageChange=!0,o.pageCallback("afterOut",m,y,"current","previous",c),o.pageCallback("afterIn",k,b,"next","current",c);var r=(o.params.preloadPreviousPage||o.params[s.theme+"SwipeBack"])&&!p;r||(k.hasClass("smart-select-page")||k.hasClass("photo-browser-page")||k.hasClass("autocomplete-page")||k.hasClass("color-picker-page"))&&(r=!0),r||(o.params.stackPages?(m.addClass("stacked"),m.trigger("page:stack"),C&&y.addClass("stacked")):k.attr("data-name")&&"smart-select-page"===k.attr("data-name")||(o.pageCallback("beforeRemove",m,y,"previous",void 0,c),o.removePage(m),C&&y.length&&o.removeNavbar(y))),c.clearPreviousHistory&&o.clearPreviousHistory(),o.emit("routeChanged",o.currentRoute,o.previousRoute,o),o.params.pushState&&History.clearRouterQueue()}function j(){var e="page-previous page-current page-next",t="navbar-previous navbar-current navbar-next";m.removeClass(e).addClass("page-current").removeAttr("aria-hidden").trigger("page:position",{position:"current"}),k.removeClass(e).addClass("page-next").removeAttr("aria-hidden").trigger("page:position",{position:"next"}),w&&(y.removeClass(t).addClass("navbar-current").removeAttr("aria-hidden"),b.removeClass(t).addClass("navbar-next").removeAttr("aria-hidden"))}if(o.pageCallback("beforeOut",m,y,"current","previous",c),o.pageCallback("beforeIn",k,b,"next","current",c),!c.animate||p&&s.width>=o.params.masterDetailBreakpoint)q();else{var F=o.params[o.app.theme+"PageLoadDelay"];F?setTimeout(function(){j(),o.animate(m,k,y,b,"forward",function(){q()})},F):(j(),o.animate(m,k,y,b,"forward",function(){q()}))}return o}function load(e,t,r){void 0===e&&(e={}),void 0===t&&(t={});var a=this;if(!a.allowPageChange&&!r)return a;var n=e,o=t,i=n.url,s=n.content,l=n.el,c=n.pageName,u=n.template,p=n.templateUrl,d=n.component,h=n.componentUrl;if(!o.reloadCurrent&&o.route&&o.route.route&&o.route.route.parentPath&&a.currentRoute.route&&a.currentRoute.route.parentPath===o.route.route.parentPath){if(o.route.url===a.url)return a.allowPageChange=!0,!1;var f=Object.keys(o.route.params).length===Object.keys(a.currentRoute.params).length;if(f&&Object.keys(o.route.params).forEach(function(e){e in a.currentRoute.params&&a.currentRoute.params[e]===o.route.params[e]||(f=!1)}),f)return!!o.route.route.tab&&a.tabLoad(o.route.route.tab,o);if(!f&&o.route.route.tab&&a.currentRoute.route.tab&&a.currentRoute.parentPath===o.route.parentPath)return a.tabLoad(o.route.route.tab,o)}if(o.route&&o.route.url&&a.url===o.route.url&&!o.reloadCurrent&&!o.reloadPrevious&&!a.params.allowDuplicateUrls)return a.allowPageChange=!0,!1;function v(e,t){return a.forward(e,Utils.extend(o,t))}function m(){return a.allowPageChange=!0,a}if(!o.route&&i&&(o.route=a.parseRouteUrl(i),Utils.extend(o.route,{route:{url:i,path:i}})),(i||p||h)&&(a.allowPageChange=!1),s)a.forward(a.getPageEl(s),o);else if(u||p)try{a.pageTemplateLoader(u,p,o,v,m)}catch(e){throw a.allowPageChange=!0,e}else if(l)a.forward(a.getPageEl(l),o);else if(c)a.forward(a.$el.children('.page[data-name="'+c+'"]').eq(0),o);else if(d||h)try{a.pageComponentLoader(a.el,d,h,o,v,m)}catch(e){throw a.allowPageChange=!0,e}else i&&(a.xhr&&(a.xhr.abort(),a.xhr=!1),a.xhrRequest(i,o).then(function(e){a.forward(a.getPageEl(e),o)}).catch(function(){a.allowPageChange=!0}));return a}function navigate(e,t){void 0===t&&(t={});var r,a,n,o,i,s,l=this;if(l.swipeBackActive)return l;if("string"==typeof e?r=e:(r=e.url,a=e.route,n=e.name,o=e.query,i=e.params),n){if(!(s=l.findRouteByKey("name",n)))throw new Error('Framework7: route with name "'+n+'" not found');if(r=l.constructRouteUrl(s,{params:i,query:o}))return l.navigate(r,t);throw new Error("Framework7: can't construct URL for route with name \""+n+'"')}var c=l.app;if(appRouterCheck(l,"navigate"),"#"===r||""===r)return l;var u=r.replace("./","");if("/"!==u[0]&&0!==u.indexOf("#")){var p=l.currentRoute.parentPath||l.currentRoute.path;u=((p?p+"/":"/")+u).replace("///","/").replace("//","/")}if(!(s=a?Utils.extend(l.parseRouteUrl(u),{route:Utils.extend({},a)}):l.findMatchingRoute(u)))return l;if(s.route.redirect)return redirect.call(l,"navigate",s,t);var d={};function h(){var e=!1;"popup popover sheet loginScreen actions customModal panel".split(" ").forEach(function(t){s.route[t]&&!e&&(e=!0,l.modalLoad(t,s,d))}),s.route.keepAlive&&s.route.keepAliveData&&(l.load({el:s.route.keepAliveData.pageEl},d,!1),e=!0),"url content component pageName el componentUrl template templateUrl".split(" ").forEach(function(t){var r;s.route[t]&&!e&&(e=!0,l.load(((r={})[t]=s.route[t],r),d,!1))}),e||s.route.async&&(l.allowPageChange=!1,s.route.async.call(l,d.route,l.currentRoute,function(e,t){l.allowPageChange=!1;var r=!1;t&&t.context&&(s.context?s.context=Utils.extend({},s.context,t.context):s.context=t.context,d.route.context=s.context),"popup popover sheet loginScreen actions customModal panel".split(" ").forEach(function(a){if(e[a]){r=!0;var n=Utils.extend({},s,{route:e});l.allowPageChange=!0,l.modalLoad(a,n,Utils.extend(d,t))}}),r||l.load(e,Utils.extend(d,t),!0)},function(){l.allowPageChange=!0}))}function f(){l.allowPageChange=!0}if(s.route.options?Utils.extend(d,s.route.options,t):Utils.extend(d,t),d.route=s,d&&d.context&&(s.context=d.context,d.route.context=d.context),l.params.masterDetailBreakpoint>0&&s.route.masterRoute){var v=!0;if(l.currentRoute&&l.currentRoute.route&&(!l.currentRoute.route.master||l.currentRoute.route!==s.route.masterRoute&&l.currentRoute.route.path!==s.route.masterRoute.path||(v=!1),!l.currentRoute.route.masterRoute||l.currentRoute.route.masterRoute!==s.route.masterRoute&&l.currentRoute.route.masterRoute.path!==s.route.masterRoute.path||(v=!1)),v)return l.navigate(s.route.masterRoute.path,{animate:!1,reloadAll:t.reloadAll,reloadCurrent:t.reloadCurrent,reloadPrevious:t.reloadPrevious,once:{pageAfterIn:function(){l.navigate(e,Utils.extend({},t,{animate:!1,reloadAll:!1,reloadCurrent:!1,reloadPrevious:!1}))}}}),l}return processRouteQueue.call(l,s,l.currentRoute,function(){s.route.modules?c.loadModules(Array.isArray(s.route.modules)?s.route.modules:[s.route.modules]).then(function(){h()}).catch(function(){f()}):h()},function(){f()}),l}function tabLoad(e,t){void 0===t&&(t={});var r,a,n=this,o=Utils.extend({animate:n.params.animate,pushState:!0,history:!0,parentPageEl:null,preload:!1,on:{}},t);o.route&&(o.preload||o.route===n.currentRoute||(a=n.previousRoute,n.currentRoute=o.route),o.preload?(r=o.route,a=n.currentRoute):(r=n.currentRoute,a||(a=n.previousRoute)),n.params.pushState&&o.pushState&&!o.reloadPrevious&&History.replace(n.view.id,{url:o.route.url},(n.params.pushStateRoot||"")+n.params.pushStateSeparator+o.route.url),o.history&&(n.history[Math.max(n.history.length-1,0)]=o.route.url,n.saveHistory()));var i,s=$(o.parentPageEl||n.currentPageEl);i=s.length&&s.find("#"+e.id).length?s.find("#"+e.id).eq(0):n.view.selector?n.view.selector+" #"+e.id:"#"+e.id;var l,c=n.app.tab.show({tabEl:i,animate:o.animate,tabRoute:o.route}),u=c.$newTabEl,p=c.$oldTabEl,d=c.animated,h=c.onTabsChanged;if(u&&u.parents(".page").length>0&&o.route){var f=u.parents(".page")[0].f7Page;f&&o.route&&(f.route=o.route)}if(u[0].f7RouterTabLoaded)return p&&p.length?(d?h(function(){n.emit("routeChanged",n.currentRoute,n.previousRoute,n)}):n.emit("routeChanged",n.currentRoute,n.previousRoute,n),n):n;function v(t,r){var a=t.url,o=t.content,i=t.el,s=t.template,l=t.templateUrl,c=t.component,f=t.componentUrl;function v(t){n.allowPageChange=!0,t&&("string"==typeof t?u.html(t):(u.html(""),t.f7Component?t.f7Component.$mount(function(e){u.append(e)}):u.append(t)),u[0].f7RouterTabLoaded=!0,function(t){n.removeThemeElements(u);var r=u;"string"!=typeof t&&(r=$(t)),r.trigger("tab:init tab:mounted",e),n.emit("tabInit tabMounted",u[0],e),p&&p.length&&(d?h(function(){n.emit("routeChanged",n.currentRoute,n.previousRoute,n),n.params.unloadTabContent&&n.tabRemove(p,u,e)}):(n.emit("routeChanged",n.currentRoute,n.previousRoute,n),n.params.unloadTabContent&&n.tabRemove(p,u,e)))}(t))}function m(){return n.allowPageChange=!0,n}if(o)v(o);else if(s||l)try{n.tabTemplateLoader(s,l,r,v,m)}catch(e){throw n.allowPageChange=!0,e}else if(i)v(i);else if(c||f)try{n.tabComponentLoader(u[0],c,f,r,v,m)}catch(e){throw n.allowPageChange=!0,e}else a&&(n.xhr&&(n.xhr.abort(),n.xhr=!1),n.xhrRequest(a,r).then(function(e){v(e)}).catch(function(){n.allowPageChange=!0}))}return"url content component el componentUrl template templateUrl".split(" ").forEach(function(t){var r;e[t]&&(l=!0,v(((r={})[t]=e[t],r),o))}),e.async?e.async.call(n,r,a,function(e,t){v(e,Utils.extend(o,t))},function(){n.allowPageChange=!0}):l||(n.allowPageChange=!0),n}function tabRemove(e,t,r){var a;e[0]&&(e[0].f7RouterTabLoaded=!1,delete e[0].f7RouterTabLoaded),e.children().each(function(e,t){t.f7Component&&(a=!0,$(t).trigger("tab:beforeremove",r),t.f7Component.$destroy())}),a||e.trigger("tab:beforeremove",r),this.emit("tabBeforeRemove",e[0],t[0],r),this.removeTabContent(e[0],r)}function modalLoad(e,t,r){void 0===r&&(r={});var a,n=this,o=n.app,i="panel"===e,s=i?"panel":"modal",l=Utils.extend({animate:n.params.animate,pushState:!0,history:!0,on:{}},r),c=Utils.extend({},t.route[e]),u=t.route;function p(){var r=o[e].create(c);u.modalInstance=r;var a=r.el;function p(){r.close()}r.on(s+"Open",function(){a||(n.removeThemeElements(r.el),r.$el.trigger(e.toLowerCase()+":init "+e.toLowerCase()+":mounted",t,r),n.emit((i?"":"modalInit")+" "+e+"Init "+e+"Mounted",r.el,t,r)),n.once("swipeBackMove",p)}),r.on(s+"Close",function(){n.off("swipeBackMove",p),r.closeByRouter||n.back()}),r.on(s+"Closed",function(){r.$el.trigger(e.toLowerCase()+":beforeremove",t,r),r.emit((i?"":"modalBeforeRemove ")+e+"BeforeRemove",r.el,t,r);var a=r.el.f7Component;a&&a.$destroy(),Utils.nextTick(function(){(a||c.component)&&n.removeModal(r.el),r.destroy(),delete r.route,delete u.modalInstance})}),l.route&&(n.params.pushState&&l.pushState&&History.push(n.view.id,{url:l.route.url,modal:e},(n.params.pushStateRoot||"")+n.params.pushStateSeparator+l.route.url),l.route!==n.currentRoute&&(r.route=Utils.extend(l.route,{modal:r}),n.currentRoute=r.route),l.history&&(n.history.push(l.route.url),n.saveHistory())),a&&(n.removeThemeElements(r.el),r.$el.trigger(e.toLowerCase()+":init "+e.toLowerCase()+":mounted",t,r),n.emit(s+"Init "+e+"Init "+e+"Mounted",r.el,t,r)),r.open()}function d(e,t){var r=e.url,a=e.content,i=e.template,s=e.templateUrl,l=e.component,u=e.componentUrl;function d(e){e&&("string"==typeof e?c.content=e:e.f7Component?e.f7Component.$mount(function(e){c.el=e,o.root.append(e)}):c.el=e,p())}function h(){return n.allowPageChange=!0,n}if(a)d(a);else if(i||s)try{n.modalTemplateLoader(i,s,t,d,h)}catch(e){throw n.allowPageChange=!0,e}else if(l||u)try{n.modalComponentLoader(o.root[0],l,u,t,d,h)}catch(e){throw n.allowPageChange=!0,e}else r?(n.xhr&&(n.xhr.abort(),n.xhr=!1),n.xhrRequest(r,t).then(function(e){c.content=e,p()}).catch(function(){n.allowPageChange=!0})):p()}return"url content component el componentUrl template templateUrl".split(" ").forEach(function(e){var t;c[e]&&!a&&(a=!0,d(((t={})[e]=c[e],t),l))}),a||"actions"!==e||p(),c.async&&c.async.call(n,l.route,n.currentRoute,function(e,t){d(e,Utils.extend(l,t))},function(){n.allowPageChange=!0}),n}function modalRemove(e){Utils.extend(e,{closeByRouter:!0}),e.close()}function backward(e,t){var r,a,n,o,i,s,l=this,c=$(e),u=l.app,p=l.view,d=Utils.extend({animate:l.params.animate,pushState:!0},t),h=l.params.masterDetailBreakpoint>0,f=h&&d.route&&d.route.route&&!0===d.route.route.master,v=l.dynamicNavbar,m=l.separateNavbar,g=c,b=l.$el.children(".page-current"),y=h&&b.hasClass("page-master");if(g.length&&l.removeThemeElements(g),v&&(n=g.children(".navbar").children(".navbar-inner"),m?(a=l.$navbarEl,n.length>0&&g.children(".navbar").remove(),0===n.length&&g[0]&&g[0].f7Page&&(n=g[0].f7Page.$navbarEl),o=a.find(".navbar-current")):o=b.children(".navbar").children(".navbar-inner")),l.allowPageChange=!1,0===g.length||0===b.length)return l.allowPageChange=!0,l;if(l.removeThemeElements(g),d.route&&d.route.route&&d.route.route.keepAlive&&!d.route.route.keepAliveData&&(d.route.route.keepAliveData={pageEl:c[0]}),h){for(var w=l.$el.children(".page:not(.stacked)").filter(function(e,t){return t!==g[0]}),C=0;C<w.length;C+=1)r||!w[C].classList.contains("page-master")||(r=w[C]);i=!f&&r&&l.history.indexOf(d.route.url)>l.history.indexOf(r.f7Page.route.url)}if(g.addClass("page-previous"+(f?" page-master":"")+(i?" page-master-detail":"")).removeClass("stacked").removeAttr("aria-hidden").trigger("page:unstack").trigger("page:position",{position:"previous"}),(f||i)&&g.trigger("page:role",{role:f?"master":"detail"}),v&&n.length>0&&n.addClass("navbar-previous"+(f?" navbar-master":"")+(i?" navbar-master-detail":"")).removeClass("stacked").removeAttr("aria-hidden"),d.force&&(b.prev(".page-previous:not(.stacked)").length>0||0===b.prev(".page-previous").length))if(l.history.indexOf(d.route.url)>=0?(s=l.history.length-l.history.indexOf(d.route.url)-1,l.history=l.history.slice(0,l.history.indexOf(d.route.url)+2),p.history=l.history):l.history[[l.history.length-2]]?l.history[l.history.length-2]=d.route.url:l.history.unshift(l.url),s&&l.params.stackPages)b.prevAll(".page-previous").each(function(e,t){var r,a=$(t);m&&(r=$(u.navbar.getElByPage(a))),a[0]!==g[0]&&a.index()>g.index()&&(l.initialPages.indexOf(a[0])>=0?(a.addClass("stacked"),a.trigger("page:stack"),m&&r.addClass("stacked")):(l.pageCallback("beforeRemove",a,r,"previous",void 0,d),l.removePage(a),m&&r.length>0&&l.removeNavbar(r)))});else{var x,k=b.prev(".page-previous:not(.stacked)");m&&(x=$(u.navbar.getElByPage(k))),l.params.stackPages&&l.initialPages.indexOf(k[0])>=0?(k.addClass("stacked"),k.trigger("page:stack"),x.addClass("stacked")):k.length>0&&(l.pageCallback("beforeRemove",k,x,"previous",void 0,d),l.removePage(k),m&&x.length&&l.removeNavbar(x))}var S,E,T=g.parents(doc).length>0,O=g[0].f7Component;function P(){0===g.next(b).length&&(!T&&O?O.$mount(function(e){$(e).insertBefore(b)}):g.insertBefore(b)),m&&n.length&&(n.children(".title-large").length&&n.addClass("navbar-inner-large"),n.insertBefore(o),o.length>0?n.insertBefore(o):(l.$navbarEl.parents(doc).length||l.$el.prepend(l.$navbarEl),a.append(n))),T?d.route&&d.route.route&&d.route.route.keepAlive&&!g[0].f7PageMounted&&(g[0].f7PageMounted=!0,l.pageCallback("mounted",g,n,"previous","current",d,b)):l.pageCallback("mounted",g,n,"previous","current",d,b)}if(d.preload){P(),d.route.route.tab&&l.tabLoad(d.route.route.tab,Utils.extend({},d,{history:!1,pushState:!1,preload:!0})),f&&(g.removeClass("page-master-stacked").trigger("page:masterunstack"),m&&$(u.navbar.getElByPage(g)).removeClass("navbar-master-stacked")),l.pageCallback("init",g,n,"previous","current",d,b);var R=g.prevAll(".page-previous:not(.stacked):not(.page-master)");return R.length>0&&R.each(function(e,t){var r,a=$(t);m&&(r=$(u.navbar.getElByPage(a))),l.params.stackPages&&l.initialPages.indexOf(t)>=0?(a.addClass("stacked"),a.trigger("page:stack"),m&&r.addClass("stacked")):(l.pageCallback("beforeRemove",a,r,"previous",void 0),l.removePage(a),m&&r.length&&l.removeNavbar(r))}),l.allowPageChange=!0,l}function D(){var e="page-previous page-current page-next",t="navbar-previous navbar-current navbar-next";g.removeClass(e).addClass("page-current").removeAttr("aria-hidden").trigger("page:position",{position:"current"}),b.removeClass(e).addClass("page-next").attr("aria-hidden","true").trigger("page:position",{position:"next"}),v&&(n.removeClass(t).addClass("navbar-current").removeAttr("aria-hidden"),o.removeClass(t).addClass("navbar-next").attr("aria-hidden","true")),l.pageCallback("afterOut",b,o,"current","next",d),l.pageCallback("afterIn",g,n,"previous","current",d),l.params.stackPages&&l.initialPages.indexOf(b[0])>=0?(b.addClass("stacked"),b.trigger("page:stack"),m&&o.addClass("stacked")):(l.pageCallback("beforeRemove",b,o,"next",void 0,d),l.removePage(b),m&&o.length&&l.removeNavbar(o)),l.allowPageChange=!0,l.emit("routeChanged",l.currentRoute,l.previousRoute,l),(l.params.preloadPreviousPage||l.params[u.theme+"SwipeBack"])&&l.history[l.history.length-2]&&!f&&l.back(l.history[l.history.length-2],{preload:!0}),l.params.pushState&&History.clearRouterQueue()}return Device.ie||Device.edge||Device.firefox&&!Device.ios||l.params.pushState&&d.pushState&&(s?History.go(-s):History.back()),1===l.history.length&&l.history.unshift(l.url),l.history.pop(),l.saveHistory(),l.currentPageEl=g[0],v&&n.length?l.currentNavbarEl=n[0]:delete l.currentNavbarEl,l.currentRoute=d.route,(Device.ie||Device.edge||Device.firefox&&!Device.ios)&&l.params.pushState&&d.pushState&&(s?History.go(-s):History.back()),P(),d.route.route.tab&&l.tabLoad(d.route.route.tab,Utils.extend({},d,{history:!1,pushState:!1})),l.pageCallback("init",g,n,"previous","current",d,b),l.pageCallback("beforeOut",b,o,"current","next",d),l.pageCallback("beforeIn",g,n,"previous","current",d),!d.animate||y&&u.width>=l.params.masterDetailBreakpoint?D():(S="page-previous page-current page-next",E="navbar-previous navbar-current navbar-next",b.removeClass(S).addClass("page-current").trigger("page:position",{position:"current"}),g.removeClass(S).addClass("page-previous").removeAttr("aria-hidden").trigger("page:position",{position:"previous"}),v&&(o.removeClass(E).addClass("navbar-current"),n.removeClass(E).addClass("navbar-previous").removeAttr("aria-hidden")),l.animate(b,g,o,n,"backward",function(){D()})),l}function loadBack(e,t,r){var a=this;if(!a.allowPageChange&&!r)return a;var n=e,o=t,i=n.url,s=n.content,l=n.el,c=n.pageName,u=n.template,p=n.templateUrl,d=n.component,h=n.componentUrl;if(o.route.url&&a.url===o.route.url&&!o.reloadCurrent&&!o.reloadPrevious&&!a.params.allowDuplicateUrls)return!1;function f(e,t){return a.backward(e,Utils.extend(o,t))}function v(){return a.allowPageChange=!0,a}if(!o.route&&i&&(o.route=a.parseRouteUrl(i)),(i||p||h)&&(a.allowPageChange=!1),s)a.backward(a.getPageEl(s),o);else if(u||p)try{a.pageTemplateLoader(u,p,o,f,v)}catch(e){throw a.allowPageChange=!0,e}else if(l)a.backward(a.getPageEl(l),o);else if(c)a.backward(a.$el.children('.page[data-name="'+c+'"]').eq(0),o);else if(d||h)try{a.pageComponentLoader(a.el,d,h,o,f,v)}catch(e){throw a.allowPageChange=!0,e}else i&&(a.xhr&&(a.xhr.abort(),a.xhr=!1),a.xhrRequest(i,o).then(function(e){a.backward(a.getPageEl(e),o)}).catch(function(){a.allowPageChange=!0}));return a}function back(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];var r,a,n,o=this;if(o.swipeBackActive)return o;"object"==typeof e[0]?a=e[0]||{}:(r=e[0],a=e[1]||{});var i=a.name,s=a.params,l=a.query;if(i){if(!(n=o.findRouteByKey("name",i)))throw new Error('Framework7: route with name "'+i+'" not found');if(r=o.constructRouteUrl(n,{params:s,query:l}))return o.back(r,Utils.extend({},a,{name:null,params:null,query:null}));throw new Error("Framework7: can't construct URL for route with name \""+i+'"')}var c=o.app;appRouterCheck(o,"back");var u,p=o.currentRoute.modal;if(p||"popup popover sheet loginScreen actions customModal panel".split(" ").forEach(function(e){o.currentRoute.route[e]&&(p=!0,u=e)}),p){var d,h=o.currentRoute.modal||o.currentRoute.route.modalInstance||c[u].get(),f=o.history[o.history.length-2];if(h&&h.$el){var v=h.$el.prevAll(".modal-in");v.length&&v[0].f7Modal&&(d=v[0].f7Modal.route)}if(d||(d=o.findMatchingRoute(f)),!d&&f&&(d={url:f,path:f.split("?")[0],query:Utils.parseUrlQuery(f),route:{path:f.split("?")[0],url:f}}),!(r&&0!==r.replace(/[# ]/g,"").trim().length||d&&h))return o;var m=a.force&&d&&r;return d&&h?(o.params.pushState&&!1!==a.pushState&&History.back(),o.currentRoute=d,o.history.pop(),o.saveHistory(),o.modalRemove(h),m&&o.navigate(r,{reloadCurrent:!0})):h&&(o.modalRemove(h),r&&o.navigate(r,{reloadCurrent:!0})),o}var g,b=o.$el.children(".page-current").prevAll(".page-previous:not(.page-master)").eq(0);if(o.params.masterDetailBreakpoint>0){var y=o.$el.children(".page-current").prevAll(".page-master").eq(0);if(y.length){var w=o.history[o.history.length-2],C=o.findMatchingRoute(w);C&&C.route===y[0].f7Page.route.route&&(b=y,a.preload||(g=c.width>=o.params.masterDetailBreakpoint))}}if(!a.force&&b.length&&!g){if(o.params.pushState&&b[0].f7Page&&o.history[o.history.length-2]!==b[0].f7Page.route.url)return o.back(o.history[o.history.length-2],Utils.extend(a,{force:!0})),o;var x=b[0].f7Page.route;return processRouteQueue.call(o,x,o.currentRoute,function(){o.loadBack({el:b},Utils.extend(a,{route:x}))},function(){}),o}if("#"===r&&(r=void 0),r&&"/"!==r[0]&&0!==r.indexOf("#")&&(r=((o.path||"/")+r).replace("//","/")),!r&&o.history.length>1&&(r=o.history[o.history.length-2]),g&&!a.force&&o.history[o.history.length-3])return o.back(o.history[o.history.length-3],Utils.extend({},a||{},{force:!0,animate:!1}));if(g&&!a.force)return o;if((n=o.findMatchingRoute(r))||r&&(n={url:r,path:r.split("?")[0],query:Utils.parseUrlQuery(r),route:{path:r.split("?")[0],url:r}}),!n)return o;if(n.route.redirect)return redirect.call(o,"back",n,a);var k,S={};if(n.route.options?Utils.extend(S,n.route.options,a):Utils.extend(S,a),S.route=n,S&&S.context&&(n.context=S.context,S.route.context=S.context),S.force&&o.params.stackPages&&(o.$el.children(".page-previous.stacked").each(function(e,t){t.f7Page&&t.f7Page.route&&t.f7Page.route.url===n.url&&(k=!0,o.loadBack({el:t},S))}),k))return o;function E(){var e=!1;n.route.keepAlive&&n.route.keepAliveData&&(o.loadBack({el:n.route.keepAliveData.pageEl},S),e=!0),"url content component pageName el componentUrl template templateUrl".split(" ").forEach(function(t){var r;n.route[t]&&!e&&(e=!0,o.loadBack(((r={})[t]=n.route[t],r),S))}),e||n.route.async&&(o.allowPageChange=!1,n.route.async.call(o,n,o.currentRoute,function(e,t){o.allowPageChange=!1,t&&t.context&&(n.context?n.context=Utils.extend({},n.context,t.context):n.context=t.context,S.route.context=n.context),o.loadBack(e,Utils.extend(S,t),!0)},function(){o.allowPageChange=!0}))}function T(){o.allowPageChange=!0}return S.preload?E():processRouteQueue.call(o,n,o.currentRoute,function(){n.route.modules?c.loadModules(Array.isArray(n.route.modules)?n.route.modules:[n.route.modules]).then(function(){E()}).catch(function(){T()}):E()},function(){T()}),o}function clearPreviousPages(){var e=this;appRouterCheck(e,"clearPreviousPages");var t=e.app,r=e.separateNavbar;e.$el.children(".page").filter(function(t,r){return!(!e.currentRoute||!e.currentRoute.modal&&!e.currentRoute.panel)||r!==e.currentPageEl}).each(function(a,n){var o=$(n),i=$(t.navbar.getElByPage(o));e.params.stackPages&&e.initialPages.indexOf(o[0])>=0?(o.addClass("stacked"),r&&i.addClass("stacked")):(e.pageCallback("beforeRemove",o,i,"previous",void 0,{}),e.removePage(o),r&&i.length&&e.removeNavbar(i))})}function clearPreviousHistory(){appRouterCheck(this,"clearPreviousHistory");var e=this.history[this.history.length-1];this.clearPreviousPages(),this.history=[e],this.view.history=[e],this.saveHistory()}var Router=function(e){function t(t,r){e.call(this,{},[void 0===r?t:r]);var a=this;a.isAppRouter=void 0===r,a.isAppRouter?Utils.extend(!1,a,{app:t,params:t.params.view,routes:t.routes||[],cache:t.cache}):Utils.extend(!1,a,{app:t,view:r,viewId:r.id,params:r.params,routes:r.routes,$el:r.$el,el:r.el,$navbarEl:r.$navbarEl,navbarEl:r.navbarEl,history:r.history,scrollHistory:r.scrollHistory,cache:t.cache,dynamicNavbar:"ios"===t.theme&&r.params.iosDynamicNavbar,separateNavbar:"ios"===t.theme&&r.params.iosDynamicNavbar&&r.params.iosSeparateDynamicNavbar,initialPages:[],initialNavbars:[]}),a.useModules(),a.tempDom=doc.createElement("div"),a.allowPageChange=!0;var n={},o={};return Object.defineProperty(a,"currentRoute",{enumerable:!0,configurable:!0,set:function(e){void 0===e&&(e={}),o=Utils.extend({},n),(n=e)&&(a.url=n.url,a.emit("routeChange",e,o,a))},get:function(){return n}}),Object.defineProperty(a,"previousRoute",{enumerable:!0,configurable:!0,get:function(){return o},set:function(e){o=e}}),a}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t.prototype.animatableNavElements=function(e,t,r,a,n){var o,i,s=this.dynamicNavbar,l=this.separateNavbar,c=this.params.iosAnimateNavbarBackIcon;function u(e,t){var r,a=e.hasClass("sliding")||t.hasClass("sliding"),n=e.hasClass("subnavbar"),o=!a||!n,i=e.find(".back .icon");return a&&c&&e.hasClass("left")&&i.length>0&&i.next("span").length&&(e=i.next("span"),r=!0),{$el:e,isIconLabel:r,leftOffset:e[0].f7NavbarLeftOffset,rightOffset:e[0].f7NavbarRightOffset,isSliding:a,isSubnavbar:n,needsOpacityTransition:o}}return s&&(o=[],i=[],e.children(".left, .right, .title, .subnavbar").each(function(t,i){var s=$(i);s.hasClass("left")&&a&&"forward"===n&&l||s.hasClass("title")&&r||o.push(u(s,e))}),t.hasClass("navbar-master")&&this.params.masterDetailBreakpoint>0&&this.app.width>=this.params.masterDetailBreakpoint||t.children(".left, .right, .title, .subnavbar").each(function(e,o){var s=$(o);s.hasClass("left")&&r&&!a&&"forward"===n&&l||s.hasClass("left")&&r&&"backward"===n&&l||s.hasClass("title")&&a||i.push(u(s,t))}),[i,o].forEach(function(e){e.forEach(function(t){var r=t,a=t.isSliding,n=t.$el,s=e===i?o:i;a&&n.hasClass("title")&&s&&s.forEach(function(e){if(e.isIconLabel){var t=e.$el[0];r.leftOffset+=t&&t.offsetLeft||0}})})})),{newNavEls:o,oldNavEls:i}},t.prototype.animate=function(e,t,r,a,n,o){var i=this;if(i.params.animateCustom)i.params.animateCustom.apply(i,[e,t,r,a,n,o]);else{var s,l,c,u,p,d,h=i.dynamicNavbar,f="ios"===i.app.theme,v="router-transition-"+n+" router-transition";if(f&&h){p=r&&r.hasClass("navbar-inner-large"),d=a&&a.hasClass("navbar-inner-large"),c=p&&!r.hasClass("navbar-inner-large-collapsed"),u=d&&!a.hasClass("navbar-inner-large-collapsed");var m=i.animatableNavElements(a,r,u,c,n);s=m.newNavEls,l=m.oldNavEls}("forward"===n?t:e).animationEnd(function(){i.dynamicNavbar&&(a&&(a.removeClass("router-navbar-transition-to-large router-navbar-transition-from-large"),a.addClass("navbar-no-title-large-transition"),Utils.nextFrame(function(){a.removeClass("navbar-no-title-large-transition")})),r&&r.removeClass("router-navbar-transition-to-large router-navbar-transition-from-large"),a.hasClass("sliding")?a.find(".title, .left, .right, .left .icon, .subnavbar").transform(""):a.find(".sliding").transform(""),r.hasClass("sliding")?r.find(".title, .left, .right, .left .icon, .subnavbar").transform(""):r.find(".sliding").transform("")),i.$el.removeClass(v),o&&o()}),h?(g(0),Utils.nextFrame(function(){g(1),i.$el.addClass(v)})):i.$el.addClass(v)}function g(e){f&&h&&(1===e&&(u&&(a.addClass("router-navbar-transition-to-large"),r.addClass("router-navbar-transition-to-large")),c&&(a.addClass("router-navbar-transition-from-large"),r.addClass("router-navbar-transition-from-large"))),s.forEach(function(t){var r=t.$el,a="forward"===n?t.rightOffset:t.leftOffset;t.isSliding&&(t.isSubnavbar&&d?r[0].style.setProperty("transform","translate3d("+a*(1-e)+"px, calc(-1 * var(--f7-navbar-large-collapse-progress) * var(--f7-navbar-large-title-height)), 0)","important"):r.transform("translate3d("+a*(1-e)+"px,0,0)"))}),l.forEach(function(t){var r=t.$el,a="forward"===n?t.leftOffset:t.rightOffset;t.isSliding&&(t.isSubnavbar&&p?r.transform("translate3d("+a*e+"px, calc(-1 * var(--f7-navbar-large-collapse-progress) * var(--f7-navbar-large-title-height)), 0)"):r.transform("translate3d("+a*e+"px,0,0)"))}))}},t.prototype.removeModal=function(e){this.removeEl(e)},t.prototype.removeTabContent=function(e){$(e).html("")},t.prototype.removeNavbar=function(e){this.removeEl(e)},t.prototype.removePage=function(e){var t=$(e),r=t&&t[0]&&t[0].f7Page;r&&r.route&&r.route.route&&r.route.route.keepAlive?t.remove():this.removeEl(e)},t.prototype.removeEl=function(e){if(e){var t=$(e);0!==t.length&&(t.find(".tab").each(function(e,t){$(t).children().each(function(e,t){t.f7Component&&($(t).trigger("tab:beforeremove"),t.f7Component.$destroy())})}),t[0].f7Component&&t[0].f7Component.$destroy&&t[0].f7Component.$destroy(),this.params.removeElements&&(this.params.removeElementsWithTimeout?setTimeout(function(){t.remove()},this.params.removeElementsTimeout):t.remove()))}},t.prototype.getPageEl=function(e){if("string"==typeof e)this.tempDom.innerHTML=e;else{if($(e).hasClass("page"))return e;this.tempDom.innerHTML="",$(this.tempDom).append(e)}return this.findElement(".page",this.tempDom)},t.prototype.findElement=function(e,t,r){var a=this.view,n=this.app,o=$(t),i=e;r&&(i+=":not(.stacked)");var s=o.find(i).filter(function(e,t){return 0===$(t).parents(".popup, .dialog, .popover, .actions-modal, .sheet-modal, .login-screen, .page").length});return s.length>1&&("string"==typeof a.selector&&(s=o.find(a.selector+" "+i)),s.length>1&&(s=o.find("."+n.params.viewMainClass+" "+i))),1===s.length?s:(r||(s=this.findElement(i,o,!0)),s&&1===s.length?s:s&&s.length>1?$(s[0]):void 0)},t.prototype.flattenRoutes=function(e){void 0===e&&(e=this.routes);var t=this,r=[];return e.forEach(function(e){var a=!1;if("tabs"in e&&e.tabs){var n=e.tabs.map(function(t){var r=Utils.extend({},e,{path:(e.path+"/"+t.path).replace("///","/").replace("//","/"),parentPath:e.path,tab:t});return delete r.tabs,delete r.routes,r});a=!0,r=r.concat(t.flattenRoutes(n))}if("detailRoutes"in e){var o=e.detailRoutes.map(function(t){var r=Utils.extend({},t);return r.masterRoute=e,r.masterRoutePath=e.path,r});r=r.concat(e,t.flattenRoutes(o))}if("routes"in e){var i=e.routes.map(function(t){var r=Utils.extend({},t);return r.path=(e.path+"/"+r.path).replace("///","/").replace("//","/"),r});r=a?r.concat(t.flattenRoutes(i)):r.concat(e,t.flattenRoutes(i))}"routes"in e||"tabs"in e&&e.tabs||"detailRoutes"in e||r.push(e)}),r},t.prototype.parseRouteUrl=function(e){if(!e)return{};var t=Utils.parseUrlQuery(e),r=e.split("#")[1],a=e.split("#")[0].split("?")[0];return{query:t,hash:r,params:{},url:e,path:a}},t.prototype.constructRouteUrl=function(e,t){void 0===t&&(t={});var r,a=t.params,n=t.query,o=e.path,i=pathToRegexp_1.compile(o);try{r=i(a||{})}catch(e){throw new Error("Framework7: error constructing route URL from passed params:\nRoute: "+o+"\n"+e.toString())}return n&&(r+="string"==typeof n?"?"+n:"?"+Utils.serializeObject(n)),r},t.prototype.findTabRoute=function(e){var t,r=$(e),a=this.currentRoute.route.parentPath,n=r.attr("id");return this.flattenRoutes(this.routes).forEach(function(e){e.parentPath===a&&e.tab&&e.tab.id===n&&(t=e)}),t},t.prototype.findRouteByKey=function(e,t){var r,a=this.routes;return this.flattenRoutes(a).forEach(function(a){r||a[e]===t&&(r=a)}),r},t.prototype.findMatchingRoute=function(e){if(e){var t,r=this.routes,a=this.flattenRoutes(r),n=this.parseRouteUrl(e),o=n.path,i=n.query,s=n.hash,l=n.params;return a.forEach(function(r){if(!t){var a,n,c=[],u=[r.path];if(r.alias&&("string"==typeof r.alias?u.push(r.alias):Array.isArray(r.alias)&&r.alias.forEach(function(e){u.push(e)})),u.forEach(function(e){a||(a=pathToRegexp_1(e,c).exec(o))}),a)c.forEach(function(e,t){if("number"!=typeof e.name){var r=a[t+1];l[e.name]=r}}),r.parentPath&&(n=o.split("/").slice(0,r.parentPath.split("/").length-1).join("/")),t={query:i,hash:s,params:l,url:e,path:o,parentPath:n,route:r,name:r.name}}}),t}},t.prototype.replaceRequestUrlParams=function(e,t){void 0===e&&(e=""),void 0===t&&(t={});var r=e;return"string"==typeof r&&r.indexOf("{{")>=0&&t&&t.route&&t.route.params&&Object.keys(t.route.params).length&&Object.keys(t.route.params).forEach(function(e){var a=new RegExp("{{"+e+"}}","g");r=r.replace(a,t.route.params[e]||"")}),r},t.prototype.removeFromXhrCache=function(e){for(var t=this.cache.xhr,r=!1,a=0;a<t.length;a+=1)t[a].url===e&&(r=a);!1!==r&&t.splice(r,1)},t.prototype.xhrRequest=function(e,t){var r=this,a=r.params,n=t.ignoreCache,o=e,i=o.indexOf("?")>=0;return a.passRouteQueryToRequest&&t&&t.route&&t.route.query&&Object.keys(t.route.query).length&&(o+=(i?"&":"?")+Utils.serializeObject(t.route.query),i=!0),a.passRouteParamsToRequest&&t&&t.route&&t.route.params&&Object.keys(t.route.params).length&&(o+=(i?"&":"?")+Utils.serializeObject(t.route.params),i=!0),o.indexOf("{{")>=0&&(o=r.replaceRequestUrlParams(o,t)),a.xhrCacheIgnoreGetParameters&&o.indexOf("?")>=0&&(o=o.split("?")[0]),new Promise(function(e,i){if(a.xhrCache&&!n&&o.indexOf("nocache")<0&&a.xhrCacheIgnore.indexOf(o)<0)for(var s=0;s<r.cache.xhr.length;s+=1){var l=r.cache.xhr[s];if(l.url===o&&Utils.now()-l.time<a.xhrCacheDuration)return void e(l.content)}r.xhr=r.app.request({url:o,method:"GET",beforeSend:function(e){r.emit("routerAjaxStart",e,t)},complete:function(n,s){r.emit("routerAjaxComplete",n),"error"!==s&&"timeout"!==s&&n.status>=200&&n.status<300||0===n.status?(a.xhrCache&&""!==n.responseText&&(r.removeFromXhrCache(o),r.cache.xhr.push({url:o,time:Utils.now(),content:n.responseText})),r.emit("routerAjaxSuccess",n,t),e(n.responseText)):(r.emit("routerAjaxError",n,t),i(n))},error:function(e){r.emit("routerAjaxError",e,t),i(e)}})})},t.prototype.removeThemeElements=function(e){var t,r=this.app.theme;"ios"===r?t=".md-only, .aurora-only, .if-md, .if-aurora, .if-not-ios, .not-ios":"md"===r?t=".ios-only, .aurora-only, .if-ios, .if-aurora, .if-not-md, .not-md":"aurora"===r&&(t=".ios-only, .md-only, .if-ios, .if-md, .if-not-aurora, .not-aurora"),$(e).find(t).remove()},t.prototype.getPageData=function(e,t,r,a,n,o){void 0===n&&(n={});var i,s,l=$(e).eq(0),c=$(t).eq(0),u=l[0].f7Page||{};if(("next"===r&&"current"===a||"current"===r&&"previous"===a)&&(i="forward"),("current"===r&&"next"===a||"previous"===r&&"current"===a)&&(i="backward"),u&&!u.fromPage){var p=$(o);p.length&&(s=p[0].f7Page)}(s=u.pageFrom||s)&&s.pageFrom&&(s.pageFrom=null);var d={app:this.app,view:this.view,router:this,$el:l,el:l[0],$pageEl:l,pageEl:l[0],$navbarEl:c,navbarEl:c[0],name:l.attr("data-name"),position:r,from:r,to:a,direction:i,route:u.route?u.route:n,pageFrom:s};return l[0].f7Page=d,d},t.prototype.pageCallback=function(e,t,r,a,n,o,i){if(void 0===o&&(o={}),t){var s=this,l=$(t);if(l.length){var c=$(r),u=o.route,p=s.params.restoreScrollTopOnBack&&!(s.params.masterDetailBreakpoint>0&&l.hasClass("page-master")&&s.app.width>=s.params.masterDetailBreakpoint),d=l[0].f7Page&&l[0].f7Page.route&&l[0].f7Page.route.route&&l[0].f7Page.route.route.keepAlive;"beforeRemove"===e&&d&&(e="beforeUnmount");var h="page"+(e[0].toUpperCase()+e.slice(1,e.length)),f="page:"+e.toLowerCase(),v={};(v="beforeRemove"===e&&l[0].f7Page?Utils.extend(l[0].f7Page,{from:a,to:n,position:a}):s.getPageData(l[0],c[0],a,n,u,i)).swipeBack=!!o.swipeBack;var m=o.route?o.route.route:{},g=m.on;void 0===g&&(g={});var b=m.once;if(void 0===b&&(b={}),o.on&&Utils.extend(g,o.on),o.once&&Utils.extend(b,o.once),"mounted"===e&&C(),"init"===e){if(p&&("previous"===a||!a)&&"current"===n&&s.scrollHistory[v.route.url]&&!l.hasClass("no-restore-scroll")){var y=l.find(".page-content");y.length>0&&(y=y.filter(function(e,t){return 0===$(t).parents(".tab:not(.tab-active)").length&&!$(t).is(".tab:not(.tab-active)")})),y.scrollTop(s.scrollHistory[v.route.url])}if(C(),l[0].f7PageInitialized)return l.trigger("page:reinit",v),void s.emit("pageReinit",v);l[0].f7PageInitialized=!0}if(p&&"beforeOut"===e&&"current"===a&&"previous"===n){var w=l.find(".page-content");w.length>0&&(w=w.filter(function(e,t){return 0===$(t).parents(".tab:not(.tab-active)").length&&!$(t).is(".tab:not(.tab-active)")})),s.scrollHistory[v.route.url]=w.scrollTop()}p&&"beforeOut"===e&&"current"===a&&"next"===n&&delete s.scrollHistory[v.route.url],l.trigger(f,v),s.emit(h,v),"beforeRemove"!==e&&"beforeUnmount"!==e||(l[0].f7RouteEventsAttached&&(l[0].f7RouteEventsOn&&Object.keys(l[0].f7RouteEventsOn).forEach(function(e){l.off(Utils.eventNameToColonCase(e),l[0].f7RouteEventsOn[e])}),l[0].f7RouteEventsOnce&&Object.keys(l[0].f7RouteEventsOnce).forEach(function(e){l.off(Utils.eventNameToColonCase(e),l[0].f7RouteEventsOnce[e])}),l[0].f7RouteEventsAttached=null,l[0].f7RouteEventsOn=null,l[0].f7RouteEventsOnce=null,delete l[0].f7RouteEventsAttached,delete l[0].f7RouteEventsOn,delete l[0].f7RouteEventsOnce),d||(l[0].f7Page&&l[0].f7Page.navbarEl&&delete l[0].f7Page.navbarEl.f7Page,l[0].f7Page=null))}}function C(){l[0].f7RouteEventsAttached||(l[0].f7RouteEventsAttached=!0,g&&Object.keys(g).length>0&&(l[0].f7RouteEventsOn=g,Object.keys(g).forEach(function(e){g[e]=g[e].bind(s),l.on(Utils.eventNameToColonCase(e),g[e])})),b&&Object.keys(b).length>0&&(l[0].f7RouteEventsOnce=b,Object.keys(b).forEach(function(e){b[e]=b[e].bind(s),l.once(Utils.eventNameToColonCase(e),b[e])})))}},t.prototype.saveHistory=function(){this.view.history=this.history,this.params.pushState&&(win.localStorage["f7router-"+this.view.id+"-history"]=JSON.stringify(this.history))},t.prototype.restoreHistory=function(){this.params.pushState&&win.localStorage["f7router-"+this.view.id+"-history"]&&(this.history=JSON.parse(win.localStorage["f7router-"+this.view.id+"-history"]),this.view.history=this.history)},t.prototype.clearHistory=function(){this.history=[],this.view&&(this.view.history=[]),this.saveHistory()},t.prototype.updateCurrentUrl=function(e){appRouterCheck(this,"updateCurrentUrl"),this.history.length?this.history[this.history.length-1]=e:this.history.push(e);var t=this.parseRouteUrl(e),r=t.query,a=t.hash,n=t.params,o=t.url,i=t.path;if(this.currentRoute&&Utils.extend(this.currentRoute,{query:r,hash:a,params:n,url:o,path:i}),this.params.pushState){var s=this.params.pushStateRoot||"";History.replace(this.view.id,{url:e},s+this.params.pushStateSeparator+e)}this.saveHistory(),this.emit("routeUrlUpdate",this.currentRoute,this)},t.prototype.init=function(){var e=this,t=e.app,r=e.view;(r&&e.params.iosSwipeBack&&"ios"===t.theme||r&&e.params.mdSwipeBack&&"md"===t.theme||r&&e.params.auroraSwipeBack&&"aurora"===t.theme)&&SwipeBack(e),e.dynamicNavbar&&!e.separateNavbar&&e.$el.addClass("router-dynamic-navbar-inside");var a,n,o,i=e.params.url,s=doc.location.href.split(doc.location.origin)[1],l=e.params,c=l.pushState,u=l.pushStateOnLoad,p=l.pushStateSeparator,d=l.pushStateAnimateOnLoad,h=e.params.pushStateRoot;(win.cordova&&c&&!p&&!h&&doc.location.pathname.indexOf("index.html")&&(console.warn("Framework7: wrong or not complete pushState configuration, trying to guess pushStateRoot"),h=doc.location.pathname.split("index.html")[0]),c&&u?(h&&s.indexOf(h)>=0&&""===(s=s.split(h)[1])&&(s="/"),i=p.length>0&&s.indexOf(p)>=0?s.split(p)[1]:s,e.restoreHistory(),e.history.indexOf(i)>=0?e.history=e.history.slice(0,e.history.indexOf(i)+1):e.params.url===i?e.history=[i]:History.state&&History.state[r.id]&&History.state[r.id].url===e.history[e.history.length-1]?i=e.history[e.history.length-1]:e.history=[s.split(p)[0]||"/",i],e.history.length>1?a=!0:e.history=[],e.saveHistory()):(i||(i=s),doc.location.search&&i.indexOf("?")<0&&(i+=doc.location.search),doc.location.hash&&i.indexOf("#")<0&&(i+=doc.location.hash)),e.history.length>1?(n=e.findMatchingRoute(e.history[0]))||(n=Utils.extend(e.parseRouteUrl(e.history[0]),{route:{url:e.history[0],path:e.history[0].split("?")[0]}})):(n=e.findMatchingRoute(i))||(n=Utils.extend(e.parseRouteUrl(i),{route:{url:i,path:i.split("?")[0]}})),e.params.stackPages&&e.$el.children(".page").each(function(t,r){var a=$(r);e.initialPages.push(a[0]),e.separateNavbar&&a.children(".navbar").length>0&&e.initialNavbars.push(a.children(".navbar").find(".navbar-inner")[0])}),0===e.$el.children(".page:not(.stacked)").length&&i)?e.navigate(i,{initial:!0,reloadCurrent:!0,pushState:!1}):(e.currentRoute=n,e.$el.children(".page:not(.stacked)").each(function(t,r){var a,n=$(r);n.addClass("page-current"),e.separateNavbar&&((a=n.children(".navbar").children(".navbar-inner")).length>0?(e.$navbarEl.parents(doc).length||e.$el.prepend(e.$navbarEl),a.addClass("navbar-current"),e.$navbarEl.append(a),a.children(".title-large").length&&a.addClass("navbar-inner-large"),n.children(".navbar").remove()):(e.$navbarEl.addClass("navbar-hidden"),a.children(".title-large").length&&e.$navbarEl.addClass("navbar-hidden navbar-large-hidden"))),e.currentRoute&&e.currentRoute.route&&e.currentRoute.route.master&&e.params.masterDetailBreakpoint>0&&(n.addClass("page-master"),n.trigger("page:role",{role:"master"}),a&&a.length&&a.addClass("navbar-master"));var i={route:e.currentRoute};e.currentRoute&&e.currentRoute.route&&e.currentRoute.route.options&&Utils.extend(i,e.currentRoute.route.options),e.currentPageEl=n[0],e.separateNavbar&&a.length&&(e.currentNavbarEl=a[0]),e.removeThemeElements(n),e.separateNavbar&&a.length&&e.removeThemeElements(a),i.route.route.tab&&(o=!0,e.tabLoad(i.route.route.tab,Utils.extend({},i))),e.pageCallback("init",n,a,"current",void 0,i)}),a&&e.navigate(i,{initial:!0,pushState:!1,history:!1,animate:d,once:{pageAfterIn:function(){(e.params.preloadPreviousPage||e.params[t.theme+"SwipeBack"])&&e.history.length>2&&e.back({preload:!0})}}}),a||o||(e.history.push(i),e.saveHistory()));!(i&&c&&u)||History.state&&History.state[r.id]||History.initViewState(r.id,{url:i}),e.emit("local::init routerInit",e)},t.prototype.destroy=function(){var e=this;e.emit("local::destroy routerDestroy",e),Object.keys(e).forEach(function(t){e[t]=null,delete e[t]}),e=null},t}(Framework7Class);Router.prototype.forward=forward,Router.prototype.load=load,Router.prototype.navigate=navigate,Router.prototype.refreshPage=refreshPage,Router.prototype.tabLoad=tabLoad,Router.prototype.tabRemove=tabRemove,Router.prototype.modalLoad=modalLoad,Router.prototype.modalRemove=modalRemove,Router.prototype.backward=backward,Router.prototype.loadBack=loadBack,Router.prototype.back=back,Router.prototype.clearPreviousPages=clearPreviousPages,Router.prototype.clearPreviousHistory=clearPreviousHistory;var RouterModule={name:"router",static:{Router:Router},instance:{cache:{xhr:[],templates:[],components:[]}},create:function(){this.app?this.params.router&&(this.router=new Router(this.app,this)):this.router=new Router(this)}},View=function(e){function t(t,r,a){void 0===a&&(a={}),e.call(this,a,[t]);var n,o,i,s=t,l=$(r),c=this;return c.params=Utils.extend({routes:[],routesAdd:[]},s.params.view,a),c.params.routes.length>0?c.routes=c.params.routes:c.routes=[].concat(s.routes,c.params.routesAdd),n="string"==typeof r?r:(l.attr("id")?"#"+l.attr("id"):"")+(l.attr("class")?"."+l.attr("class").replace(/ /g,".").replace(".active",""):""),"ios"===s.theme&&c.params.iosDynamicNavbar&&c.params.iosSeparateDynamicNavbar&&0===(o=l.children(".navbar").eq(0)).length&&(o=$('<div class="navbar"></div>')),Utils.extend(!1,c,{app:s,$el:l,el:l[0],name:c.params.name,main:c.params.main||l.hasClass("view-main"),$navbarEl:o,navbarEl:o?o[0]:void 0,selector:n,history:[],scrollHistory:{}}),l[0].f7View=c,c.useModules(),s.views.push(c),c.main&&(s.views.main=c),c.name&&(s.views[c.name]=c),c.index=s.views.indexOf(c),i=c.name?"view_"+c.name:c.main?"view_main":"view_"+c.index,c.id=i,s.initialized?c.init():s.on("init",function(){c.init()}),c}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t.prototype.destroy=function(){var e=this,t=e.app;e.$el.trigger("view:beforedestroy",e),e.emit("local::beforeDestroy viewBeforeDestroy",e),t.off("resize",e.checkmasterDetailBreakpoint),e.main?(t.views.main=null,delete t.views.main):e.name&&(t.views[e.name]=null,delete t.views[e.name]),e.$el[0].f7View=null,delete e.$el[0].f7View,t.views.splice(t.views.indexOf(e),1),e.params.router&&e.router&&e.router.destroy(),e.emit("local::destroy viewDestroy",e),Object.keys(e).forEach(function(t){e[t]=null,delete e[t]}),e=null},t.prototype.checkmasterDetailBreakpoint=function(){var e=this.app,t=this.$el.hasClass("view-master-detail");e.width>=this.params.masterDetailBreakpoint?(this.$el.addClass("view-master-detail"),t||(this.emit("local::masterDetailBreakpoint viewMasterDetailBreakpoint"),this.$el.trigger("view:masterDetailBreakpoint",this))):(this.$el.removeClass("view-master-detail"),t&&(this.emit("local::masterDetailBreakpoint viewMasterDetailBreakpoint"),this.$el.trigger("view:masterDetailBreakpoint",this)))},t.prototype.initMasterDetail=function(){var e=this.app;this.checkmasterDetailBreakpoint=this.checkmasterDetailBreakpoint.bind(this),this.checkmasterDetailBreakpoint(),e.on("resize",this.checkmasterDetailBreakpoint)},t.prototype.init=function(){this.params.router&&(this.params.masterDetailBreakpoint>0&&this.initMasterDetail(),this.router.init(),this.$el.trigger("view:init",this),this.emit("local::init viewInit",this))},t}(Framework7Class);function initClicks(e){e.on("click",function(t){var r=$(t.target),a=r.closest("a"),n=a.length>0,o=n&&a.attr("href");if(n&&(a.is(e.params.clicks.externalLinks)||o&&o.indexOf("javascript:")>=0)){var i=a.attr("target");o&&win.cordova&&win.cordova.InAppBrowser&&("_system"===i||"_blank"===i)&&(t.preventDefault(),win.cordova.InAppBrowser.open(o,i))}else{Object.keys(e.modules).forEach(function(a){var n=e.modules[a].clicks;n&&(t.preventF7Router||Object.keys(n).forEach(function(a){var o=r.closest(a).eq(0);o.length>0&&n[a].call(e,o,o.dataset(),t)}))});var s={};if(n&&(t.preventDefault(),s=a.dataset()),!t.preventF7Router&&!a.hasClass("prevent-router")&&!a.hasClass("router-prevent")&&(o&&o.length>0&&"#"!==o[0]||a.hasClass("back"))){var l;if(s.view?l=$(s.view)[0].f7View:(l=r.parents(".view")[0]&&r.parents(".view")[0].f7View,!a.hasClass("back")&&l&&l.params.linksView&&("string"==typeof l.params.linksView?l=$(l.params.linksView)[0].f7View:l.params.linksView instanceof View&&(l=l.params.linksView))),l||e.views.main&&(l=e.views.main),!l||!l.router)return;if(s.context&&"string"==typeof s.context)try{s.context=JSON.parse(s.context)}catch(e){}a[0].f7RouteProps&&(s.props=a[0].f7RouteProps),a.hasClass("back")?l.router.back(o,s):l.router.navigate(o,s)}}})}View.use(RouterModule);var ClicksModule={name:"clicks",params:{clicks:{externalLinks:".external"}},on:{init:function(){initClicks(this)}}},RouterTemplateLoaderModule={name:"routerTemplateLoader",proto:{templateLoader:function(e,t,r,a,n){var o=this;function i(e){var t,i;try{if("function"==typeof(i=r.context||{}))i=i.call(o);else if("string"==typeof i)try{i=JSON.parse(i)}catch(e){throw n(),e}t="function"==typeof e?e(i):Template7.compile(e)(Utils.extend({},i||{},{$app:o.app,$root:Utils.extend({},o.app.data,o.app.methods),$route:r.route,$f7route:r.route,$router:o,$f7router:o,$theme:{ios:"ios"===o.app.theme,md:"md"===o.app.theme,aurora:"aurora"===o.app.theme}}))}catch(e){throw n(),e}a(t,{context:i})}t?(o.xhr&&(o.xhr.abort(),o.xhr=!1),o.xhrRequest(t,r).then(function(e){i(e)}).catch(function(){n()})):i(e)},modalTemplateLoader:function(e,t,r,a,n){return this.templateLoader(e,t,r,function(e){a(e)},n)},tabTemplateLoader:function(e,t,r,a,n){return this.templateLoader(e,t,r,function(e){a(e)},n)},pageTemplateLoader:function(e,t,r,a,n){var o=this;return o.templateLoader(e,t,r,function(e,t){void 0===t&&(t={}),a(o.getPageEl(e),t)},n)}}},RouterComponentLoaderModule={name:"routerComponentLoader",proto:{componentLoader:function(e,t,r,a,n){void 0===r&&(r={});var o,i=this,s=i.app,l="string"==typeof e?e:t,c=i.replaceRequestUrlParams(l,r);function u(e){var t=r.context||{};if("function"==typeof t)t=t.call(i);else if("string"==typeof t)try{t=JSON.parse(t)}catch(e){throw n(),e}var o=Utils.merge({},t,{$route:r.route,$f7route:r.route,$router:i,$f7router:i,$theme:{ios:"ios"===s.theme,md:"md"===s.theme,aurora:"aurora"===s.theme}}),l=s.component.create(e,o);a(l.el)}c&&i.cache.components.forEach(function(e){e.url===c&&(o=e.component)}),c&&o?u(o):c&&!o?(i.xhr&&(i.xhr.abort(),i.xhr=!1),i.xhrRequest(l,r).then(function(e){var t=s.component.parse(e);i.cache.components.push({url:c,component:t}),u(t)}).catch(function(e){throw n(),e})):u(e)},modalComponentLoader:function(e,t,r,a,n,o){this.componentLoader(t,r,a,function(e){n(e)},o)},tabComponentLoader:function(e,t,r,a,n,o){this.componentLoader(t,r,a,function(e){n(e)},o)},pageComponentLoader:function(e,t,r,a,n,o){this.componentLoader(t,r,a,function(e,t){void 0===t&&(t={}),n(e,t)},o)}}},HistoryModule={name:"history",static:{history:History},on:{init:function(){History.init(this)}}},keyPrefix="f7storage-",Storage={get:function(e){return new Promise(function(t,r){try{t(JSON.parse(win.localStorage.getItem(""+keyPrefix+e)))}catch(e){r(e)}})},set:function(e,t){return new Promise(function(r,a){try{win.localStorage.setItem(""+keyPrefix+e,JSON.stringify(t)),r()}catch(e){a(e)}})},remove:function(e){return new Promise(function(t,r){try{win.localStorage.removeItem(""+keyPrefix+e),t()}catch(e){r(e)}})},clear:function(){},length:function(){},keys:function(){return new Promise(function(e,t){try{e(Object.keys(win.localStorage).filter(function(e){return 0===e.indexOf(keyPrefix)}).map(function(e){return e.replace(keyPrefix,"")}))}catch(e){t(e)}})},forEach:function(e){return new Promise(function(t,r){try{Object.keys(win.localStorage).filter(function(e){return 0===e.indexOf(keyPrefix)}).forEach(function(t,r){var a=t.replace(keyPrefix,"");Storage.get(a).then(function(t){e(a,t,r)})}),t()}catch(e){r(e)}})}},StorageModule={name:"storage",static:{Storage:Storage,storage:Storage}};function vnode(e,t,r,a,n){return{sel:e,data:t,children:r,text:a,elm:n,key:void 0===t?void 0:t.key}}var array=Array.isArray;function primitive(e){return"string"==typeof e||"number"==typeof e}function addNS(e,t,r){if(e.ns="http://www.w3.org/2000/svg","foreignObject"!==r&&void 0!==t)for(var a=0;a<t.length;++a){var n=t[a].data;void 0!==n&&addNS(n,t[a].children,t[a].sel)}}function h(e,t,r){var a,n,o,i={};if(void 0!==r?(i=t,array(r)?a=r:primitive(r)?n=r:r&&r.sel&&(a=[r])):void 0!==t&&(array(t)?a=t:primitive(t)?n=t:t&&t.sel?a=[t]:i=t),array(a))for(o=0;o<a.length;++o)primitive(a[o])&&(a[o]=vnode(void 0,void 0,void 0,a[o],void 0));return"s"!==e[0]||"v"!==e[1]||"g"!==e[2]||3!==e.length&&"."!==e[3]&&"#"!==e[3]||addNS(i,a,e),vnode(e,i,a,n,void 0)}var selfClosing="area base br col command embed hr img input keygen link menuitem meta param source track wbr".split(" "),propsAttrs="hidden checked disabled readonly selected autocomplete autofocus autoplay required multiple value indeterminate".split(" "),booleanProps="hidden checked disabled readonly selected autocomplete autofocus autoplay required multiple readOnly indeterminate".split(" "),tempDom=doc.createElement("div");function getHooks(e,t,r,a){var n={};if(!e||!e.attrs||!e.attrs.class)return n;var o=e.attrs.class,i=[],s=[],l=[],c=[];return o.split(" ").forEach(function(e){r||i.push.apply(i,t.getVnodeHooks("insert",e)),s.push.apply(s,t.getVnodeHooks("destroy",e)),l.push.apply(l,t.getVnodeHooks("update",e)),c.push.apply(c,t.getVnodeHooks("postpatch",e))}),a&&!r&&c.push(function(e,t){var r=t||e;r&&r.data&&r.data.context&&r.data.context.$options.updated&&r.data.context.$options.updated()}),0===i.length&&0===s.length&&0===l.length&&0===c.length?n:(i.length&&(n.insert=function(e){i.forEach(function(t){return t(e)})}),s.length&&(n.destroy=function(e){s.forEach(function(t){return t(e)})}),l.length&&(n.update=function(e,t){l.forEach(function(r){return r(e,t)})}),c.length&&(n.postpatch=function(e,t){c.forEach(function(r){return r(e,t)})}),n)}function getEventHandler(e,t,r){void 0===r&&(r={});var a,n,o=r.stop,i=r.prevent,s=r.once,l=!1,c=[],u=!0;if((a=e.indexOf("(")<0?e:e.split("(")[0]).indexOf(".")>=0)a.split(".").forEach(function(e,r){if(0!==r||"this"!==e){if(0===r&&"window"===e)return n=win,void(u=!1);if(n||(n=t),!n[e])throw new Error("Framework7: Component doesn't have method \""+a.split(".").slice(0,r+1).join(".")+'"');n=n[e]}});else{if(!t[a])throw new Error("Framework7: Component doesn't have method \""+a+'"');n=t[a]}return u&&(n=n.bind(t)),function(){for(var r=[],a=arguments.length;a--;)r[a]=arguments[a];var u=r[0];s&&l||(o&&u.stopPropagation(),i&&u.preventDefault(),l=!0,e.indexOf("(")<0?c=r:e.split("(")[1].split(")")[0].replace(/'[^']*'|"[^"]*"/g,function(e){return e.replace(/,/g,"<_comma_>")}).split(",").map(function(e){return e.replace(/<_comma_>/g,",")}).forEach(function(e){var r=e.trim();if(isNaN(r))if("true"===r)r=!0;else if("false"===r)r=!1;else if("null"===r)r=null;else if("undefined"===r)r=void 0;else if('"'===r[0])r=r.replace(/"/g,"");else if("'"===r[0])r=r.replace(/'/g,"");else if(r.indexOf(".")>0){var a;r.split(".").forEach(function(e){a||(a=t),a=a[e]}),r=a}else r=t[r];else r=parseFloat(r);c.push(r)}),n.apply(void 0,c))}}function getData(e,t,r,a,n){var o={context:t},i=e.attributes;Array.prototype.forEach.call(i,function(e){var r=e.name,a=e.value;if(propsAttrs.indexOf(r)>=0)o.props||(o.props={}),"readonly"===r&&(r="readOnly"),booleanProps.indexOf(r)>=0?o.props[r]=!1!==a:o.props[r]=a;else if("key"===r)o.key=a;else if(0===r.indexOf("@")){o.on||(o.on={});var i=r.substr(1),s=!1,l=!1,c=!1;i.indexOf(".")>=0&&i.split(".").forEach(function(e,t){0===t?i=e:("stop"===e&&(s=!0),"prevent"===e&&(l=!0),"once"===e&&(c=!0))}),o.on[i]=getEventHandler(a,t,{stop:s,prevent:l,once:c})}else if("style"===r)if(a.indexOf("{")>=0&&a.indexOf("}")>=0)try{o.style=JSON.parse(a)}catch(e){o.attrs||(o.attrs={}),o.attrs.style=a}else o.attrs||(o.attrs={}),o.attrs.style=a;else o.attrs||(o.attrs={}),o.attrs[r]=a,"id"!==r||o.key||n||(o.key=a)});var s=getHooks(o,r,a,n);return s.prepatch=function(e,t){e&&t&&e&&e.data&&e.data.props&&Object.keys(e.data.props).forEach(function(r){booleanProps.indexOf(r)<0||(t.data||(t.data={}),t.data.props||(t.data.props={}),!0!==e.data.props[r]||r in t.data.props||(t.data.props[r]=!1))})},s&&(o.hook=s),o}function getChildren(e,t,r,a){for(var n=[],o=e.childNodes,i=0;i<o.length;i+=1){var s=elementToVNode(o[i],t,r,a);s&&n.push(s)}return n}function elementToVNode(e,t,r,a,n){if(1===e.nodeType){var o=e instanceof win.SVGElement?e.nodeName:e.nodeName.toLowerCase();return h(o,getData(e,t,r,a,n),selfClosing.indexOf(o)>=0?[]:getChildren(e,t,r,a))}return 3===e.nodeType?e.textContent:null}function vdom(e,t,r,a){var n;void 0===e&&(e=""),tempDom.innerHTML=e.trim();for(var o=0;o<tempDom.childNodes.length;o+=1)n||1!==tempDom.childNodes[o].nodeType||(n=tempDom.childNodes[o]);var i=elementToVNode(n,t,r,a,!0);return tempDom.innerHTML="",i}function createElement(e){return document.createElement(e)}function createElementNS(e,t){return document.createElementNS(e,t)}function createTextNode(e){return document.createTextNode(e)}function createComment(e){return document.createComment(e)}function insertBefore$1(e,t,r){e.insertBefore(t,r)}function removeChild(e,t){e&&e.removeChild(t)}function appendChild(e,t){e.appendChild(t)}function parentNode(e){return e.parentNode}function nextSibling(e){return e.nextSibling}function tagName(e){return e.tagName}function setTextContent(e,t){e.textContent=t}function getTextContent(e){return e.textContent}function isElement(e){return 1===e.nodeType}function isText(e){return 3===e.nodeType}function isComment(e){return 8===e.nodeType}var htmlDomApi={createElement:createElement,createElementNS:createElementNS,createTextNode:createTextNode,createComment:createComment,insertBefore:insertBefore$1,removeChild:removeChild,appendChild:appendChild,parentNode:parentNode,nextSibling:nextSibling,tagName:tagName,setTextContent:setTextContent,getTextContent:getTextContent,isElement:isElement,isText:isText,isComment:isComment};function isUndef(e){return void 0===e}function isDef(e){return void 0!==e}var emptyNode=vnode("",{},[],void 0,void 0);function sameVnode(e,t){return e.key===t.key&&e.sel===t.sel}function isVnode(e){return void 0!==e.sel}function createKeyToOldIdx(e,t,r){var a,n,o,i={};for(a=t;a<=r;++a)null!=(o=e[a])&&void 0!==(n=o.key)&&(i[n]=a);return i}var hooks=["create","update","remove","destroy","pre","post"];function init(e,t){var r,a,n={},o=void 0!==t?t:htmlDomApi;for(r=0;r<hooks.length;++r)for(n[hooks[r]]=[],a=0;a<e.length;++a){var i=e[a][hooks[r]];void 0!==i&&n[hooks[r]].push(i)}function s(e){var t=e.id?"#"+e.id:"",r=e.className?"."+e.className.split(" ").join("."):"";return vnode(o.tagName(e).toLowerCase()+t+r,{},[],void 0,e)}function l(e,t){return function(){if(0==--t){var r=o.parentNode(e);o.removeChild(r,e)}}}function c(e,t){var r,a=e.data;void 0!==a&&isDef(r=a.hook)&&isDef(r=r.init)&&(r(e),a=e.data);var i=e.children,s=e.sel;if("!"===s)isUndef(e.text)&&(e.text=""),e.elm=o.createComment(e.text);else if(void 0!==s){var l=s.indexOf("#"),u=s.indexOf(".",l),p=l>0?l:s.length,d=u>0?u:s.length,h=-1!==l||-1!==u?s.slice(0,Math.min(p,d)):s,f=e.elm=isDef(a)&&isDef(r=a.ns)?o.createElementNS(r,h):o.createElement(h);for(p<d&&f.setAttribute("id",s.slice(p+1,d)),u>0&&f.setAttribute("class",s.slice(d+1).replace(/\./g," ")),r=0;r<n.create.length;++r)n.create[r](emptyNode,e);if(array(i))for(r=0;r<i.length;++r){var v=i[r];null!=v&&o.appendChild(f,c(v,t))}else primitive(e.text)&&o.appendChild(f,o.createTextNode(e.text));isDef(r=e.data.hook)&&(r.create&&r.create(emptyNode,e),r.insert&&t.push(e))}else e.elm=o.createTextNode(e.text);return e.elm}function u(e,t,r,a,n,i){for(;a<=n;++a){var s=r[a];null!=s&&o.insertBefore(e,c(s,i),t)}}function p(e){var t,r,a=e.data;if(void 0!==a){for(isDef(t=a.hook)&&isDef(t=t.destroy)&&t(e),t=0;t<n.destroy.length;++t)n.destroy[t](e);if(void 0!==e.children)for(r=0;r<e.children.length;++r)null!=(t=e.children[r])&&"string"!=typeof t&&p(t)}}function d(e,t,r,a){for(;r<=a;++r){var i=void 0,s=void 0,c=void 0,u=t[r];if(null!=u)if(isDef(u.sel)){for(p(u),s=n.remove.length+1,c=l(u.elm,s),i=0;i<n.remove.length;++i)n.remove[i](u,c);isDef(i=u.data)&&isDef(i=i.hook)&&isDef(i=i.remove)?i(u,c):c()}else o.removeChild(e,u.elm)}}function h(e,t,r){var a,i;isDef(a=t.data)&&isDef(i=a.hook)&&isDef(a=i.prepatch)&&a(e,t);var s=t.elm=e.elm,l=e.children,p=t.children;if(e!==t){if(void 0!==t.data){for(a=0;a<n.update.length;++a)n.update[a](e,t);isDef(a=t.data.hook)&&isDef(a=a.update)&&a(e,t)}isUndef(t.text)?isDef(l)&&isDef(p)?l!==p&&function(e,t,r,a){for(var n,i,s,l=0,p=0,f=t.length-1,v=t[0],m=t[f],g=r.length-1,b=r[0],y=r[g];l<=f&&p<=g;)null==v?v=t[++l]:null==m?m=t[--f]:null==b?b=r[++p]:null==y?y=r[--g]:sameVnode(v,b)?(h(v,b,a),v=t[++l],b=r[++p]):sameVnode(m,y)?(h(m,y,a),m=t[--f],y=r[--g]):sameVnode(v,y)?(h(v,y,a),o.insertBefore(e,v.elm,o.nextSibling(m.elm)),v=t[++l],y=r[--g]):sameVnode(m,b)?(h(m,b,a),o.insertBefore(e,m.elm,v.elm),m=t[--f],b=r[++p]):(void 0===n&&(n=createKeyToOldIdx(t,l,f)),isUndef(i=n[b.key])?(o.insertBefore(e,c(b,a),v.elm),b=r[++p]):((s=t[i]).sel!==b.sel?o.insertBefore(e,c(b,a),v.elm):(h(s,b,a),t[i]=void 0,o.insertBefore(e,s.elm,v.elm)),b=r[++p]));(l<=f||p<=g)&&(l>f?u(e,null==r[g+1]?null:r[g+1].elm,r,p,g,a):d(e,t,l,f))}(s,l,p,r):isDef(p)?(isDef(e.text)&&o.setTextContent(s,""),u(s,null,p,0,p.length-1,r)):isDef(l)?d(s,l,0,l.length-1):isDef(e.text)&&o.setTextContent(s,""):e.text!==t.text&&o.setTextContent(s,t.text),isDef(i)&&isDef(a=i.postpatch)&&a(e,t)}}return function(e,t){var r,a,i,l=[];for(r=0;r<n.pre.length;++r)n.pre[r]();for(isVnode(e)||(e=s(e)),sameVnode(e,t)?h(e,t,l):(a=e.elm,i=o.parentNode(a),c(t,l),null!==i&&(o.insertBefore(i,t.elm,o.nextSibling(a)),d(i,[e],0,0))),r=0;r<l.length;++r)l[r].data.hook.insert(l[r]);for(r=0;r<n.post.length;++r)n.post[r]();return t}}var xlinkNS="http://www.w3.org/1999/xlink",xmlNS="http://www.w3.org/XML/1998/namespace",colonChar=58,xChar=120;function updateAttrs(e,t){var r,a=t.elm,n=e.data.attrs,o=t.data.attrs;if((n||o)&&n!==o){for(r in n=n||{},o=o||{}){var i=o[r];n[r]!==i&&(!0===i?a.setAttribute(r,""):!1===i?a.removeAttribute(r):r.charCodeAt(0)!==xChar?a.setAttribute(r,i):r.charCodeAt(3)===colonChar?a.setAttributeNS(xmlNS,r,i):r.charCodeAt(5)===colonChar?a.setAttributeNS(xlinkNS,r,i):a.setAttribute(r,i))}for(r in n)r in o||a.removeAttribute(r)}}var attributesModule={create:updateAttrs,update:updateAttrs};function updateProps(e,t){var r,a,n=t.elm,o=e.data.props,i=t.data.props;if((o||i)&&o!==i){for(r in i=i||{},o=o||{})i[r]||delete n[r];for(r in i)a=i[r],o[r]===a||"value"===r&&n[r]===a||(n[r]=a)}}var propsModule={create:updateProps,update:updateProps},raf="undefined"!=typeof window&&window.requestAnimationFrame||setTimeout,nextFrame=function(e){raf(function(){raf(e)})};function setNextFrame(e,t,r){nextFrame(function(){e[t]=r})}function updateStyle(e,t){var r,a,n=t.elm,o=e.data.style,i=t.data.style;if((o||i)&&o!==i){i=i||{};var s="delayed"in(o=o||{});for(a in o)i[a]||("-"===a[0]&&"-"===a[1]?n.style.removeProperty(a):n.style[a]="");for(a in i)if(r=i[a],"delayed"===a&&i.delayed)for(var l in i.delayed)r=i.delayed[l],s&&r===o.delayed[l]||setNextFrame(n.style,l,r);else"remove"!==a&&r!==o[a]&&("-"===a[0]&&"-"===a[1]?n.style.setProperty(a,r):n.style[a]=r)}}function applyDestroyStyle(e){var t,r,a=e.elm,n=e.data.style;if(n&&(t=n.destroy))for(r in t)a.style[r]=t[r]}function applyRemoveStyle(e,t){var r=e.data.style;if(r&&r.remove){var a,n=e.elm,o=0,i=r.remove,s=0,l=[];for(a in i)l.push(a),n.style[a]=i[a];for(var c=getComputedStyle(n)["transition-property"].split(", ");o<c.length;++o)-1!==l.indexOf(c[o])&&s++;n.addEventListener("transitionend",function(e){e.target===n&&--s,0===s&&t()})}else t()}var styleModule={create:updateStyle,update:updateStyle,destroy:applyDestroyStyle,remove:applyRemoveStyle};function invokeHandler(e,t,r){"function"==typeof e&&e.apply(void 0,[t].concat(r))}function handleEvent(e,t,r){var a=e.type,n=r.data.on;n&&n[a]&&invokeHandler(n[a],e,t,r)}function createListener(){return function e(t){for(var r=[],a=arguments.length-1;a-- >0;)r[a]=arguments[a+1];handleEvent(t,r,e.vnode)}}function updateEvents(e,t){var r=e.data.on,a=e.listener,n=e.elm,o=t&&t.data.on,i=t&&t.elm;if(r!==o&&(r&&a&&(o?Object.keys(r).forEach(function(e){o[e]||$(n).off(e,a)}):Object.keys(r).forEach(function(e){$(n).off(e,a)})),o)){var s=e.listener||createListener();t.listener=s,s.vnode=t,r?Object.keys(o).forEach(function(e){r[e]||$(i).on(e,s)}):Object.keys(o).forEach(function(e){$(i).on(e,s)})}}var eventListenersModule={create:updateEvents,update:updateEvents,destroy:updateEvents},patch=init([attributesModule,propsModule,styleModule,eventListenersModule]),Framework7Component=function(e,t,r){void 0===r&&(r={});var a=Utils.id(),n=Utils.merge(this,r,{$:$,$$:$,$dom7:$,$app:e,$f7:e,$options:Utils.extend({id:a},t),$id:t.id||a}),o=n.$options;Object.defineProperty(n,"$root",{enumerable:!0,configurable:!0,get:function(){var t=Utils.merge({},e.data,e.methods);return win&&win.Proxy&&(t=new win.Proxy(t,{set:function(t,r,a){e.data[r]=a},deleteProperty:function(t,r){delete e.data[r],delete e.methods[r]},has:function(t,r){return r in e.data||r in e.methods}})),t},set:function(){}}),"beforeCreate created beforeMount mounted beforeDestroy destroyed updated".split(" ").forEach(function(e){o[e]&&(o[e]=o[e].bind(n))}),o.data&&(o.data=o.data.bind(n),Utils.extend(n,o.data())),o.render&&(o.render=o.render.bind(n)),o.methods&&Object.keys(o.methods).forEach(function(e){n[e]=o.methods[e].bind(n)}),o.on&&Object.keys(o.on).forEach(function(e){o.on[e]=o.on[e].bind(n)}),o.once&&Object.keys(o.once).forEach(function(e){o.once[e]=o.once[e].bind(n)}),o.beforeCreate&&o.beforeCreate();var i=n.$render();return i&&"string"==typeof i?(i=i.trim(),n.$vnode=vdom(i,n,e,!0),n.el=doc.createElement("div"),patch(n.el,n.$vnode)):i&&(n.el=i),n.$el=$(n.el),o.style&&(n.$styleEl=doc.createElement("style"),n.$styleEl.innerHTML=o.style,o.styleScoped&&n.el.setAttribute("data-f7-"+o.id,"")),n.$attachEvents(),o.created&&o.created(),n.el.f7Component=n,n};function parseComponent(e){var t,r=Utils.id(),a="f7_component_create_callback_"+r,n="f7_component_render_callback_"+r,o=e.match(/<template([ ]?)([a-z0-9-]*)>/),i=o[2]||"t7";o&&(t=e.split(/<template[ ]?[a-z0-9-]*>/).filter(function(e,t){return t>0}).join("<template>").split("</template>").filter(function(e,t,r){return t<r.length-1}).join("</template>").replace(/{{#raw}}([ \n]*)<template/g,"{{#raw}}<template").replace(/\/template>([ \n]*){{\/raw}}/g,"/template>{{/raw}}").replace(/([ \n])<template/g,"$1{{#raw}}<template").replace(/\/template>([ \n])/g,"/template>{{/raw}}$1"));var s,l,c=null,u=!1;if(e.indexOf("<style>")>=0?c=e.split("<style>")[1].split("</style>")[0]:e.indexOf("<style scoped>")>=0&&(u=!0,c=(c=e.split("<style scoped>")[1].split("</style>")[0]).split("\n").map(function(e){return 0===e.trim().indexOf("@")?e:e.indexOf("{")>=0?e.indexOf("{{this}}")>=0?e.replace("{{this}}","[data-f7-"+r+"]"):"[data-f7-"+r+"] "+e.trim():e}).join("\n")),e.indexOf("<script>")>=0){var p=e.split("<script>");s=p[p.length-1].split("<\/script>")[0].trim()}else s="return {}";s&&s.trim()||(s="return {}"),s="window."+a+" = function () {"+s+"}",(l=doc.createElement("script")).innerHTML=s,$("head").append(l);var d=win[a]();if($(l).remove(),win[a]=null,delete win[a],d.template||d.render||(d.template=t,d.templateType=i),d.template&&("t7"===d.templateType&&(d.template=Template7.compile(d.template)),"es"===d.templateType)){var h="window."+n+" = function () {\n        return function render() {\n          return `"+d.template+"`;\n        }\n      }";(l=doc.createElement("script")).innerHTML=h,$("head").append(l),d.render=win[n](),$(l).remove(),win[n]=null,delete win[n]}return c&&(d.style=c,d.styleScoped=u),d.id=r,d}Framework7Component.prototype.$attachEvents=function(){var e=this.$options,t=this.$el;e.on&&Object.keys(e.on).forEach(function(r){t.on(Utils.eventNameToColonCase(r),e.on[r])}),e.once&&Object.keys(e.once).forEach(function(r){t.once(Utils.eventNameToColonCase(r),e.once[r])})},Framework7Component.prototype.$detachEvents=function(){var e=this.$options,t=this.$el;e.on&&Object.keys(e.on).forEach(function(r){t.off(Utils.eventNameToColonCase(r),e.on[r])}),e.once&&Object.keys(e.once).forEach(function(r){t.off(Utils.eventNameToColonCase(r),e.once[r])})},Framework7Component.prototype.$render=function(){var e=this.$options,t="";if(e.render)t=e.render();else if(e.template)if("string"==typeof e.template)try{t=Template7.compile(e.template)(this)}catch(e){throw e}else t=e.template(this);return t},Framework7Component.prototype.$forceUpdate=function(){var e=this.$render();if(e&&"string"==typeof e){var t=vdom(e=e.trim(),this,this.$app);this.$vnode=patch(this.$vnode,t)}},Framework7Component.prototype.$setState=function(e){Utils.merge(this,e),this.$forceUpdate()},Framework7Component.prototype.$mount=function(e){this.$options.beforeMount&&this.$options.beforeMount(),this.$styleEl&&$("head").append(this.$styleEl),e&&e(this.el),this.$options.mounted&&this.$options.mounted()},Framework7Component.prototype.$destroy=function(){this.$options.beforeDestroy&&this.$options.beforeDestroy(),this.$styleEl&&$(this.$styleEl).remove(),this.$detachEvents(),this.$options.destroyed&&this.$options.destroyed(),this.el&&this.el.f7Component&&(this.el.f7Component=null,delete this.el.f7Component),this.$vnode&&(this.$vnode=patch(this.$vnode,{sel:this.$vnode.sel,data:{}})),Utils.deleteProps(this)};var ComponentModule={name:"component",create:function(){var e=this;e.component={parse:function(e){return parseComponent(e)},create:function(t,r){return new Framework7Component(e,t,r)}}}},SW={registrations:[],register:function(e,t){var r=this;return"serviceWorker"in window.navigator&&r.serviceWorker.container?new Promise(function(a,n){r.serviceWorker.container.register(e,t?{scope:t}:{}).then(function(e){SW.registrations.push(e),r.emit("serviceWorkerRegisterSuccess",e),a(e)}).catch(function(e){r.emit("serviceWorkerRegisterError",e),n(e)})}):new Promise(function(e,t){t(new Error("Service worker is not supported"))})},unregister:function(e){var t,r=this;return"serviceWorker"in window.navigator&&r.serviceWorker.container?(t=e?Array.isArray(e)?e:[e]:SW.registrations,Promise.all(t.map(function(e){return new Promise(function(t,a){e.unregister().then(function(){SW.registrations.indexOf(e)>=0&&SW.registrations.splice(SW.registrations.indexOf(e),1),r.emit("serviceWorkerUnregisterSuccess",e),t()}).catch(function(t){r.emit("serviceWorkerUnregisterError",e,t),a(t)})})}))):new Promise(function(e,t){t(new Error("Service worker is not supported"))})}},ServiceWorkerModule={name:"sw",params:{serviceWorker:{path:void 0,scope:void 0}},create:function(){Utils.extend(this,{serviceWorker:{container:"serviceWorker"in window.navigator?window.navigator.serviceWorker:void 0,registrations:SW.registrations,register:SW.register.bind(this),unregister:SW.unregister.bind(this)}})},on:{init:function(){if("serviceWorker"in window.navigator){var e=this;if(e.serviceWorker.container){var t=e.params.serviceWorker.path,r=e.params.serviceWorker.scope;if(t&&(!Array.isArray(t)||t.length))(Array.isArray(t)?t:[t]).forEach(function(t){e.serviceWorker.register(t,r)})}}}}},Statusbar={hide:function(){$("html").removeClass("with-statusbar"),Device.cordova&&win.StatusBar&&win.StatusBar.hide()},show:function(){if(Device.cordova&&win.StatusBar)return win.StatusBar.show(),void Utils.nextTick(function(){Device.needsStatusbarOverlay()&&$("html").addClass("with-statusbar")});$("html").addClass("with-statusbar")},onClick:function(){var e;(e=$(".popup.modal-in").length>0?$(".popup.modal-in").find(".page:not(.page-previous):not(.page-next):not(.cached)").find(".page-content"):$(".panel.panel-active").length>0?$(".panel.panel-active").find(".page:not(.page-previous):not(.page-next):not(.cached)").find(".page-content"):$(".views > .view.tab-active").length>0?$(".views > .view.tab-active").find(".page:not(.page-previous):not(.page-next):not(.cached)").find(".page-content"):$(".views").length>0?$(".views").find(".page:not(.page-previous):not(.page-next):not(.cached)").find(".page-content"):this.root.children(".view").find(".page:not(.page-previous):not(.page-next):not(.cached)").find(".page-content"))&&e.length>0&&(e.hasClass("tab")&&(e=e.parent(".tabs").children(".page-content.tab-active")),e.length>0&&e.scrollTop(0,300))},setTextColor:function(e){Device.cordova&&win.StatusBar&&("white"===e?win.StatusBar.styleLightContent():win.StatusBar.styleDefault())},setIosTextColor:function(e){Device.ios&&Statusbar.setTextColor(e)},setBackgroundColor:function(e){$(".statusbar").css("background-color",e),Device.cordova&&win.StatusBar&&win.StatusBar.backgroundColorByHexString(e)},isVisible:function(){return!(!Device.cordova||!win.StatusBar)&&win.StatusBar.isVisible},overlaysWebView:function(e){void 0===e&&(e=!0),Device.cordova&&win.StatusBar&&(win.StatusBar.overlaysWebView(e),e?$("html").addClass("with-statusbar"):$("html").removeClass("with-statusbar"))},checkOverlay:function(){Device.needsStatusbarOverlay()?$("html").addClass("with-statusbar"):$("html").removeClass("with-statusbar")},init:function(){var e=this.params.statusbar;e.enabled&&("auto"===e.overlay?(Device.needsStatusbarOverlay()?$("html").addClass("with-statusbar"):$("html").removeClass("with-statusbar"),Device.ios&&(Device.cordova||Device.webView)&&(0===win.orientation&&this.once("resize",function(){Statusbar.checkOverlay()}),$(doc).on("resume",function(){Statusbar.checkOverlay()},!1),this.on(Device.ios?"orientationchange":"orientationchange resize",function(){Statusbar.checkOverlay()}))):!0===e.overlay?$("html").addClass("with-statusbar"):!1===e.overlay&&$("html").removeClass("with-statusbar"),Device.cordova&&win.StatusBar&&(e.scrollTopOnClick&&$(win).on("statusTap",Statusbar.onClick.bind(this)),Device.ios&&(e.iosOverlaysWebView?win.StatusBar.overlaysWebView(!0):win.StatusBar.overlaysWebView(!1),"white"===e.iosTextColor?win.StatusBar.styleLightContent():win.StatusBar.styleDefault()),Device.android&&(e.androidOverlaysWebView?win.StatusBar.overlaysWebView(!0):win.StatusBar.overlaysWebView(!1),"white"===e.androidTextColor?win.StatusBar.styleLightContent():win.StatusBar.styleDefault())),e.iosBackgroundColor&&Device.ios&&Statusbar.setBackgroundColor(e.iosBackgroundColor),(e.materialBackgroundColor||e.androidBackgroundColor)&&Device.android&&Statusbar.setBackgroundColor(e.materialBackgroundColor||e.androidBackgroundColor))}},Statusbar$1={name:"statusbar",params:{statusbar:{enabled:!0,overlay:"auto",scrollTopOnClick:!0,iosOverlaysWebView:!0,iosTextColor:"black",iosBackgroundColor:null,androidOverlaysWebView:!1,androidTextColor:"black",androidBackgroundColor:null}},create:function(){Utils.extend(this,{statusbar:{checkOverlay:Statusbar.checkOverlay,hide:Statusbar.hide,show:Statusbar.show,overlaysWebView:Statusbar.overlaysWebView,setTextColor:Statusbar.setTextColor,setBackgroundColor:Statusbar.setBackgroundColor,isVisible:Statusbar.isVisible,init:Statusbar.init.bind(this)}})},on:{init:function(){Statusbar.init.call(this)}},clicks:{".statusbar":function(){this.params.statusbar.enabled&&this.params.statusbar.scrollTopOnClick&&Statusbar.onClick.call(this)}}};function getCurrentView(e){var t=$(".popover.modal-in .view"),r=$(".popup.modal-in .view"),a=$(".panel.panel-active .view"),n=$(".views");0===n.length&&(n=e.root);var o=n.children(".view");if(o.length>1&&o.hasClass("tab")&&(o=n.children(".view.tab-active")),t.length>0&&t[0].f7View)return t[0].f7View;if(r.length>0&&r[0].f7View)return r[0].f7View;if(a.length>0&&a[0].f7View)return a[0].f7View;if(o.length>0){if(1===o.length&&o[0].f7View)return o[0].f7View;if(o.length>1)return e.views.main}}var View$1={name:"view",params:{view:{name:void 0,main:!1,router:!0,linksView:null,stackPages:!1,xhrCache:!0,xhrCacheIgnore:[],xhrCacheIgnoreGetParameters:!1,xhrCacheDuration:6e5,preloadPreviousPage:!0,allowDuplicateUrls:!1,reloadPages:!1,reloadDetail:!1,masterDetailBreakpoint:0,removeElements:!0,removeElementsWithTimeout:!1,removeElementsTimeout:0,restoreScrollTopOnBack:!0,unloadTabContent:!0,passRouteQueryToRequest:!0,passRouteParamsToRequest:!1,iosSwipeBack:!0,iosSwipeBackAnimateShadow:!0,iosSwipeBackAnimateOpacity:!0,iosSwipeBackActiveArea:30,iosSwipeBackThreshold:0,mdSwipeBack:!1,mdSwipeBackAnimateShadow:!0,mdSwipeBackAnimateOpacity:!1,mdSwipeBackActiveArea:30,mdSwipeBackThreshold:0,auroraSwipeBack:!1,auroraSwipeBackAnimateShadow:!1,auroraSwipeBackAnimateOpacity:!0,auroraSwipeBackActiveArea:30,auroraSwipeBackThreshold:0,pushState:!1,pushStateRoot:void 0,pushStateAnimate:!0,pushStateAnimateOnLoad:!1,pushStateSeparator:"#!",pushStateOnLoad:!0,animate:!0,iosDynamicNavbar:!0,iosSeparateDynamicNavbar:!0,iosAnimateNavbarBackIcon:!0,iosPageLoadDelay:0,mdPageLoadDelay:0,auroraPageLoadDelay:0,routesBeforeEnter:null,routesBeforeLeave:null}},static:{View:View},create:function(){var e=this;Utils.extend(e,{views:Utils.extend([],{create:function(t,r){return new View(e,t,r)},get:function(e){var t=$(e);if(t.length&&t[0].f7View)return t[0].f7View}})}),Object.defineProperty(e.views,"current",{enumerable:!0,configurable:!0,get:function(){return getCurrentView(e)}}),e.view=e.views},on:{init:function(){var e=this;$(".view-init").each(function(t,r){if(!r.f7View){var a=$(r).dataset();e.views.create(r,a)}})},modalOpen:function(e){var t=this;e.$el.find(".view-init").each(function(e,r){if(!r.f7View){var a=$(r).dataset();t.views.create(r,a)}})},modalBeforeDestroy:function(e){e&&e.$el&&e.$el.find(".view-init").each(function(e,t){var r=t.f7View;r&&r.destroy()})}}},Navbar={size:function(e){var t=this;if("ios"===t.theme||t.params.navbar[t.theme+"CenterTitle"]){var r=$(e);if(r.hasClass("navbar"))r=r.children(".navbar-inner").each(function(e,r){t.navbar.size(r)});else if(!(r.hasClass("stacked")||r.parents(".stacked").length>0||r.parents(".tab:not(.tab-active)").length>0||r.parents(".popup:not(.modal-in)").length>0)){"ios"!==t.theme&&t.params.navbar[t.theme+"CenterTitle"]&&r.addClass("navbar-inner-centered-title"),"ios"!==t.theme||t.params.navbar.iosCenterTitle||r.addClass("navbar-inner-left-title");var a,n,o,i,s=r.parents(".view").eq(0),l=t.rtl?r.children(".right"):r.children(".left"),c=t.rtl?r.children(".left"):r.children(".right"),u=r.children(".title"),p=r.children(".subnavbar"),d=0===l.length,h=0===c.length,f=d?0:l.outerWidth(!0),v=h?0:c.outerWidth(!0),m=u.outerWidth(!0),g=r.styles(),b=r[0].offsetWidth,y=b-parseInt(g.paddingLeft,10)-parseInt(g.paddingRight,10),w=r.hasClass("navbar-previous"),C=r.hasClass("sliding"),x=0,k=0;s.length>0&&s[0].f7View&&(n=(a=s[0].f7View.router)&&a.dynamicNavbar,a&&a.separateNavbar||(x=b,k=b/5)),h&&(o=y-m),d&&(o=0),d||h||(o=(y-v-m+f)/2);var S=(y-m)/2;y-f-v>m?(S<f&&(S=f),S+m>y-v&&(S=y-v-m),i=S-o):i=0;var E=t.rtl?-1:1;if(n&&"ios"===t.theme){if(u.hasClass("sliding")||u.length>0&&C){var T=-(o+i)*E+k,O=(y-o-i-m)*E-x;if(w&&a&&a.params.iosAnimateNavbarBackIcon){var P=r.parent().find(".navbar-current").children(".left.sliding").find(".back .icon ~ span");P.length>0&&(T+=P[0].offsetLeft)}u[0].f7NavbarLeftOffset=T,u[0].f7NavbarRightOffset=O}if(!d&&(l.hasClass("sliding")||C))if(t.rtl)l[0].f7NavbarLeftOffset=-(y-l[0].offsetWidth)/2*E,l[0].f7NavbarRightOffset=f*E;else if(l[0].f7NavbarLeftOffset=-f+k,l[0].f7NavbarRightOffset=(y-l[0].offsetWidth)/2-x,a&&a.params.iosAnimateNavbarBackIcon&&l.find(".back .icon").length>0&&l.find(".back .icon ~ span").length){var R=l[0].f7NavbarLeftOffset,D=l[0].f7NavbarRightOffset;l[0].f7NavbarLeftOffset=0,l[0].f7NavbarRightOffset=0,l.find(".back .icon ~ span")[0].f7NavbarLeftOffset=R,l.find(".back .icon ~ span")[0].f7NavbarRightOffset=D-l.find(".back .icon")[0].offsetWidth}h||!c.hasClass("sliding")&&!C||(t.rtl?(c[0].f7NavbarLeftOffset=-v*E,c[0].f7NavbarRightOffset=(y-c[0].offsetWidth)/2*E):(c[0].f7NavbarLeftOffset=-(y-c[0].offsetWidth)/2+k,c[0].f7NavbarRightOffset=v-x)),p.length&&(p.hasClass("sliding")||C)&&(p[0].f7NavbarLeftOffset=t.rtl?p[0].offsetWidth:-p[0].offsetWidth+k,p[0].f7NavbarRightOffset=-p[0].f7NavbarLeftOffset-x+k)}if(t.params.navbar[t.theme+"CenterTitle"]){var N=i;t.rtl&&d&&h&&u.length>0&&(N=-N),u.css({left:N+"px"})}}}},hide:function(e,t){void 0===t&&(t=!0);var r=$(e);if(r.hasClass("navbar-inner")&&(r=r.parents(".navbar")),r.length&&!r.hasClass("navbar-hidden")){var a="navbar-hidden"+(t?" navbar-transitioning":"");("ios"===this.theme?r.find(".navbar-current .title-large").length:r.find(".title-large").length)&&(a+=" navbar-large-hidden"),r.transitionEnd(function(){r.removeClass("navbar-transitioning")}),r.addClass(a),r.trigger("navbar:hide"),this.emit("navbarHide",r[0])}},show:function(e,t){void 0===e&&(e=".navbar-hidden"),void 0===t&&(t=!0);var r=$(e);r.hasClass("navbar-inner")&&(r=r.parents(".navbar")),r.length&&r.hasClass("navbar-hidden")&&(t&&(r.addClass("navbar-transitioning"),r.transitionEnd(function(){r.removeClass("navbar-transitioning")})),r.removeClass("navbar-hidden navbar-large-hidden"),r.trigger("navbar:show"),this.emit("navbarShow",r[0]))},getElByPage:function(e){var t,r,a;if(e.$navbarEl||e.$el?(a=e,t=e.$el):(t=$(e)).length>0&&(a=t[0].f7Page),a&&a.$navbarEl&&a.$navbarEl.length>0?r=a.$navbarEl:t&&(r=t.children(".navbar").children(".navbar-inner")),r&&(!r||0!==r.length))return r[0]},getPageByEl:function(e){var t,r=$(e);if(!(r.hasClass("navbar")&&(r=r.find(".navbar-inner")).length>1))return r.parents(".page").length?r.parents(".page")[0]:(r.parents(".view").find(".page").each(function(e,a){a&&a.f7Page&&a.f7Page.navbarEl&&r[0]===a.f7Page.navbarEl&&(t=a)}),t)},collapseLargeTitle:function(e){var t=$(e);if(!(t.hasClass("navbar")&&((t=t.find(".navbar-inner-large")).length>1&&(t=$(e).find(".navbar-inner-large.navbar-current")),t.length>1||!t.length))){var r=$(this.navbar.getPageByEl(t));t.addClass("navbar-inner-large-collapsed"),r.eq(0).addClass("page-with-navbar-large-collapsed").trigger("page:navbarlargecollapsed");var a=t.parents(".navbar");"md"!==this.theme&&"aurora"!==this.theme||a.addClass("navbar-large-collapsed"),a.trigger("navbar:collapse"),this.emit("navbarCollapse",a[0])}},expandLargeTitle:function(e){var t=$(e);if(!(t.hasClass("navbar")&&((t=t.find(".navbar-inner-large")).length>1&&(t=$(e).find(".navbar-inner-large.navbar-current")),t.length>1||!t.length))){var r=$(this.navbar.getPageByEl(t));t.removeClass("navbar-inner-large-collapsed"),r.eq(0).removeClass("page-with-navbar-large-collapsed").trigger("page:navbarlargeexpanded");var a=t.parents(".navbar");"md"!==this.theme&&"aurora"!==this.theme||a.removeClass("navbar-large-collapsed"),a.trigger("navbar:expand"),this.emit("navbarExpand",a[0])}},toggleLargeTitle:function(e){var t=$(e);t.hasClass("navbar")&&((t=t.find(".navbar-inner-large")).length>1&&(t=$(e).find(".navbar-inner-large.navbar-current")),t.length>1||!t.length)||(t.hasClass("navbar-inner-large-collapsed")?this.navbar.expandLargeTitle(t):this.navbar.collapseLargeTitle(t))},initNavbarOnScroll:function(e,t,r,a){var n,o,i,s,l,c,u,p,d,h,f,v,m,g=this,b=$(e),y=$(t),w="md"===g.theme||"aurora"===g.theme?y.parents(".navbar"):$(t||g.navbar.getElByPage(e)).closest(".navbar"),C=y.find(".title-large").length||y.hasClass(".navbar-inner-large"),x=44,k=g.params.navbar.snapPageScrollToLargeTitle;(a||r&&C)&&((d=y.css("--f7-navbar-large-title-height"))&&d.indexOf("px")>=0?(d=parseInt(d,10),Number.isNaN(d)&&("ios"===g.theme?d=52:"md"===g.theme?d=48:"aurora"===g.theme&&(d=38))):"ios"===g.theme?d=52:"md"===g.theme?d=48:"aurora"===g.theme&&(d=38)),r&&C&&(x+=d);var S=70,E=300;function T(){y.hasClass("with-searchbar-expandable-enabled")||!f||o<0||(o>=d/2&&o<d?$(f).scrollTop(d,100):o<d&&$(f).scrollTop(0,200))}function O(){var e;o=(f=this).scrollTop,h=o,a&&(e=Math.min(Math.max(o/d,0),1),y.hasClass("with-searchbar-expandable-enabled")||(p=y.hasClass("navbar-inner-large-collapsed"),0===e&&p?(g.navbar.expandLargeTitle(y[0]),y[0].style.removeProperty("--f7-navbar-large-collapse-progress"),b[0].style.removeProperty("--f7-navbar-large-collapse-progress"),y[0].style.overflow="","md"!==g.theme&&"aurora"!==g.theme||w[0].style.removeProperty("--f7-navbar-large-collapse-progress")):1!==e||p?1===e&&p||0===e&&!p?(y[0].style.removeProperty("--f7-navbar-large-collapse-progress"),y[0].style.overflow="",b[0].style.removeProperty("--f7-navbar-large-collapse-progress"),"md"!==g.theme&&"aurora"!==g.theme||w[0].style.removeProperty("--f7-navbar-large-collapse-progress")):(y[0].style.setProperty("--f7-navbar-large-collapse-progress",e),y[0].style.overflow="visible",b[0].style.setProperty("--f7-navbar-large-collapse-progress",e),"md"!==g.theme&&"aurora"!==g.theme||w[0].style.setProperty("--f7-navbar-large-collapse-progress",e)):(g.navbar.collapseLargeTitle(y[0]),y[0].style.removeProperty("--f7-navbar-large-collapse-progress"),y[0].style.overflow="",b[0].style.removeProperty("--f7-navbar-large-collapse-progress"),"md"!==g.theme&&"aurora"!==g.theme||w[0].style.removeProperty("--f7-navbar-large-collapse-progress")),k&&(Support.touch?m&&(clearTimeout(m),m=null,m=setTimeout(function(){T(),clearTimeout(m),m=null},S)):(clearTimeout(v),v=setTimeout(function(){T()},E))))),b.hasClass("page-previous")||r&&(i=f.scrollHeight,s=f.offsetHeight,l=o+s>=i,u=w.hasClass("navbar-hidden"),l?g.params.navbar.showOnPageScrollEnd&&(c="show"):c=n>o?g.params.navbar.showOnPageScrollTop||o<=x?"show":"hide":o>x?"hide":"show","show"===c&&u?(g.navbar.show(w),u=!1):"hide"!==c||u||(g.navbar.hide(w),u=!0),n=o)}function P(){h=!1}function R(){clearTimeout(m),m=null,m=setTimeout(function(){!1!==h&&(T(),clearTimeout(m),m=null)},S)}b.on("scroll",".page-content",O,!0),Support.touch&&a&&k&&(g.on("touchstart:passive",P),g.on("touchend:passive",R)),a&&b.find(".page-content").each(function(e,t){t.scrollTop>0&&O.call(t)}),b[0].f7DetachNavbarScrollHandlers=function(){delete b[0].f7DetachNavbarScrollHandlers,b.off("scroll",".page-content",O,!0),Support.touch&&a&&k&&(g.off("touchstart:passive",P),g.off("touchend:passive",R))}}},Navbar$1={name:"navbar",create:function(){var e=this;Utils.extend(e,{navbar:{size:Navbar.size.bind(e),hide:Navbar.hide.bind(e),show:Navbar.show.bind(e),getElByPage:Navbar.getElByPage.bind(e),getPageByEl:Navbar.getPageByEl.bind(e),collapseLargeTitle:Navbar.collapseLargeTitle.bind(e),expandLargeTitle:Navbar.expandLargeTitle.bind(e),toggleLargeTitle:Navbar.toggleLargeTitle.bind(e),initNavbarOnScroll:Navbar.initNavbarOnScroll.bind(e)}})},params:{navbar:{scrollTopOnTitleClick:!0,iosCenterTitle:!0,mdCenterTitle:!1,auroraCenterTitle:!0,hideOnPageScroll:!1,showOnPageScrollEnd:!0,showOnPageScrollTop:!0,collapseLargeTitleOnScroll:!0,snapPageScrollToLargeTitle:!0}},on:{"panelBreakpoint panelResize resize viewMasterDetailBreakpoint":function(){var e=this;$(".navbar").each(function(t,r){e.navbar.size(r)})},pageBeforeRemove:function(e){e.$el[0].f7DetachNavbarScrollHandlers&&e.$el[0].f7DetachNavbarScrollHandlers()},pageBeforeIn:function(e){if("ios"===this.theme){var t,r=e.$el.parents(".view")[0].f7View,a=this.navbar.getElByPage(e);if(t=a?$(a).parents(".navbar"):e.$el.parents(".view").children(".navbar"),e.$el.hasClass("no-navbar")||r.router.dynamicNavbar&&!a){var n=!!(e.pageFrom&&e.router.history.length>0);this.navbar.hide(t,n)}else this.navbar.show(t)}},pageReinit:function(e){var t=$(this.navbar.getElByPage(e));t&&0!==t.length&&this.navbar.size(t)},pageInit:function(e){var t,r,a=$(this.navbar.getElByPage(e));a&&0!==a.length&&(this.navbar.size(a),a.children(".title-large").length>0&&a.addClass("navbar-inner-large"),a.hasClass("navbar-inner-large")&&(this.params.navbar.collapseLargeTitleOnScroll&&(t=!0),"md"!==this.theme&&"aurora"!==this.theme||a.parents(".navbar").addClass("navbar-large"),e.$el.addClass("page-with-navbar-large")),(this.params.navbar.hideOnPageScroll||e.$el.find(".hide-navbar-on-scroll").length||e.$el.hasClass("hide-navbar-on-scroll")||e.$el.find(".hide-bars-on-scroll").length||e.$el.hasClass("hide-bars-on-scroll"))&&(r=!(e.$el.find(".keep-navbar-on-scroll").length||e.$el.hasClass("keep-navbar-on-scroll")||e.$el.find(".keep-bars-on-scroll").length||e.$el.hasClass("keep-bars-on-scroll"))),(t||r)&&this.navbar.initNavbarOnScroll(e.el,a[0],r,t))},modalOpen:function(e){var t=this;t.params.navbar[t.theme+"CenterTitle"]&&e.$el.find(".navbar:not(.navbar-previous):not(.stacked)").each(function(e,r){t.navbar.size(r)})},panelOpen:function(e){var t=this;t.params.navbar[t.theme+"CenterTitle"]&&e.$el.find(".navbar:not(.navbar-previous):not(.stacked)").each(function(e,r){t.navbar.size(r)})},panelSwipeOpen:function(e){var t=this;t.params.navbar[t.theme+"CenterTitle"]&&e.$el.find(".navbar:not(.navbar-previous):not(.stacked)").each(function(e,r){t.navbar.size(r)})},tabShow:function(e){var t=this;t.params.navbar[t.theme+"CenterTitle"]&&$(e).find(".navbar:not(.navbar-previous):not(.stacked)").each(function(e,r){t.navbar.size(r)})}},clicks:{".navbar .title":function(e){if(this.params.navbar.scrollTopOnTitleClick&&!(e.closest("a").length>0)){var t,r=e.parents(".navbar");0===(t=r.parents(".page-content")).length&&(r.parents(".page").length>0&&(t=r.parents(".page").find(".page-content")),0===t.length&&r.nextAll(".page-current:not(.stacked)").length>0&&(t=r.nextAll(".page-current:not(.stacked)").find(".page-content"))),t&&t.length>0&&(t.hasClass("tab")&&(t=t.parent(".tabs").children(".page-content.tab-active")),t.length>0&&t.scrollTop(0,300))}}},vnode:{"navbar-inner":{postpatch:function(e){this.params.navbar[this.theme+"CenterTitle"]&&this.navbar.size(e.elm)}}}},Toolbar={setHighlight:function(e){if("md"===this.theme){var t=$(e);if(0!==t.length&&(t.hasClass("tabbar")||t.hasClass("tabbar-labels"))){var r=t.find(".tab-link-highlight"),a=t.find(".tab-link").length;if(0!==a){0===r.length?(t.children(".toolbar-inner").append('<span class="tab-link-highlight"></span>'),r=t.find(".tab-link-highlight")):r.next().length&&t.children(".toolbar-inner").append(r);var n,o,i=t.find(".tab-link-active");if(t.hasClass("tabbar-scrollable")&&i&&i[0])n=i[0].offsetWidth+"px",o=i[0].offsetLeft+"px";else{var s=i.index();n=100/a+"%",o=100*(this.rtl?-s:s)+"%"}Utils.nextFrame(function(){r.css("width",n).transform("translate3d("+o+",0,0)")})}else r.remove()}}},init:function(e){this.toolbar.setHighlight(e)},hide:function(e,t){void 0===t&&(t=!0);var r=$(e);if(!r.hasClass("toolbar-hidden")){var a="toolbar-hidden"+(t?" toolbar-transitioning":"");r.transitionEnd(function(){r.removeClass("toolbar-transitioning")}),r.addClass(a)}},show:function(e,t){void 0===t&&(t=!0);var r=$(e);r.hasClass("toolbar-hidden")&&(t&&(r.addClass("toolbar-transitioning"),r.transitionEnd(function(){r.removeClass("toolbar-transitioning")})),r.removeClass("toolbar-hidden"))},initHideToolbarOnScroll:function(e){var t,r,a,n,o,i,s,l=this,c=$(e),u=c.parents(".view").children(".toolbar");(0===u.length&&(u=c.find(".toolbar")),0===u.length&&(u=c.parents(".views").children(".tabbar, .tabbar-labels")),0!==u.length)&&(c.on("scroll",".page-content",p,!0),c[0].f7ScrollToolbarHandler=p);function p(){c.hasClass("page-previous")||(r=this.scrollTop,a=this.scrollHeight,n=this.offsetHeight,o=r+n>=a,s=u.hasClass("toolbar-hidden"),o?l.params.toolbar.showOnPageScrollEnd&&(i="show"):i=t>r?l.params.toolbar.showOnPageScrollTop||r<=44?"show":"hide":r>44?"hide":"show","show"===i&&s?(l.toolbar.show(u),s=!1):"hide"!==i||s||(l.toolbar.hide(u),s=!0),t=r)}}},Toolbar$1={name:"toolbar",create:function(){Utils.extend(this,{toolbar:{hide:Toolbar.hide.bind(this),show:Toolbar.show.bind(this),setHighlight:Toolbar.setHighlight.bind(this),initHideToolbarOnScroll:Toolbar.initHideToolbarOnScroll.bind(this),init:Toolbar.init.bind(this)}})},params:{toolbar:{hideOnPageScroll:!1,showOnPageScrollEnd:!0,showOnPageScrollTop:!0}},on:{pageBeforeRemove:function(e){e.$el[0].f7ScrollToolbarHandler&&e.$el.off("scroll",".page-content",e.$el[0].f7ScrollToolbarHandler,!0)},pageBeforeIn:function(e){var t=e.$el.parents(".view").children(".toolbar");0===t.length&&(t=e.$el.parents(".views").children(".tabbar, .tabbar-labels")),0===t.length&&(t=e.$el.find(".toolbar")),0!==t.length&&(e.$el.hasClass("no-toolbar")?this.toolbar.hide(t):this.toolbar.show(t))},pageInit:function(e){var t=this;if(e.$el.find(".tabbar, .tabbar-labels").each(function(e,r){t.toolbar.init(r)}),t.params.toolbar.hideOnPageScroll||e.$el.find(".hide-toolbar-on-scroll").length||e.$el.hasClass("hide-toolbar-on-scroll")||e.$el.find(".hide-bars-on-scroll").length||e.$el.hasClass("hide-bars-on-scroll")){if(e.$el.find(".keep-toolbar-on-scroll").length||e.$el.hasClass("keep-toolbar-on-scroll")||e.$el.find(".keep-bars-on-scroll").length||e.$el.hasClass("keep-bars-on-scroll"))return;t.toolbar.initHideToolbarOnScroll(e.el)}},init:function(){var e=this;e.root.find(".tabbar, .tabbar-labels").each(function(t,r){e.toolbar.init(r)})}}},Subnavbar={name:"subnavbar",on:{pageInit:function(e){e.$navbarEl&&e.$navbarEl.length&&e.$navbarEl.find(".subnavbar").length&&e.$el.addClass("page-with-subnavbar"),e.$el.find(".subnavbar").length&&e.$el.addClass("page-with-subnavbar")}}},TouchRipple=function(e,t,r){var a=this;if(e){var n=e[0].getBoundingClientRect(),o=t-n.left,i=r-n.top,s=n.width,l=n.height,c=Math.max(Math.pow(Math.pow(l,2)+Math.pow(s,2),.5),48);return a.$rippleWaveEl=$('<div class="ripple-wave" style="width: '+c+"px; height: "+c+"px; margin-top:-"+c/2+"px; margin-left:-"+c/2+"px; left:"+o+"px; top:"+i+'px;"></div>'),e.prepend(a.$rippleWaveEl),a.rippleTransform="translate3d("+(s/2-o)+"px, "+(l/2-i)+"px, 0) scale(1)",Utils.nextFrame(function(){a&&a.$rippleWaveEl&&a.$rippleWaveEl.transform(a.rippleTransform)}),a}};TouchRipple.prototype.destroy=function(){var e=this;e.$rippleWaveEl&&e.$rippleWaveEl.remove(),Object.keys(e).forEach(function(t){e[t]=null,delete e[t]}),e=null},TouchRipple.prototype.remove=function(){var e=this;if(!e.removing){var t=this.$rippleWaveEl,r=this.rippleTransform,a=Utils.nextTick(function(){e.destroy()},400);e.removing=!0,t.addClass("ripple-wave-fill").transform(r.replace("scale(1)","scale(1.01)")).transitionEnd(function(){clearTimeout(a),Utils.nextFrame(function(){t.addClass("ripple-wave-out").transform(r.replace("scale(1)","scale(1.01)")),a=Utils.nextTick(function(){e.destroy()},700),t.transitionEnd(function(){clearTimeout(a),e.destroy()})})})}};var TouchRipple$1={name:"touch-ripple",static:{TouchRipple:TouchRipple},create:function(){this.touchRipple={create:function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return new(Function.prototype.bind.apply(TouchRipple,[null].concat(e)))}}}},openedModals=[],dialogsQueue=[];function clearDialogsQueue(){0!==dialogsQueue.length&&dialogsQueue.shift().open()}var Modal=function(e){function t(t,r){e.call(this,r,[t]);var a={};return this.useModulesParams(a),this.params=Utils.extend(a,r),this.opened=!1,this.useModules(),this}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t.prototype.onOpen=function(){this.opened=!0,openedModals.push(this),$("html").addClass("with-modal-"+this.type.toLowerCase()),this.$el.trigger("modal:open "+this.type.toLowerCase()+":open",this),this.emit("local::open modalOpen "+this.type+"Open",this)},t.prototype.onOpened=function(){this.$el.trigger("modal:opened "+this.type.toLowerCase()+":opened",this),this.emit("local::opened modalOpened "+this.type+"Opened",this)},t.prototype.onClose=function(){this.opened=!1,this.type&&this.$el&&(openedModals.splice(openedModals.indexOf(this),1),$("html").removeClass("with-modal-"+this.type.toLowerCase()),this.$el.trigger("modal:close "+this.type.toLowerCase()+":close",this),this.emit("local::close modalClose "+this.type+"Close",this))},t.prototype.onClosed=function(){this.type&&this.$el&&(this.$el.removeClass("modal-out"),this.$el.hide(),this.$el.trigger("modal:closed "+this.type.toLowerCase()+":closed",this),this.emit("local::closed modalClosed "+this.type+"Closed",this))},t.prototype.open=function(e){var t,r=this,a=r.app,n=r.$el,o=r.$backdropEl,i=r.type,s=!0;if(void 0!==e?s=e:void 0!==r.params.animate&&(s=r.params.animate),!n||n.hasClass("modal-in"))return r;if("dialog"===i&&a.params.modal.queueDialogs&&($(".dialog.modal-in").length>0?t=!0:openedModals.length>0&&openedModals.forEach(function(e){"dialog"===e.type&&(t=!0)}),t))return dialogsQueue.push(r),r;var l=n.parent(),c=n.parents(doc).length>0;function u(){n.hasClass("modal-out")?r.onClosed():n.hasClass("modal-in")&&r.onOpened()}return a.params.modal.moveToRoot&&!l.is(a.root)&&(a.root.append(n),r.once(i+"Closed",function(){c?l.append(n):n.remove()})),n.show(),r._clientLeft=n[0].clientLeft,s?(o&&(o.removeClass("not-animated"),o.addClass("backdrop-in")),n.animationEnd(function(){u()}),n.transitionEnd(function(){u()}),n.removeClass("modal-out not-animated").addClass("modal-in"),r.onOpen()):(o&&o.addClass("backdrop-in not-animated"),n.removeClass("modal-out").addClass("modal-in not-animated"),r.onOpen(),r.onOpened()),r},t.prototype.close=function(e){var t=this,r=t.$el,a=t.$backdropEl,n=!0;if(void 0!==e?n=e:void 0!==t.params.animate&&(n=t.params.animate),!r||!r.hasClass("modal-in"))return t;if(a){var o=!0;"popup"===t.type&&t.$el.prevAll(".popup.modal-in").each(function(e,r){var a=r.f7Modal;a&&a.params.closeByBackdropClick&&a.params.backdrop&&a.backdropEl===t.backdropEl&&(o=!1)}),o&&(a[n?"removeClass":"addClass"]("not-animated"),a.removeClass("backdrop-in"))}function i(){r.hasClass("modal-out")?t.onClosed():r.hasClass("modal-in")&&t.onOpened()}return r[n?"removeClass":"addClass"]("not-animated"),n?(r.animationEnd(function(){i()}),r.transitionEnd(function(){i()}),r.removeClass("modal-in").addClass("modal-out"),t.onClose()):(r.addClass("not-animated").removeClass("modal-in").addClass("modal-out"),t.onClose(),t.onClosed()),"dialog"===t.type&&clearDialogsQueue(),t},t.prototype.destroy=function(){this.destroyed||(this.emit("local::beforeDestroy modalBeforeDestroy "+this.type+"BeforeDestroy",this),this.$el&&(this.$el.trigger("modal:beforedestroy "+this.type.toLowerCase()+":beforedestroy",this),this.$el.length&&this.$el[0].f7Modal&&delete this.$el[0].f7Modal),Utils.deleteProps(this),this.destroyed=!0)},t}(Framework7Class),CustomModal=function(e){function t(t,r){var a=Utils.extend({backdrop:!0,closeByBackdropClick:!0,on:{}},r);e.call(this,t,a);var n,o,i=this;if(i.params=a,(n=i.params.el?$(i.params.el):$(i.params.content))&&n.length>0&&n[0].f7Modal)return n[0].f7Modal;if(0===n.length)return i.destroy();function s(e){i&&!i.destroyed&&o&&e.target===o[0]&&i.close()}return i.params.backdrop&&0===(o=t.root.children(".custom-modal-backdrop")).length&&(o=$('<div class="custom-modal-backdrop"></div>'),t.root.append(o)),i.on("customModalOpened",function(){i.params.closeByBackdropClick&&i.params.backdrop&&t.on("click",s)}),i.on("customModalClose",function(){i.params.closeByBackdropClick&&i.params.backdrop&&t.off("click",s)}),Utils.extend(i,{app:t,$el:n,el:n[0],$backdropEl:o,backdropEl:o&&o[0],type:"customModal"}),n[0].f7Modal=i,i}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t}(Modal),Modal$1={name:"modal",static:{Modal:Modal,CustomModal:CustomModal},create:function(){var e=this;e.customModal={create:function(t){return new CustomModal(e,t)}}},params:{modal:{moveToRoot:!0,queueDialogs:!0}}};return"undefined"!=typeof window&&(window.Template7||(window.Template7=Template7),window.Dom7||(window.Dom7=$)),Router.use([RouterTemplateLoaderModule,RouterComponentLoaderModule]),Framework7.use([DeviceModule,SupportModule,UtilsModule,ResizeModule,RequestModule,TouchModule,ClicksModule,RouterModule,HistoryModule,StorageModule,ComponentModule,ServiceWorkerModule,Statusbar$1,View$1,Navbar$1,Toolbar$1,Subnavbar,TouchRipple$1,Modal$1]),Framework7});
//# sourceMappingURL=framework7.min.js.map