console.log('testando o arquivo :)');
var inicial = {
	latitude: -2.532810
	, longitude: -44.267051
};
var divDoMapa = document.getElementById("map_canvas")
var opcoes = { 
  center: new google.maps.LatLng(inicial.latitude, inicial.longitude),
  zoom: 12
  //mapTypeId: google.maps.MapTypeId.HYBRID
};

function initialize() {
	 			geocoder = new google.maps.Geocoder();
        map = new google.maps.Map(divDoMapa, opcoes);
        var autoCompleteInput = document.getElementById('endereco');
				var autoCompleteOpcoes = {types: ['geocode']};
				autocomplete = new google.maps.places.Autocomplete(autoCompleteInput,autoCompleteOpcoes);
}

var imagens = {
	muitoBom: 'https://dynamostecnologia.com.br/appfrete/img/iconel.png'
	, bom: 'http://i.imgur.com/VnlbIoL.png'
	, medio: 'http://i.imgur.com/eNAvIvr.png'
	, ruim: 'http://i.imgur.com/uCRXqdV.png'
	, pessimo: 'http://i.imgur.com/biRJBNL.png'
}

var marcadores = [];
function criaMarcador(marcador, mapa) {
	for(i=0; i<marcadores.length; i++){
        marcadores[i].setMap(null);
    }	
	var posicao = new google.maps.LatLng(marcador.latitude, marcador.longitude);
	var opcoes = {
    position: posicao
    , title: marcador.titulo
	, draggable: true
    , animation: google.maps.Animation.DROP
    , icon:{
    		url: marcador.imagem
    		, scaledSize: new google.maps.Size(35, 35)
    	}
    , map: mapa
  }
	var novoMarcador = new google.maps.Marker(opcoes);
	marcadores.push(novoMarcador);
	map.setCenter(novoMarcador.position)
	//listaMarcadores();
	google.maps.event.addListener(novoMarcador, 'dragend', function (event) {
		geocoder.geocode({ 'latLng': novoMarcador.getPosition() }, function (results, status) {
            if (status == google.maps.GeocoderStatus.OK) {
                    if (results[0]) { 
						console.log(results[0].formatted_address);
						console.log(novoMarcador.getPosition().lat());
						console.log(novoMarcador.getPosition().lng());
					}
            }
        });
		
	});
}


function converteEndereco(endereco, avaliacao) {
  geocoder.geocode( { 'address': endereco}, function(resultado, status) {
    if (status == google.maps.GeocoderStatus.OK) {
      var marcador = {
		      	latitude: resultado[0].geometry.location.k
				, longitude: resultado[0].geometry.location.D	
				, titulo: 'Meu local'
				, imagem: avaliacao
				
      }
	     criaMarcador(marcador, map)
    } else {
      alert('Erro ao converter endereço: ' + status);
    }
  });
}

var imgArray = [imagens.muitoBom, imagens.bom, imagens.medio, imagens.ruim, imagens.pessimo]

function novoLocal() {
	var local = autocomplete.getPlace();
	var seletor = document.getElementById("avaliacao");
	var avaliacao = seletor.options[seletor.selectedIndex].value;
	var imagemMarcador = imgArray[avaliacao];
	var marcador = {
		latitude: local.geometry.location.lat()
		, longitude: local.geometry.location.lng()	
		, titulo: local.name
		, imagem: imagemMarcador
	}
	criaMarcador(marcador, map);
	map.setZoom(18)
	map.setCenter(local.geometry.location)
}


function listaMarcadores(){
	var qtdMarcadores = marcadores.length;
	var listaDeMarcadores = document.getElementById('listaDeMarcadores');
	listaDeMarcadores.innerHTML = "";
	for (var i = 0; i < qtdMarcadores; i++) {
	  var btn = document.createElement('button');
	  btn.setAttribute("onclick","map.setCenter(marcadores["+i+"].position);map.setZoom(20);")
	  btn.appendChild(document.createTextNode(marcadores[i].title));
	  listaDeMarcadores.appendChild(btn);		
	}
}

initialize();