routes = [
	{
		path: '/',
		url: './index.html',
	},
	{
		path: '/login/',
		componentUrl: './pages/login.html',
	},
	{
		path: '/esqueceu/',
		componentUrl: './pages/esqueceu.html',
	},
	{
		path: '/cadastrar/',
		componentUrl: './pages/cadastrar.html',
	},
	{
		path: '/home/',
		componentUrl: './pages/home.html',
	},
	{
		path: '/nova-vistoria/',
		componentUrl: './pages/nova-vistoria.html', 
	},
	{
		path: '/lista-vistoria-andamento/',
		componentUrl: './pages/lista-vistoria-andamento.html', 
	},
	{
		path: '/detalhe-vistoria/',
		componentUrl: './pages/detalhe-vistoria.html', 
	},
{
		path: '/detalhe-vistoria-final/',
		componentUrl: './pages/detalhe-vistoria-final.html', 
	},	
	{
		path: '/ambiente-vistoria/',
		componentUrl: './pages/ambiente-vistoria.html', 
	},
	{
		path: '/ambiente-vistoria-final/',
		componentUrl: './pages/ambiente-vistoria-final.html', 
	},	
	{
		path: '/planos/',
		componentUrl: './pages/planos.html', 
	},
    {
		path: '/upgrade-planos/',
		componentUrl: './pages/upgradeplano.html',  
	},	
	{
		path: '/pagamento/',
		componentUrl: './pages/pagamento.html', 
	},
	{
		path: '/pagamento-adicional/',
		componentUrl: './pages/pagamento-adicional.html', 
	},
	{
		path: '/resultadopagamento/',
		componentUrl: './pages/resultadopagamento.html', 
	},
	{
		path: '/perfil/',
		componentUrl: './pages/perfil.html', 
	},
	{
		path: '/meu-plano/',
		componentUrl: './pages/meu-plano.html', 
	},
	{
		path: '/simule/',
		componentUrl: './pages/simule.html', 
	},
    {
		path: '/cancelar-plano/',
		componentUrl: './pages/cancelar-plano.html',  
	},
	{
        path: '/nova-vistoria-dev/',
        componentUrl: './pages/nova-vistoria-dev.html',
    },
  
  // Page Loaders & Router
  {
    path: '/page-loader-template7/:user/:userId/:posts/:postId/',
    templateUrl: './pages/page-loader-template7.html',
  },
  {
    path: '/page-loader-component/:user/:userId/:posts/:postId/',
    componentUrl: './pages/page-loader-component.html',
  },
  {
    path: '/request-and-load/user/:userId/',
    async: function (routeTo, routeFrom, resolve, reject) {
      // Router instance
      var router = this;

      // App instance
      var app = router.app;

      // Show Preloader
      app.preloader.show();

      // User ID from request
      var userId = routeTo.params.userId;

      // Simulate Ajax Request
      setTimeout(function () {
        // We got user data from request
        var user = {
          firstName: 'Vladimir',
          lastName: 'Kharlampidi',
          about: 'Hello, i am creator of Framework7! Hope you like it!',
          links: [
            {
              title: 'Framework7 Website',
              url: 'http://framework7.io',
            },
            {
              title: 'Framework7 Forum',
              url: 'http://forum.framework7.io',
            },
          ]
        };
        // Hide Preloader
        app.preloader.hide();

        // Resolve route to load page
        resolve(
          {
            componentUrl: './pages/request-and-load.html',
          },
          {
            context: {
              user: user,
            }
          }
        );
      }, 1000);
    },
  },
  // Default route (404 page). MUST BE THE LAST
  {
    path: '(.*)',
    url: './pages/404.html',
  },
];
