<?php
header('Content-type: application/json');

include "includes/config.php";
include "includes/mysql.php";
include "includes/sessoes.php";
session_start();

if (!SessaoOk()) {
    http_response_code(401);
    echo json_encode([
        'success' => false,
        'message' => 'Você precisa se autenticar',
    ]);
    exit();
}
$usuarioId = $_SESSION['login']['id'];

$vistoriaId = isset($_POST['codvistoria']) ? $_POST['codvistoria'] : null;
if (!$vistoriaId) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => 'Você precisa selecionar uma vistoria',
    ]);
    exit();
}

/**
 * Retorna uma data no formato dd/mm/YYYY
 *
 * @param string|null $data
 * @return string
 */
function format_date($data)
{
    if (!$data) {
        return '';
    }
    return sprintf("%02d/%02d/%d",
        (int) substr($data, 8, 2),
        (int) substr($data, 5, 2),
        (int) substr($data, 0, 4)
    );
}

/**
 * Retorna o tipo do signatário em formato de título
 *
 * @param string $data
 * @return string
 */
function format_tipo_do_signatario($data)
{
    return [
        'vistoriador' => 'Vistoriador',
        'locatario' => 'Locatário',
        'locador' => 'Locador',
    ][$data];
}

/**
 * Retorna o signatário formatado para JSON
 *
 * @param array $row
 * @return array
 */
function format_signatario(array $row)
{
    return array_merge($row, [
        'assinou' => boolval($row['assinou']),
        'tipo' => [
            'titulo' => format_tipo_do_signatario($row['tipo']),
            'id' => $row['tipo'],
        ],
    ]);
}

/**
 * Retorna o status do processo em formato de título
 *
 * @param string $data
 * @return string
 */
function format_status_do_processo($data)
{
    return [
        'canceled' => 'Cancelado',
        'running' => 'Vigente',
        'closed' => 'Finalizado',
    ][$data];
}

/**
 * Retorna o processo formatado para JSON
 *
 * @param array $row
 * @return array
 */
function format_processo_de_assinatura(array $row)
{
    return array_merge($row, [
        'id' => intval($row['id']),
        'status' => [
            'titulo' => format_status_do_processo($row['status']),
            'id' => $row['status'],
        ]
    ]);
}

$vistorias = dbQuery("
    SELECT 
        vi.*, 
	    im.foto_capa, im.subtipo_imovel_id, im.observacoes as obs_imovel,  
		en.logradouro, en.numero, en.complemento, en.bairro, en.cidade, en.uf, en.cep,
		ti.nome, ti.tipo_imovel_id
    FROM vistorias as vi 
	LEFT JOIN imoveis as im on(vi.imovel_id = im.id)
	LEFT JOIN enderecos as en on(im.endereco_id = en.id)
	LEFT JOIN subtipos_imoveis as ti on(im.subtipo_imovel_id = ti.id)
	WHERE 
	    vi.user_id = '$usuarioId' 
	    AND vi.id = '$vistoriaId'
");

$resposta = [];
while ($vistoria = dbfetcharray($vistorias)) {

    if (!empty($vistoria['capa'])) {
        global $urlbase_capa;

        $vistoria['capa'] = $urlbase_capa . $vistoria['capa'];
    } 
    $vistoria['data_vistoria'] = format_date(
        $vistoria['data_vistoria']
    );

    $ambientes = dbQuery("
        SELECT 
            av.id AS ambiente_vistoria_id, av.qtd, av.ordem,
            am.id, am.nome
        FROM ambientes_vistorias AS av
        LEFT JOIN ambientes AS am ON (av.ambiente_id = am.id)
        WHERE av.vistoria_id = '$vistoriaId' AND av.deleted_at IS NULL
        ORDER BY 
            av.ordem ASC,
            am.nome ASC
    ");
    $vistoria['ambientes'] = [];
    while ($ambiente = dbfetcharray($ambientes)) {
        $vistoria['ambientes'][] = $ambiente;
    }

    if ($vistoria['status'] === 'concluida') {
        $processoDeAssinatura = dbFetchArray(dbQuery("
            SELECT
                id,
                document_status AS status,
                document_original_file_link AS originalDocument,
                document_signed_file_link AS signedDocument
            FROM processos_de_assinatura
            WHERE vistoria_id = $vistoriaId
            ORDER BY id DESC
            LIMIT 1
        "));
        $vistoria['processoDeAssinaturaAtual'] = null;
        if ($processoDeAssinatura) {
            $signatariosDoProcesso = dbQuery("
                SELECT
                    tipo,
                    nome,
                    email,
                    has_signed AS assinou,
                    sign_url AS linkDeAssinatura
                FROM signatarios_dos_processos
                WHERE processo_de_assinatura_id = {$processoDeAssinatura['id']}
            ");
            $processoDeAssinatura['signatarios'] = [];
            while ($signatarioDoProcesso = dbFetchArray($signatariosDoProcesso)) {
                $processoDeAssinatura['signatarios'][] = format_signatario($signatarioDoProcesso);
            }
            $vistoria['processoDeAssinaturaAtual'] = format_processo_de_assinatura($processoDeAssinatura);
        }
    }
    $resposta[] = $vistoria;
}
echo json_encode($resposta);
