<?php

class asaas
{

    private $ApiKey;
    private $UrlBase;
    private $UrlSandbox = "https://sandbox.asaas.com/api/v3/";
    private $UrlProducao = "https://www.asaas.com/api/v3/";
    private $Comando;
    private $Limit = 100;
    private $Erros = array();

    function __construct($apikey, $ambiente = 'sandbox')
    {
        $this->ApiKey = $apikey;
        if ($ambiente == 'producao') {
            $this->UrlBase = $this->UrlProducao;
        } elseif ($ambiente == 'sandbox') {
            $this->UrlBase = $this->UrlSandbox;
        } else {
            $this->UrlBase = $this->UrlSandbox;
        }
    }

    function CriarCliente($dados)
    {
        $this->Comando = 'customers';
        $retorno = json_decode($this->webhook($dados, 'POST'));
        //print_r($retorno);
        if (is_object($retorno)) {
            if (is_array($retorno->errors)) {
                $ret = new stdClass();
                foreach ($retorno->errors as $v) {
                    $ret->Erros[] = $v->description;
                }
                $retorno = $ret;
            }
        }
        return $retorno;
    }

    function BuscarClientePorCpf($cpf){
        $this->Comando = 'customers?cpfCnpj='.$cpf;
        $retorno = json_decode($this->webhook([], 'GET'));
        return $retorno;
    }

    function CriarCobranca($dados)
    {
        $this->Comando = 'payments';
        $retorno = json_decode($this->webhook($dados, 'POST'));
        //print_r($retorno);
        if (is_object($retorno)) {
            if (is_array($retorno->errors)) {
                $ret = new stdClass();
                foreach ($retorno->errors as $v) {
                    $ret->Erros[] = $v->description;
                }
                $retorno = $ret;
            }
        }
        return $retorno;
    }

    function CriarAssinatura($dados)
    {
        $this->Comando = 'subscriptions';
        $retorno = json_decode($this->webhook($dados, 'POST'));
        //print_r($retorno);
        if (is_object($retorno)) {
            if (is_array($retorno->errors)) {
                $ret = new stdClass();
                foreach ($retorno->errors as $v) {
                    $ret->Erros[] = $v->description;
                }
                $retorno = $ret;
            }
        }
        return $retorno;
    }


    function CriarParcelamento($dados) {
        $this->Comando='installments';
        $retorno=json_decode($this->webhook($dados,'POST'));
        //print_r($retorno);
        if (is_object($retorno)){
            if (is_array($retorno->errors)){
                $ret = new stdClass();
                foreach($retorno->errors as $v){
                    $ret->Erros[]=$v->description;
                }
                $retorno=$ret;
            }
        }
        return $retorno;
    }
    function ListarCobrancasParcelamentos($parcelamentos_id)
    {
        $offset = 0;
        $limit = $this->Limit;
        $cobrancas = array();
        do {
            $this->Comando = "installments/$parcelamentos_id/payments";
            //echo $this->Comando;
            $retorno = json_decode($this->webhook([], 'GET'));
            //print_r($retorno);

            if (is_object($retorno)) {
                if (is_array($retorno->errors)) {
                    $ret = new stdClass();
                    foreach ($retorno->errors as $v) {
                        $ret->Erros[] = $v->description;
                    }
                    $jdados = json_encode($parcelamentos_id);
                    $jerros = json_encode($ret->Erros);
                    $this->logar("installments", 'GET', $jdados, $jerros);

                    $cobrancas = $ret;
                    break;
                }
            }
            foreach ($retorno->data as $v) {
                $cobrancas[] = $v;
            }
            $offset += $limit;
        } while ($retorno->hasMore == 1);
        return $cobrancas;
    }
    function ModificarAssinatura($id, $dados)
    {
        $this->Comando = "subscriptions/$id";
        $retorno = json_decode($this->webhook($dados, 'PUT'));
        //print_r($retorno);
        if (is_object($retorno)) {
            if (is_array($retorno->errors)) {
                $ret = new stdClass();
                foreach ($retorno->errors as $v) {
                    $ret->Erros[] = $v->description;
                }
                $retorno = $ret;
            }
        }
        return $retorno;
    }

    function ModificarCobranca($id, $dados)
    {
        $this->Comando = "payments/$id";
        $retorno = json_decode($this->webhook($dados, 'PUT'));
        //print_r($retorno);
        if (is_object($retorno)) {
            if (is_array($retorno->errors)) {
                $ret = new stdClass();
                foreach ($retorno->errors as $v) {
                    $ret->Erros[] = $v->description;
                }
                $retorno = $ret;
            }
        }
        return $retorno;
    }

    function transferir($dados)
    {
        //print_r($dados);
        $this->Comando = 'transfers';
        $retorno = json_decode($this->webhook($dados, 'POST'));
        //print_r($retorno);
        if (is_object($retorno)) {
            if (is_array($retorno->errors)) {
                $ret = new stdClass();
                foreach ($retorno->errors as $v) {
                    $ret->Erros[] = $v->description;
                }
                $retorno = $ret;
            }
        }
        return $retorno;
    }

    function ListarClientes($filtro = '')
    {
        $offset = 0;
        $limit = $this->Limit;
        $clientes = array();
        do {
            $this->Comando = "customers?offset=$offset&limit=$limit$filtro";
            $retorno = json_decode($this->webhook([], 'GET'));
            if (is_object($retorno)) {
                if (is_array($retorno->errors)) {
                    $ret = new stdClass();
                    foreach ($retorno->errors as $v) {
                        $ret->Erros[] = $v->description;
                    }
                    $clientes = $ret;
                    break;
                }
            }
            foreach ($retorno->data as $v) {
                $clientes[] = $v;
            }
            $offset += $limit;
        } while ($retorno->hasMore == 1);
        return $clientes;
    }

    function ListarAssinaturas($filtro = '')
    {
        $offset = 0;
        $limit = $this->Limit;
        $assinaturas = array();
        do {
            $this->Comando = "subscriptions?offset=$offset&limit=$limit$filtro";
            $retorno = json_decode($this->webhook([], 'GET'));
            if (is_object($retorno)) {
                if (is_array($retorno->errors)) {
                    $ret = new stdClass();
                    foreach ($retorno->errors as $v) {
                        $ret->Erros[] = $v->description;
                    }
                    $assinaturas = $ret;
                    break;
                }
            }
            foreach ($retorno->data as $v) {
                $assinaturas[] = $v;
            }
            $offset += $limit;
        } while ($retorno->hasMore == 1);
        return $assinaturas;
    }


    function ListarCobranca($filtro = '')
    {
        $offset = 0;
        $limit = $this->Limit;
        $assinaturas = array();
        do {
            $this->Comando = "payments?offset=$offset&limit=$limit$filtro";
            //echo $this->Comando;
            $retorno = json_decode($this->webhook([], 'GET'));
            //print_r($retorno);

            if (is_object($retorno)) {
                if (is_array($retorno->errors)) {
                    $ret = new stdClass();
                    foreach ($retorno->errors as $v) {
                        $ret->Erros[] = $v->description;
                    }
                    $jdados = json_encode($filtro);
                    $jerros = json_encode($ret->Erros);
                    $this->logar("payments", 'GET', $jdados, $jerros);

                    $assinaturas = $ret;
                    break;
                }
            }
            foreach ($retorno->data as $v) {
                $assinaturas[] = $v;
            }
            $offset += $limit;
        } while ($retorno->hasMore == 1);
        return $assinaturas;
    }

    function BuscarCobranca($asaas_id){
        $this->Comando = "payments/$asaas_id";
        $retorno = json_decode($this->webhook([], 'GET'));
        return $retorno;

    }

    function ListarCobrancasAssinatura($assinatura_id)
    {
        $offset = 0;
        $limit = $this->Limit;
        $cobrancas = array();
        do {
            $this->Comando = "subscriptions/$assinatura_id/payments";
            //echo $this->Comando;
            $retorno = json_decode($this->webhook([], 'GET'));
            //print_r($retorno);

            if (is_object($retorno)) {
                if (is_array($retorno->errors)) {
                    $ret = new stdClass();
                    foreach ($retorno->errors as $v) {
                        $ret->Erros[] = $v->description;
                    }
                    $jdados = json_encode($assinatura_id);
                    $jerros = json_encode($ret->Erros);
                    $this->logar("subscriptions", 'GET', $jdados, $jerros);

                    $cobrancas = $ret;
                    break;
                }
            }
            foreach ($retorno->data as $v) {
                $cobrancas[] = $v;
            }
            $offset += $limit;
        } while ($retorno->hasMore == 1);
        return $cobrancas;
    }

    function ListarParcelamentos($filtro = '')
    {
        $offset = 0;
        $limit = $this->Limit;
        $parcelamentos = array();
        do {
            $this->Comando = "installments?offset=$offset&limit=$limit$filtro";
            $retorno = json_decode($this->webhook([], 'GET'));
            if (is_object($retorno)) {
                if (is_array($retorno->errors)) {
                    $ret = new stdClass();
                    foreach ($retorno->errors as $v) {
                        $ret->Erros[] = $v->description;
                    }
                    $parcelamentos = $ret;
                    break;
                }
            }
            foreach ($retorno->data as $v) {
                $parcelamentos[] = $v;
            }
            $offset += $limit;
        } while ($retorno->hasMore == 1);
        return $parcelamentos;
    }

    function PegarCobranca($id)
    {
        $assinaturas = array();
        $this->Comando = "payments/$id";
        $retorno = json_decode($this->webhook([], 'GET'));
        return $retorno;
    }

    function PegarLinhaDigitavel($id)
    {
        $this->Comando = "payments/$id/identificationField";
        $retorno = json_decode($this->webhook([], 'GET'));
        return $retorno;
    }


    function PegarQrCode($id)
    {
        $offset = 0;
        $limit = $this->Limit;
        $assinaturas = array();
        $this->Comando = "payments/$id/pixQrCode";
        $retorno = json_decode($this->webhook([], 'GET'));
        //echo $retorno;
        return $retorno;
    }

    function PegarAssinatura($id)
    {
        $assinaturas = array();
        $this->Comando = "subscriptions/$id";
        $retorno = json_decode($this->webhook([], 'GET'));
        return $retorno;
    }

    function PegarCliente($id)
    {
        $assinaturas = array();
        $this->Comando = "customers/$id";
        $retorno = json_decode($this->webhook([], 'GET'));
        return $retorno;
    }

    function PegarTokenCliente($dados)
    {
        $this->Comando = 'payments';
        $retorno = json_decode($this->webhook($dados, 'G'));
        //print_r($retorno);
        if (is_object($retorno)) {
            if (is_array($retorno->errors)) {
                $ret = new stdClass();
                foreach ($retorno->errors as $v) {
                    $ret->Erros[] = $v->description;
                }
                $retorno = $ret;
            }
        }
        return $retorno;
    }

    function ApagarAssinatura($id)
    {
        $assinaturas = array();
        $this->Comando = "subscriptions/$id";
        $retorno = json_decode($this->webhook([], 'DELETE'));
        return $retorno;
    }

    function ApagarCobranca($id)
    {
        $assinaturas = array();
        $this->Comando = "payments/$id";
        $retorno = json_decode($this->webhook([], 'DELETE'));
        return $retorno;
    }

    function AtualizarAssinatura($id, $dados)
    {
        $assinaturas = array();
        $this->Comando = "subscriptions/$id";
        $retorno = json_decode($this->webhook($dados, 'PUT'));
        return $retorno;
    }

    function webhook($dados, $method)
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $this->UrlBase . $this->Comando);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_HEADER, FALSE);
        if ($method == 'POST') {
            curl_setopt($ch, CURLOPT_POST, TRUE);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($dados));
        } else if ($method == 'DELETE') {
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "DELETE");
        } else if ($method == 'PUT') {
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($dados));
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
        }
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            "Content-Type: application/json",
            "access_token: " . $this->ApiKey,
            "User-Agent: cliente-php"
        ));
        $response = curl_exec($ch);

        if ($response === false) {
            $message = curl_error($ch);
            $code = curl_errno($ch);
            $info = json_encode(curl_getinfo($ch));
            error_log("cURL error [$code]: $message - $info");
        }
        curl_close($ch);
        return $response;
    }
	
	function logar($endpoint,$metodo, $dados, $erros){
		dbquery("insert into assas_log (dados,problema,endpoint,metodo) values ('$dados','$erros','$endpoint','$metodo')"); 
	} 
}
