<?php


/*
 * @param int $id
 * @param Asaas $asaas
 * @return int $asaas_id
 */
function checkUserExist($id, $asaas){
    $asaas_id = dbfetchScalar("select asaas_id from users where id = '$id'");
    $usuario = dbQuery("select * from users where id = '$id'")->fetch_assoc();
    $clientData = [
        "name" => $usuario['nome'],
        "cpfCnpj" => $usuario['cpf_cnpj'],
        "email" => $usuario['email'],
        "phone" => $usuario['telefone'],
    ];
    if($asaas_id){
        return $asaas_id;
    }else{
        $cpf_limpo = str_replace([".", "-", "/"], "", $usuario['cpf_cnpj']);
        $client = $asaas->BuscarClientePorCpf($cpf_limpo)->data[0];
        if (!empty($client)) {
            $asaas_id = $client->id;
        }
        if($asaas_id){
            dbQuery("UPDATE users SET asaas_id = '$asaas_id' where id = '$id'");
            return $asaas_id;
        }else{
            $client = $asaas->CriarCliente($clientData);
            $asaas_id = $client->id;
            dbQuery("UPDATE users SET asaas_id = '$asaas_id' where id = '$id'");

            if($asaas_id){
                return $asaas_id;
            }else{
                return false;
            }

        }
    }
}

/*
 * @param object $subscribe
 * @param int $user_id
 * @return int | null $subscribe_id
 */
function saveSubscribe($subscribe, $user_id){
    dbQuery("insert into assinatura(asaas_id, user_id, tipo_assinatura, forma_pagamento, status)
            value ('{$subscribe->id}', '$user_id', '{$subscribe->cycle}', '{$subscribe->billingType}', '{$subscribe->status}')");
    $subscribe_id = dbInsertId();
    return $subscribe_id;
}

/**
 * Processa um pagamento e retorna o ID do registro.
 *
 * @param object $payment                Objeto com os dados do pagamento
 * @param int    $plano_user_imobilogia_id  ID do plano do usuário
 * @param int    $assinatura_id             ID da assinatura
 * @param string $tipo_cobranca             Tipo de cobrança ("ASSINATURA" ou "AVULSA")
 *
 * @return int ID do pagamento ($payment_id)
 */

function savePayment($payment, $plano_user_imobilogia_id, $assinatura_id, $tipo_cobranca='ASSINATURA'){
    $asaas_id = $payment->id;
    dbQuery("insert into cobranca(asaas_id, planos_users_imobiliarias_id, assinatura_id, valor, valor_pago, valor_liquido, dt_vencimento, dt_pagamento, status, url_cobranca, tipo_cobranca)
            values ('$asaas_id', '$plano_user_imobilogia_id', '$assinatura_id', '{$payment->value}', '{$payment->value}', '{$payment->netValue}', '{$payment->dueDate}', '{$payment->paymentDate}', '{$payment->status}', '{$payment->invoiceUrl}', '$tipo_cobranca')");
    $payment_id = dbInsertId();
    return $payment_id;
}

/*
 * @param object $payment
 * @param int $plano_user_imobilogia_id
 * @param int $assinatura_id
 * @param int $payment_id
 * @return bool
 */
function updatePayment($payment, $plano_user_imobilogia_id, $assinatura_id, $payment_id){
    $sql = "UPDATE cobranca SET
                asaas_id = '{$payment->id}',
                planos_users_imobiliarias_id = '$plano_user_imobilogia_id',
                assinatura_id = '$assinatura_id',
                valor = '{$payment->value}',
                valor_pago = '{$payment->value}',
                valor_liquido = '{$payment->value}',
                dt_vencimento = '{$payment->dueDate}',
                dt_pagamento = '{$payment->paymentDate}',
                status = '{$payment->status}',
                url_cobranca = '{$payment->invoiceUrl}'
            WHERE id = '$payment_id'";

    return dbQuery($sql);
}

function gerar_senha($tamanho, $maiusculas, $minusculas, $numeros, $simbolos){
  $ma = "ABCDEFGHIJKLMNOPQRSTUVYXWZ"; // $ma contem as letras maiúsculas
  $mi = "abcdefghijklmnopqrstuvyxwz"; // $mi contem as letras minusculas
  $nu = "0123456789"; // $nu contem os números
  $si = "!@#$%¨&*()_+="; // $si contem os símbolos

  if ($maiusculas){
        // se $maiusculas for "true", a variável $ma é embaralhada e adicionada para a variável $senha
        $senha .= str_shuffle($ma);
  }

    if ($minusculas){
        // se $minusculas for "true", a variável $mi é embaralhada e adicionada para a variável $senha
        $senha .= str_shuffle($mi);
    }

    if ($numeros){
        // se $numeros for "true", a variável $nu é embaralhada e adicionada para a variável $senha
        $senha .= str_shuffle($nu);
    }

    if ($simbolos){
        // se $simbolos for "true", a variável $si é embaralhada e adicionada para a variável $senha
        $senha .= str_shuffle($si);
    }

    // retorna a senha embaralhada com "str_shuffle" com o tamanho definido pela variável $tamanho
    return substr(str_shuffle($senha),0,$tamanho);
}

function LerConfig($chave){
	$endereco=$_SESSION['login']['ENDERECO'].", ".
			  $_SESSION['login']['NUMERO']." - ".
			  $_SESSION['login']['BAIRRO']." - ".$_SESSION['login']['COMPLEMENTO'];
	$nome=$_SESSION['login']['NOME'];
	$cpf=$_SESSION['login']['DOCUMENTO'];
	$rg=$_SESSION['login']['RG'];
	$retorno=dbfetchScalar("select valor from config where chave='$chave'");
	eval("\$retorno = \"$retorno\";");
	return $retorno;
}


class JWT
{
	/**
	 * Decodes a JWT string into a PHP object.
	 *
	 * @param string      $jwt    The JWT
	 * @param string|null $key    The secret key
	 * @param bool        $verify Don't skip verification process 
	 *
	 * @return object      The JWT's payload as a PHP object
	 * @throws UnexpectedValueException Provided JWT was invalid
	 * @throws DomainException          Algorithm was not provided
	 * 
	 * @uses jsonDecode
	 * @uses urlsafeB64Decode
	 */
	public static function decode($jwt, $key = null, $verify = false)
	{
		//echo "aqui";
		//exit;
		$tks = explode('.', $jwt);
		//print_r($tks);
		if (count($tks) != 3) {
			throw new UnexpectedValueException('Wrong number of segments');
		}
		list($headb64, $bodyb64, $cryptob64) = $tks;
		if (null === ($header = JWT::jsonDecode(JWT::urlsafeB64Decode($headb64)))) {
			throw new UnexpectedValueException('Invalid segment encoding');
		}
		if (null === $payload = JWT::jsonDecode(JWT::urlsafeB64Decode($bodyb64))) {
			throw new UnexpectedValueException('Invalid segment encoding');
		}
		$sig = JWT::urlsafeB64Decode($cryptob64);
		//echo "2";
		if ($verify) {
			if (empty($header->alg)) {
				throw new DomainException('Empty algorithm');
			}
			if ($sig != JWT::sign("$headb64.$bodyb64", $key, $header->alg)) {
				throw new UnexpectedValueException('Signature verification failed');
			}
		}
		//echo "3";
		return $payload;
	}
	/**
	 * Converts and signs a PHP object or array into a JWT string.
	 *
	 * @param object|array $payload PHP object or array
	 * @param string       $key     The secret key
	 * @param string       $algo    The signing algorithm. Supported
	 *                              algorithms are 'HS256', 'HS384' and 'HS512'
	 *
	 * @return string      A signed JWT
	 * @uses jsonEncode
	 * @uses urlsafeB64Encode
	 */
	public static function encode($payload, $key, $algo = 'HS256')
	{
		$header = array('typ' => 'JWT', 'alg' => $algo);
		$segments = array();
		$segments[] = JWT::urlsafeB64Encode(JWT::jsonEncode($header));
		$segments[] = JWT::urlsafeB64Encode(JWT::jsonEncode($payload));
		$signing_input = implode('.', $segments);
		$signature = JWT::sign($signing_input, $key, $algo);
		$segments[] = JWT::urlsafeB64Encode($signature);
		return implode('.', $segments);
	}
	/**
	 * Sign a string with a given key and algorithm.
	 *
	 * @param string $msg    The message to sign
	 * @param string $key    The secret key
	 * @param string $method The signing algorithm. Supported
	 *                       algorithms are 'HS256', 'HS384' and 'HS512'
	 *
	 * @return string          An encrypted message
	 * @throws DomainException Unsupported algorithm was specified
	 */
	public static function sign($msg, $key, $method = 'HS256')
	{
		$methods = array(
			'HS256' => 'sha256',
			'HS384' => 'sha384',
			'HS512' => 'sha512',
		);
		if (empty($methods[$method])) {
			throw new DomainException('Algorithm not supported');
		}
		return hash_hmac($methods[$method], $msg, $key, true);
	}
	/**
	 * Decode a JSON string into a PHP object.
	 *
	 * @param string $input JSON string
	 *
	 * @return object          Object representation of JSON string
	 * @throws DomainException Provided string was invalid JSON
	 */
	public static function jsonDecode($input)
	{
		$obj = json_decode($input);
		if (function_exists('json_last_error') && $errno = json_last_error()) {
			JWT::_handleJsonError($errno);
		} else if ($obj === null && $input !== 'null') {
			throw new DomainException('Null result with non-null input');
		}
		return $obj;
	}
	/**
	 * Encode a PHP object into a JSON string.
	 *
	 * @param object|array $input A PHP object or array
	 *
	 * @return string          JSON representation of the PHP object or array
	 * @throws DomainException Provided object could not be encoded to valid JSON
	 */
	public static function jsonEncode($input)
	{
		$json = json_encode($input);
		if (function_exists('json_last_error') && $errno = json_last_error()) {
			JWT::_handleJsonError($errno);
		} else if ($json === 'null' && $input !== null) {
			throw new DomainException('Null result with non-null input');
		}
		return $json;
	}
	/**
	 * Decode a string with URL-safe Base64.
	 *
	 * @param string $input A Base64 encoded string
	 *
	 * @return string A decoded string
	 */
	public static function urlsafeB64Decode($input)
	{
		$remainder = strlen($input) % 4;
		if ($remainder) {
			$padlen = 4 - $remainder;
			$input .= str_repeat('=', $padlen);
		}
		return base64_decode(strtr($input, '-_', '+/'));
	}
	/**
	 * Encode a string with URL-safe Base64.
	 *
	 * @param string $input The string you want encoded
	 *
	 * @return string The base64 encode of what you passed in
	 */
	public static function urlsafeB64Encode($input)
	{
		return str_replace('=', '', strtr(base64_encode($input), '+/', '-_'));
	}
	/**
	 * Helper method to create a JSON error.
	 *
	 * @param int $errno An error number from json_last_error()
	 *
	 * @return void
	 */
	private static function _handleJsonError($errno)
	{
		$messages = array(
			JSON_ERROR_DEPTH => 'Maximum stack depth exceeded',
			JSON_ERROR_CTRL_CHAR => 'Unexpected control character found',
			JSON_ERROR_SYNTAX => 'Syntax error, malformed JSON'
		);
		throw new DomainException(
			isset($messages[$errno])
			? $messages[$errno]
			: 'Unknown JSON error: ' . $errno
		);
	}
}

function mascararNumero($numero, $visiveis = 4) {
    $numero = strval($numero);
    $tamanho = strlen($numero);
    
    if ($visiveis >= $tamanho) {
        // Se o número de dígitos visíveis for maior ou igual ao tamanho, não mascara nada
        return $numero;
    }
    
    $mascara = str_repeat('*', $tamanho - $visiveis);
    $visivel = substr($numero, -$visiveis);
    
    return $mascara . $visivel;
}

function listaVistoriasEmAndamento($where){
	$usuario = $_SESSION['login']['id'];
	global $urlbase_capa;
	
	$q= dbQuery($c="select * from vistorias  where  user_id = '$usuario' $where order by data_vistoria desc");
	
	while($r=dbfetcharray($q)){
		$qi = dbQuery("select * from imoveis  where id = '{$r['imovel_id']}' and deleted_at is null");
		$r['imoveis']=[];
		while ($ri=dbFetchArray($qi)){
			$qe = dbQuery("select * from enderecos where id = '{$ri['endereco_id']}' and deleted_at is null");
			$ri['enderecos']=[];
			while ($re=dbFetchArray($qe)){
				$ri['enderecos'][$re['id']]=$re;
			}
			$qs = dbQuery("select * from subtipos_imoveis where id = '{$ri['subtipo_imovel_id']}' and deleted_at is null");
			$ri['subtipos']=[];
			while ($rs=dbFetchArray($qs)){
				$ri['subtipos'][$rs['id']]=$rs;
			} 			
			$r['imoveis'][$ri['id']]=$ri;
		}
		$qav = dbQuery("select av.*,a.nome from ambientes_vistorias av 
						left join ambientes a on a.id=av.ambiente_id
		where vistoria_id = '{$r['id']}' and av.deleted_at is null order by ordem,nome  desc");
		$r['ambientesVistorias']=[];
		while ($rav=dbFetchArray($qav)){
			$qaiv = dbQuery("select * from ambientes_itens_vistorias where ambiente_vistoria_id = '{$rav['id']}' and deleted_at is null");
			$rav['ambientesItensVistorias']=[];
			while ($raiv=dbFetchArray($qaiv)){
				$rav['ambientesItensVistorias'][$raiv['id']]=$raiv;
			} 			
			$r['ambientesVistorias'][$rav['id']]=$rav;
		} 		
		if($r['capa']){
			$r['foto_capa'] = $urlbase_capa . $r['capa'];
		}else{
			$r['foto_capa'] = 'img/checklist_casa.png';
		}
		$data=$r['data_vistoria'];
		$r['data_vistoria']=str_pad(substr($data,8,2),2,0,STR_PAD_LEFT)."/".str_pad(substr($data,5,2),2,0,STR_PAD_LEFT)."/".substr($data,0,4);
		$r['online']=='S';
		
		$resposta[$r['id']] = $r;
	
	}	
	return $resposta;
}

?>