<?php
include "includes/config.php";
include "includes/mysql.php";
include "includes/sessoes.php";
include "includes/mrpay.php";
include "includes/asaas.php";
include "includes/lib.php";

global $cfg;

session_start();


if(SessaoOk()){

    $asaas = new Asaas($cfg['tokenasaas'],$cfg['ambienteassas']);

    function datapadrao($data){
        if($data){
            return(str_pad(substr($data,8,2),2,0,STR_PAD_LEFT)."/".str_pad(substr($data,5,2),2,0,STR_PAD_LEFT)."/".substr($data,0,4));
        }
    }

    $usuario = $_SESSION['login']['id'];
    $imobiliaria = dbfetchScalar("select imobiliaria_id from users where id = '$usuario'");

    $client = dbQuery("select * from users where id = '$usuario'")->fetch_assoc();
    $id_asaas_cliente = checkUserExist($client["id"], $asaas);

    $plano = $_POST['plano'];
    $qtd_plano = $_POST['qtd_plano'];
    $qtd_usuario = $_POST['qtd_usuario'];
    $valor_plano = $_POST['valor_plano'];
    $snlogo = $_POST['snlogo'];

    date_default_timezone_set('America/Fortaleza');
    $hoje = date('Y-m-d H:i:s');
    $forma = $_POST['forma'];

    $cpf_limpo = str_replace([".", "-", "/"], "", $client['cpf_cnpj']);
    $valueSubscrebe = number_format($valor_plano, 2, '.', ',');
    $description = "Assinatura via PIX no valor de R$  " .  number_format($valor_plano, 2, ',', '.');
    $intervalo="MONTHLY";

    $dadosAssinatura = [
        "customer" => $id_asaas_cliente,
        "billingType" => $forma,
        "value" => $valueSubscrebe,
        "dueDate" => date('Y-m-d'),
        "description" => $description,
        "cycle" => $intervalo
    ];

    if($forma == 'CREDIT_CARD'){
        $expiryMonth=$_POST['expiryMonth'];
        $expiryYear = $_POST['expiryYear'];
        $descricao = "Assinatura via Cartão de Crédito no valor de R$  " . number_format($valor_plano, 2, ',', '.');
        $dadosAssinatura["description"] = $descricao;
        // Start Asaas
        $numberCard = str_replace(" ", "", $_POST['number']);
        $creditcard = [
            "holderName" => $_POST['holdername'],
            "number" => $numberCard,
            "expiryYear" => $expiryYear,
            "expiryMonth" => $expiryMonth,
            "ccv" => $_POST['ccv']
        ];

        $creditCardHolderInfo = [
            "name" => $client['nome'],
            "email" => $client['email'],
            "cpfCnpj" => $cpf_limpo,
            "postalCode" => "65071383",
            "addressNumber" => '5',
            "addressComplement" => "Dynamos",
            "phone" => $client['telefone'],
            "mobilePhone" => $client['telefone']
        ];
        $dadosAssinatura["creditCard"] = $creditcard;
        $dadosAssinatura["creditCardHolderInfo"] = $creditCardHolderInfo;


    }

    $dadosjurosmulta = ["interest" => ["value" => 1], "fine" => ["value" => 2, "type" => "PERCENTAGE"]];

    $dadosAssinatura = array_merge($dadosAssinatura, $dadosjurosmulta);

    date_default_timezone_set('America/Fortaleza');

    $hoje = date('Y-m-d H:i:s');
    $validade = date('Y-m-d H:i:s', strtotime('+1 month', strtotime($hoje)));

    $assinatura = $asaas->CriarAssinatura($dadosAssinatura);

    if (!is_array($assinatura->Erros)){
        $cobrancas = $asaas->ListarCobrancasAssinatura($assinatura->id);
        $cobrancaFinal = 0;
        foreach ($cobrancas as $cobranca){
            $cobrancaFinal = $cobranca;
        }


        $assinatura_id = saveSubscribe($assinatura, $usuario);

        if ($cobrancaFinal->status=='CONFIRMED' or $cobrancaFinal->status=='RECEIVED'){
            $status="ativo";
        } else {
            $status='aguardando ativação';
        }


        if(empty($imobiliaria)){ // USUARIO AVULSO, SEM IMOBILIARIA

            $sql = dbQuery("INSERT INTO planos_users_imobiliarias(user_id, plano_id,pagamento_id, plano_atual, data_inicio, data_fim, status, qtd_vistoria, qtd_usuario, sn_logo, valor_plano)
							values('$usuario','6','$pagamento_id','1','$hoje','$validade','$status','$qtd_plano','$qtd_usuario','$snlogo','$valor_plano')");

        }else{

            $sql = dbQuery("INSERT INTO planos_users_imobiliarias(imobiliaria_id, plano_id,pagamento_id, plano_atual, data_inicio, data_fim, status, qtd_vistoria, qtd_usuario, sn_logo, valor_plano)
							values('$imobiliaria','6','$pagamento_id','1','$hoje','$validade','$status','$qtd_plano','$qtd_usuario','$snlogo','$valor_plano')");

        }
        $plano_id=dbInsertId();

        $cobrancaFinal = 0;
        foreach ($cobrancas as $cobranca){
            $cobrancaFinal = $cobranca;
            savePayment($cobranca, $plano_id, $assinatura_id);
        }

        $code = 1;
        if(in_array($cobrancaFinal->status, ['RECEIVED', 'CONFIRMED', 'RECEIVED_IN_CASH'])){
            $code = 0;
        }
        $result = [
            "code" => $code,
            "forma" => $_POST['forma'],
            "link" => $cobrancaFinal->invoiceUrl
        ];

        if($forma == 'PIX'){
            $qrcode=$asaas->PegarQrCode($cobrancaFinal->id);
            $result['qrcode']=$qrcode;
            $result['id_cobranca']=$cobrancaFinal->id;

        }
        if($forma == 'BOLETO'){
            $linhaDigitavel=$asaas->PegarLinhaDigitavel($cobrancaFinal->id);
            $result['linhaDigitavel']=$linhaDigitavel;
            $result['id_cobranca']=$cobrancaFinal->id;
        }

        $result['assinatura_id'] = $assinatura->id;

        echo json_encode($result);

    }
    else{
        http_response_code(500);
        echo json_encode(["error" => "Erro ao gerar assinatura"]);
    }






}else{

    echo 'S';

}






?>