<?php
require('fpdf.php');
header('Access-Control-Allow-Origin: *');
session_start();

include 'includes/config.php';
include 'includes/mysql.php';
include 'includes/sessoes.php';


function datapadrao($data)
{
    if ($data) {
        return (str_pad(substr($data, 8, 2), 2, 0, STR_PAD_LEFT) . "/" . str_pad(substr($data, 5, 2), 2, 0, STR_PAD_LEFT) . "/" . substr($data, 0, 4)) . ' ' . substr($data, 11, 8);
    }
}

function pxToMm($px, $dpi = 96)
{
    return $px * 25.4 / $dpi; // 1 polegada = 25.4mm
}

$mime_to_extension = [
    'image/jpeg' => '.jpg',
    'image/png' => '.png',
    'image/gif' => '.gif',
    'image/webp' => '.webp',
    'text/plain' => '.txt',
    'application/pdf' => '.pdf',
    // Adicione mais mapeamentos conforme necessário
];

try{
    if (conectar()) {

        $vistoria_id = $_GET['vistoria'];

        $usuario = isset($_SESSION['login']['id']) ? $_SESSION['login']['id'] : null;
        if (!$usuario) {
            $_POST['usuario'] = $_GET['usuario'];
            $_POST['senha'] = $_GET['senha'];
            if (SessaoOk()) {
                $usuario = $_SESSION['login']['id'];
            }
        }
        $usuario_id_vistoria = dbfetchscalar("select user_id from vistorias where id = '$vistoria_id'");

        $paragrafo = dbfetchScalar("select valor from config where chave = 'paragrafo_laudo'");

        if ($usuario == $usuario_id_vistoria) {
            $vistoria = dbFetchArray(dbQuery("SELECT vi.*, ti.nome as imovel, tp.nome as tipo_imovel, us.nome as corretor, 
				en.logradouro, en.numero, en.complemento, en.bairro, en.cidade, en.uf, en.cep,
				im.observacoes as obs_imovel
				FROM vistorias AS vi
				left join imoveis as im on(vi.imovel_id = im.id)
				left join enderecos as en on(im.endereco_id = en.id)
				left join subtipos_imoveis as ti on(im.subtipo_imovel_id  = ti.id)
				left join tipos_imoveis as tp on(ti.tipo_imovel_id = tp.id)
				left join users as us on(vi.user_id = us.id)
				where vi.id = '$vistoria_id'"));

            if ($vistoria['status'] == 'pendente') {
                $stt = 'Em aberto';
            } else if ($vistoria['status'] == 'concluida') {
                $stt = 'Finalizada';
            }

//exit;

            header("Content-Type: text/html; charset=ISO-8859-1", true);
//Classe fpdf
            define('FPDF_FONTPATH', 'font/');
            header("Content-Type: text/html; charset=ISO-8859-1");

            class PDF extends FPDF
            {


                var $widths;
                var $aligns;

                function SetAligns($a)
                {
                    //Set the array of column alignments
                    $this->aligns = $a;
                }

                function MultiCellTable($header, $data, $widths)
                {
                    // Configuração da largura da coluna
                    $this->SetWidths($widths);
                    $this->SetFont('Arial', 'B', 12);
                    // Cabeçalho da tabela
                    foreach ($header as $col) {
                        $this->Cell(array_shift($widths), 10, iconv('UTF-8', 'windows-1252', $col), 0, 0, 'L');
                    }
                    $this->Line(10, $this->GetY(), 200, $this->GetY());
                    $this->Ln();

                    // Conteúdo da tabela
                    foreach ($data as $row) {
                        $this->Row($row);
                    }
                }

                // Definindo larguras das colunas
                function SetWidths($w)
                {
                    $this->widths = $w;
                }

                // Função para gerar uma linha da tabela com células MultiCell
                function Row($data)
                {
                    $nb = 0;

                    // Calcula o número máximo de linhas
                    for ($i = 0; $i < count($data); $i++) {
                        $nb = max($nb, $this->NbLines($this->widths[$i], $data[$i]));
                    }

                    $h = 5 * $nb;

                    // Quebra a página se necessário
                    $this->CheckPageBreak($h);
                    $this->SetFont('Arial', '', 12);
                    // Imprime as células da linha
                    for ($i = 0; $i < count($data); $i++) {
                        $w = $this->widths[$i];
                        $x = $this->GetX();
                        $y = $this->GetY();
                        //$this->Rect($x, $y, $w, $h);
                        $this->MultiCell($w, 7, iconv('UTF-8', 'windows-1252', $data[$i]), 0, 'L');

                        $this->SetXY($x + $w, $y);
                    }

                    $this->Ln($h + 3);
                }

                // Verifica a quebra de página
                function CheckPageBreak($h)
                {
                    if ($this->GetY() + $h > $this->PageBreakTrigger) {
                        $this->AddPage($this->CurOrientation);
                    }
                }

                // Calcula o número de linhas
                function NbLines($w, $txt)
                {
                    $cw = &$this->CurrentFont['cw'];
                    if ($w == 0) {
                        $w = $this->w - $this->rMargin - $this->x;
                    }
                    $wmax = ($w - 2 * $this->cMargin) * 1000 / $this->FontSize;
                    $s = str_replace("\r", '', $txt);
                    $nb = strlen($s);
                    if ($nb > 0 && $s[$nb - 1] == "\n") {
                        $nb--;
                    }
                    $sep = -1;
                    $i = 0;
                    $j = 0;
                    $l = 0;
                    $nl = 1;
                    while ($i < $nb) {
                        $c = $s[$i];
                        if ($c == "\n") {
                            $i++;
                            $sep = -1;
                            $j = $i;
                            $l = 0;
                            $nl++;
                            continue;
                        }
                        if ($c == ' ') {
                            $sep = $i;
                        }
                        $l += $cw[$c];
                        if ($l > $wmax) {
                            if ($sep == -1) {
                                if ($i == $j) {
                                    $i++;
                                }
                            } else {
                                $i = $sep + 1;
                            }
                            $sep = -1;
                            $j = $i;
                            $l = 0;
                            $nl++;
                        } else {
                            $i++;
                        }
                    }
                    return $nl;
                }


                // Cabeçalho
                function Header()
                {
                    global $vistoria, $urlbaseftp_server;

                }

                function Footer()
                {
                    // Voltar para texto preto
                    $this->SetTextColor(0, 0, 0);
                    //Position at 1.5 cm from bottom
                    $this->SetY(-15);
                    //Arial italic 8
                    $this->SetFont('Arial', 'I', 8);
                    //Page number
                    $this->Cell(0, 10, iconv('UTF-8', 'windows-1252', 'Página ' . $this->PageNo() . '/{nb}'), 0, 0, 'C');
                }


            }

// Instanciation of inherited class


            $pdf = new PDF('P', 'mm', 'A4'); //CRIA UM NOVO ARQUIVO PDF NO TAMANHO A4
            $pdf->AddPage(); // ADICIONA UMA PAGINA
            $pdf->AliasNbPages(); // SELECIONA O NUMERO TOTAL DE PAGINAS, USADO NO RODAPE

            /** @var string $urlbaseftp_server Definida em config.php */
            $pdf->Image($urlbaseftp_server . '/img/logo_padrao.png', 75, 10, 60); // Altere 'logo.png' para o caminho da sua logomarca

// Dados da empresa
            $pdf->SetFont('Arial', 'B', 12);
            $pdf->Cell(65); // Move para a direita
            $pdf->Cell(140, 5, '', 0, 1, 'L');
            $pdf->SetFont('Arial', '', 10);
            $pdf->Cell(65); // Move para a direita
            $pdf->Cell(140, 5, iconv('UTF-8', 'windows-1252', ''), 0, 1, 'L');

            $pdf->Cell(65); // Move para a direita
            $pdf->Cell(140, 5, iconv('UTF-8', 'windows-1252', ''), 0, 1, 'L');
            $pdf->Cell(65); // Move para a direita
            $pdf->Cell(140, 5, iconv('UTF-8', 'windows-1252', ''), 0, 1, 'L');

            $pdf->Ln(2); // Espaço para o título

// Estilo da fonte
            $pdf->SetFont('Arial', 'B', 16);
// Título centralizado com fundo cinza

            $pdf->Cell(0, 0, iconv('UTF-8', 'windows-1252', 'LAUDO DE VISTORIA IMOBILIÁRIA'), 0, 1, 'C');

            $pdf->Ln(10); // Espaço para o título

            $pdf->SetFont('Arial', 'B', 14);
            $pdf->multiCell(130, 7, iconv('UTF-8', 'windows-1252', 'Vistoria #' . $vistoria['id'] . ' ('. $vistoria['tipo'] .')' . ' • ' . $stt));
            $pdf->SetFont('Arial', '', 12);

            $pdf->multiCell(130, 7, iconv('UTF-8', 'windows-1252', 'Realizada em ' . datapadrao($vistoria['data_vistoria'])));

            $pdf->SetFont('Arial', 'B', 12);
            $pdf->Cell(14, 7, iconv('UTF-8', 'windows-1252', 'Título:'), 0, 0, 'L');
            $pdf->SetFont('Arial', '', 12);
            $pdf->multiCell(130, 7, iconv('UTF-8', 'windows-1252', $vistoria['titulo']));

            $pdf->SetFont('Arial', 'B', 12);
            $pdf->Cell(20, 7, iconv('UTF-8', 'windows-1252', 'Locador:'), 0, 0, 'L');
            $pdf->SetFont('Arial', '', 12);
            $pdf->multiCell(130, 7, iconv('UTF-8', 'windows-1252', $vistoria['locador']));

            $pdf->SetFont('Arial', 'B', 12);
            $pdf->Cell(22, 7, iconv('UTF-8', 'windows-1252', 'Locatário:'), 0, 0, 'L');
            $pdf->SetFont('Arial', '', 12);
            $pdf->multiCell(130, 7, iconv('UTF-8', 'windows-1252', $vistoria['locatario']));


            $pdf->SetFont('Arial', 'B', 12);
            $pdf->Cell(20, 7, iconv('UTF-8', 'windows-1252', 'Corretor:'), 0, 0, 'L');
            $pdf->SetFont('Arial', '', 12);
            $pdf->multiCell(130, 7, iconv('UTF-8', 'windows-1252', $vistoria['corretor']));

            $pdf->SetFont('Arial', 'B', 12);
            $pdf->Cell(37, 7, iconv('UTF-8', 'windows-1252', 'Dados do imóvel:'), 0, 0, 'L');
            $pdf->SetFont('Arial', '', 12);
            $pdf->multiCell(130, 7, iconv('UTF-8', 'windows-1252', $vistoria['tipo_imovel'] . ' - ' . $vistoria['imovel']));

            $pdf->SetFont('Arial', 'B', 12);
            $pdf->Cell(23, 7, iconv('UTF-8', 'windows-1252', 'Endereço:'), 0, 0, 'L');
            $pdf->SetFont('Arial', '', 12);
            $pdf->multiCell(130, 7, iconv('UTF-8', 'windows-1252', $vistoria['logradouro'] . ', ' . $vistoria['numero'] . ' - ' . $vistoria['bairro'] . ', ' . $vistoria['cidade'] . '/' . $vistoria['uf'] . ' - ' . $vistoria['cep']));

            if (!empty($vistoria['obs_imovel'])) {

                $pdf->SetFont('Arial', 'B', 12);
                $pdf->Cell(35, 7, iconv('UTF-8', 'windows-1252', 'Sobre o imóvel:'), 0, 0, 'L');
                $pdf->SetFont('Arial', '', 12);
                $pdf->multiCell(130, 7, iconv('UTF-8', 'windows-1252', $vistoria['obs_imovel']));

            }

            if (!empty($vistoria['capa'])) {

                $y = $pdf->gety();
                $extensao_banco = pathinfo($vistoria['capa'], PATHINFO_EXTENSION);

                /** @var string $urlbaseftp_capa Definida em config.php */
                list($largura, $altura) = getimagesize($urlbaseftp_capa . $vistoria['capa']);

                $finfo = finfo_open(FILEINFO_MIME_TYPE); // Obter tipo MIME
                $mime_type = finfo_file($finfo, $urlbaseftp_capa . $vistoria['capa']);
                finfo_close($finfo);

                $arquivo = strstr($vistoria['capa'], '.', true); // Retorna "exemplo"

                $extensao = isset($mime_to_extension[$mime_type]) ? $mime_to_extension[$mime_type] : null;

                if ($extensao_banco !== $extensao) {

                    $arquivo_antigo = $urlbaseftp_capa . $vistoria['capa'];
                    $info = pathinfo($arquivo_antigo);
                    $novo_arquivo = $info['dirname'] . '/' . $info['filename'] . $extensao;

                    $nova_capa = '/' . $info['filename'] . $extensao;

                    $sql_alterar_capa = dbQuery("UPDATE vistorias SET capa = '$nova_capa' WHERE id = '$vistoria_id'");

                    if ($sql_alterar_capa) {

                        rename($arquivo_antigo, $novo_arquivo);

                        list($largura, $altura) = getimagesize($novo_arquivo);
                    }

                }

                list($largura, $altura) = getimagesize($urlbaseftp_capa . $arquivo . $extensao);
                $proporcao = max($altura / $largura, $proporcao);

                if ($largura > 180) {

                    $largura = 180;
                }
                // echo $imgHeight;
                $pdf->Image($urlbaseftp_capa . $arquivo . $extensao, 12, $y, $largura);


                $pdf->ln($largura / 2 + 10);
            } else {

                $pdf->ln(10);
            }

            $pdf->ln(2);

            $pdf->SetFont('Courier', '', 9);
            $pdf->multiCell(180, 5, iconv('UTF-8', 'windows-1252', $paragrafo));

//$y=$pdf->gety();
//$pdf->Image($urlbaseftp_server.'/img/logo_padrao.png', 80, $y, 50);

            $pdf->SetFont('Arial', '', 14);
// Título centralizado com fundo cinza
            $pdf->ln(20);
            $pdf->Cell(0, 0, iconv('UTF-8', 'windows-1252', 'ESTADO DO IMÓVEL'), 0, 1, 'C');

/////////////////////// LEGENDA CORES /////////////////////////

// Centraliza os textos na página
            $pdf->Cell(0, 10, '', 0, 1, 'C');

// Adiciona os círculos coloridos com as legendas
            $legendas = [
                ['Novo', 33, 150, 243],  // Azul
                ['Bom', 139, 195, 74],   // Verde
                ['Médio', 255, 193, 7],  // Amarelo
                ['Ruim', 244, 67, 54]    // Vermelho
            ];

// Posição inicial
            $x = 40;
            $y = $pdf->GetY();

// Exibir os elementos
            foreach ($legendas as $legenda) {
                list($texto, $r, $g, $b) = $legenda;

                // Define a cor do ponto
                $pdf->SetTextColor($r, $g, $b);
                $pdf->SetXY($x, $y);
                $pdf->SetFont('Arial', 'B', 32);
                $pdf->Cell(5, 10, iconv('UTF-8', 'windows-1252', '•'), 0, 0, 'C'); // Ponto colorido

                // Define a cor do texto
                $pdf->SetTextColor(0, 0, 0);
                $pdf->SetXY($x + 8, $y);
                $pdf->SetFont('Arial', '', 14);
                $pdf->Cell(20, 10, iconv('UTF-8', 'windows-1252', $texto), 0, 0, 'L');

                $x += 40; // Ajusta a posição para a próxima legenda
            }

// Adiciona um divisor abaixo do conteúdo
            $pdf->Ln(10);
            $pdf->SetDrawColor(233, 236, 239);
            $pdf->SetLineWidth(1);
            $pdf->Line(10, $pdf->GetY(), 200, $pdf->GetY());

/////////////////////// LEGENDA CORES /////////////////////////


            $q2 = dbquery("select av.id as id_amb_vist, am.id, am.nome from ambientes_vistorias as av 
							left join ambientes as am on(av.ambiente_id = am.id)
							where av.vistoria_id = '$vistoria_id' AND av.deleted_at IS NULL order by av.ordem ");


            $pdf->ln(8);
            while ($r2 = dbfetcharray($q2)) {

                // Voltar para texto preto
                $pdf->SetTextColor(0, 0, 0);
                $ambiente_id = $r2['id'];
                $ambiente_vistoria_id = $r2['id_amb_vist'];

                // Definir cor do ponto e imprimir
                $pdf->SetTextColor(139, 195, 74);
                $pdf->SetFont('Arial', 'B', 16);
                $pdf->Cell(6, 7, iconv('UTF-8', 'windows-1252', '|'), 0, 0, 'L'); // Exibir ponto colorido

                // Voltar para texto preto
                $pdf->SetTextColor(0, 0, 0);

                // Nome maior e negrito
                $pdf->SetFont('Arial', 'B', 18);
                $pdf->Cell(130, 7, iconv('UTF-8', 'windows-1252', $r2['nome']), 0, 0, 'L');
                $pdf->ln(5);

                //$pdf->SetFont('Arial','B',14);
                //$pdf->multiCell(130, 7,  iconv('UTF-8', 'windows-1252', $r2['nome']));
                // Voltar para texto preto
                $pdf->SetTextColor(0, 0, 0);

                $q3 = dbquery($d = "select aiv.estado, aiv.observacoes, it.nome from ambientes_itens_vistorias as aiv 
								left join itens as it on(aiv.item_id = it.id)
                                left join ambientes_vistorias as av on(aiv.ambiente_vistoria_id = av.id)
								where aiv.vistoria_id = '$vistoria_id' and aiv.ambiente_id = '$ambiente_id' and aiv.ambiente_vistoria_id = '$ambiente_vistoria_id' AND av.deleted_at IS NULL");
                $pdf->ln(5);
                while ($r3 = dbfetcharray($q3)) {

                    $y = $pdf->gety();

                    if ($y > 270) {

                        $pdf->AddPage(); // ADICIONA UMA PAGINA
                        $y = $pdf->gety();
                    }
                    /*
                    $pdf->Image($urlbaseftp_server.'/img/check.png', 11, $y,4,4);

                    $pdf->Cell(5, 4,  '', 0, 0, 'L');
                    $pdf->SetFont('Arial','',12);
                    $pdf->multiCell(130, 4,  iconv('UTF-8', 'windows-1252', $r3['nome']. ' - '. $r3['observacoes'] . ' ('.$r3['estado'].')'));
                    */

                    $cores = [
                        'Novo' => [33, 150, 243],  // Azul (#2196f3)
                        'Ruim' => [244, 67, 54],   // Vermelho (#f44336)
                        'Médio' => [255, 193, 7],   // Amarelo (#ffc107)
                        'Bom' => [139, 195, 74]   // Verde (#8bc34a)
                    ];

                    $cor = isset($cores[$r3['estado']]) ? $cores[$r3['estado']] : [0, 0, 0]; // Preto como padrão

                    // Inserir imagem do check
                    //$pdf->Image($urlbaseftp_server.'/img/check.png', 11, $y, 4, 4);

                    // Ajustar a posição após a imagem
                    $pdf->SetXY(12, $y);

                    // Definir cor do ponto e imprimir
                    $pdf->SetTextColor($cor[0], $cor[1], $cor[2]);
                    $pdf->SetFont('Arial', 'B', 30);
                    $pdf->Cell(6, 4, iconv('UTF-8', 'windows-1252', '•'), 0, 0, 'L'); // Exibir ponto colorido

                    // Voltar para texto preto
                    $pdf->SetTextColor(0, 0, 0);

                    // Nome maior e negrito
                    $pdf->SetFont('Courier', 'B', 14);
                    $pdf->Cell($pdf->GetStringWidth(iconv('UTF-8', 'windows-1252', $r3['nome'])) + 2, 6, iconv('UTF-8', 'windows-1252', $r3['nome']), 0, 0, 'L');

                    // Observações na mesma linha, fonte menor
                    $pdf->SetFont('Courier', '', 12);
                    $pdf->SetAutoPageBreak(true, 10); // para evitar que o texto ultrapasse a página
                    $texto = mb_convert_encoding($r3['observacoes'], 'windows-1252', 'UTF-8');
                    $texto = wordwrap($texto, 100, "\n", true);

                    $pdf->MultiCell(0, 6, " - " . $texto, 0, 'L');


                    $pdf->ln(3);
                }

                $q4 = dbquery($d = "select avf.id, avf.ambientes_vistoria_id, avf.caminho_foto from ambientes_vistorias_fotos as avf left join ambientes_vistorias as av 
                                               on av.id = avf.ambientes_vistoria_id
								where avf.ambientes_vistoria_id = '$ambiente_vistoria_id' AND av.deleted_at IS NULL");

                $col = 4;
                $y = $pdf->gety();
                $x = 15;
                $contadorFinal = 0;
                $contador = 0;
                $proporcao = 0;
                while ($r4 = dbfetcharray($q4)) {

                    //////////////////////

                    $y = $pdf->gety();
                    $extensao_banco = pathinfo($r4['caminho_foto'], PATHINFO_EXTENSION);

                    $ambientes_vistorias_fotos_id = $r4['id'];
                    //echo $r4['caminho_foto'];
                    list($largura, $altura) = getimagesize($urlbaseftp_server . $r4['caminho_foto']);

                    $finfo = finfo_open(FILEINFO_MIME_TYPE); // Obter tipo MIME
                    $mime_type = finfo_file($finfo, $urlbaseftp_server . $r4['caminho_foto']);
                    finfo_close($finfo);

                    $arquivo = strstr($r4['caminho_foto'], '.', true); // Retorna "exemplo"

                    $extensao = isset($mime_to_extension[$mime_type]) ? $mime_to_extension[$mime_type] : null;

                    if ($extensao_banco !== $extensao) {

                        $arquivo_antigo = $urlbaseftp_server . $r4['caminho_foto'];
                        $info = pathinfo($arquivo_antigo);
                        $novo_arquivo = $info['dirname'] . '/' . $info['filename'] . $extensao;

                        $nova_capa = '/api/uploads/galeria_vistoria/' . $r4['ambientes_vistoria_id'] . '/' . $info['filename'] . $extensao;

                        $sql_alterar_capa = dbQuery("UPDATE ambientes_vistorias_fotos SET caminho_foto = '$nova_capa' WHERE id = '$ambientes_vistorias_fotos_id'");

                        if ($sql_alterar_capa) {

                            rename($arquivo_antigo, $novo_arquivo);

                            list($largura, $altura) = getimagesize($novo_arquivo);
                        }

                    }

                    list($largura, $altura) = getimagesize($urlbaseftp_server . $arquivo . $extensao);
                    $proporcao = max($altura / $largura, $proporcao);


                    if ($y + ($proporcao * 50) > 270) {

                        $pdf->AddPage(); // ADICIONA UMA PAGINA
                        $y = $pdf->gety();


                    }

                    // echo $imgHeight;
                    $pdf->Image($urlbaseftp_server . $arquivo . $extensao, $x, $y, 50);
                    $x = $x + 52;

                    $contador++;
                    $contadorFinal++;
                    if ($contador >= 3) {
                        $pdf->ln($proporcao * 50 + 5);
                        $contador = 0;
                        $x = 15;

                    }


                    ///////////////////////

                }
                if (is_float($contadorFinal / 3)) {
                    $pdf->ln($proporcao * 50 + 5);

                }


                $pdf->ln(2);
            }


            $pdf->SetFont('Arial', '', 14);
// Título centralizado com fundo cinza
            $pdf->ln(20);
            $pdf->Cell(0, 0, iconv('UTF-8', 'windows-1252', 'CONSIDERAÇÕES FINAIS'), 0, 1, 'C');

            if (!empty($vistoria['observacoes'])) {

                $pdf->ln(10);
                $pdf->SetFont('Arial', 'B', 12);
                $pdf->Cell(30, 7, iconv('UTF-8', 'windows-1252', 'Observações:'), 0, 0, 'L');
                $pdf->SetFont('Arial', '', 12);
                $pdf->multiCell(130, 7, iconv('UTF-8', 'windows-1252', $vistoria['observacoes']));

            }

            $pdf->ln(10);
            $pdf->SetFont('Arial', '', 12);
            $pdf->multiCell(180, 7, iconv('UTF-8', 'windows-1252', $vistoria['conclusao']));

            
            $pdf->Output('laudo-vistoria-' . $vistoria_id . '.pdf', 'I');
        } else {

            echo "Não é possível visualizar laudo!";

        }
    }

} catch (Exception $e) {
    echo "Erro: " . $e->getMessage();
}



?>

