<?
 
class mrpay {

    private $ApiKey;
    private $ApiId;
    private $UrlBase;
    private $UrlSandbox="https://apisandbox.ecommerce.mrpay.com.br";
    private $UrlProducao="https://www.asaas.com/api/v3/";
	private $Comando;
	private $Limit=100;
	private $Erros=array();

    function __construct($apikey,$apiid,$ambiente='sandbox') {
		$this->ApiKey=$apikey;
		$this->ApiId=$apiid;
		if ($ambiente == 'producao'){
			$this->UrlBase=$this->UrlProducao;
		} elseif ($ambiente == 'sandbox'){
			$this->UrlBase=$this->UrlSandbox;
		} else {
			$this->UrlBase=$this->UrlSandbox;
		}
	}

	function CriarCobranca($dados) { 
		$this->Comando='payments'; 
		$dados['payment_amount']=(string)$this->CorrigirValor($dados['payment_amount']);
		if (is_array($dados['card'])){
		$dados['authorizer_id']=(string)$this->PegarAutorizadora($dados['card']['number']);
		} else {
		$dados['authorizer_id']=(string)440;
		}
		$retorno=json_decode($this->webhook($dados,'POST'));
		//print_r($retorno);
		if (is_object($retorno)){
			if (is_array($retorno->errors)){
				$ret = new stdClass();
				foreach($retorno->errors as $v){
					$ret->Erros[]=$v->description;
				}
				$retorno=$ret;
			}
		}
		return $retorno;
	}
	
	function CriarAssinatura($dados,$dados2) { 
		$this->Comando='/v1/transactions';
		$dados['payment_amount']=(string)$this->CorrigirValor($dados['payment_amount']);
		//$dados['authorizer_id']=(string)$this->PegarAutorizadora($dados['card']['number']);
		//print_r($dados);
		$retorno=json_decode($this->webhook($dados,'POST'));
		//print_r($retorno);
		if (is_object($retorno)){
			if ($retorno->code!=0){
				return $retorno;
			}
		}
		$nit=$retorno->payment->nit;
		//print_r($retorno); 
		//echo $sid;
		$authorizer_id=(string)$this->PegarAutorizadora($dados2['card']['number']);
		$dadosconfirm=['authorizer_id'=>$authorizer_id,"card"=>$dados2['card']];
		//print_r($dadosconfirm);
		$this->Comando="/v1/payments/$nit";
		$retorno=json_decode($this->webhook($dadosconfirm,'POST'));  
		return $retorno;
	}
	function CapturarCartao($dados) { 
		$authorizer_id=(string)$this->PegarAutorizadora($dados['card']['number']);
		$dados['authorizer_id']=$authorizer_id;
		
		$this->Comando='/v1/cards';
		$retorno=json_decode($this->webhook($dados,'POST'));
		return $retorno;
	}	
	
	function CancelarAssinatura($nit) { 
		$this->Comando='cancellations/'.$nit;
		$dados['payment_amount']=(string)$this->CorrigirValor($dados['payment_amount']);
		$dados['authorizer_id']=(string)$this->PegarAutorizadora($dados['card']['number']);
		$retorno=json_decode($this->webhook($dados,'POST'));
		//print_r($retorno);
		if (is_object($retorno)){
			if (is_array($retorno->errors)){
				$ret = new stdClass();
				foreach($retorno->errors as $v){
					$ret->Erros[]=$v->description;
				}
				$retorno=$ret;
			}
		} 
		return $retorno;
	}
	function CorrigirValor($valor){
		return intval($valor*100);
	}

	function PegarAutorizadora($numeroCartao) {
		if ($numeroCartao=='PIX'){
			return 440; // PIX
		}
		// Remove espaços e caracteres não numéricos
		$numeroCartao = preg_replace('/[^0-9]/', '', $numeroCartao);
		
		// Verifica se o número tem pelo menos os dígitos iniciais necessários
		if (strlen($numeroCartao) < 2) {
			return "Número inválido";
		}

		// Obtém os primeiros dígitos para verificação
		$primeiros2 = substr($numeroCartao, 0, 2);
		$primeiro1 = substr($numeroCartao, 0, 1);
		$primeiros4 = strlen($numeroCartao) >= 4 ? substr($numeroCartao, 0, 4) : '';
		$primeiros6 = strlen($numeroCartao) >= 6 ? substr($numeroCartao, 0, 6) : '';

		// Verificação das bandeiras
		if ($primeiro1 == '4') {
			return 1; //Visa
		}
		elseif ($primeiros2 >= '51' && $primeiros2 <= '55') {
			return 2; // Mastercard
		}
		elseif ($primeiros2 == '34' || $primeiros2 == '37') {
			return 3; //"American Express"
		}
		elseif ($primeiros2 == '65' || $primeiros4 == '6011') {
			return false; //"Discover";
		}
		elseif ($primeiros2 == '35') {
			return false; //"JCB";
		}
		elseif ($primeiros2 == '30' || $primeiros2 == '36' || $primeiros2 == '38') {
			return false; //"Diners Club";
		}
		elseif ($primeiros2 == '63' || $primeiros2 == '67') {
			return false; //"Maestro";
		}
		elseif (in_array($primeiros6, [
			'636368', '438935', '504175', '451416', '509000', 
			'506707', '506708', '506709', '506715', '506716'
		])) {
			return 41; //Elo
		}
		elseif ($primeiros6 == '606282' || $primeiros4 == '3841') {
			return 5; //Hiper
		} else {
			return false;// "Bandeira desconhecida";
		}
	}

	/* Exemplos de uso
	$cartoesTeste = [
		"4539 1488 0343 6467",  // Visa
		"5200 8282 8787 1234",  // Mastercard
		"3782 822463 10005",    // American Express
		"6011 0009 9013 9424",  // Discover
		"6363 6812 3456 7890",  // Elo
		"6062 8212 3456 7890"   // Hiper
	];*/


	function webhook($dados,$method){
		//echo json_encode($dados);
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $this->UrlBase.$this->Comando);
		//echo $this->UrlBase.$this->Comando;
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
		curl_setopt($ch, CURLOPT_HEADER, FALSE);
		IF ($method=='POST'){
			curl_setopt($ch, CURLOPT_POST, TRUE);
			curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($dados));
		} else if ($method=='DELETE'){
			curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "DELETE");
		} else if ($method=='PUT'){
			curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($dados));
			curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
		}  
		curl_setopt($ch, CURLOPT_HTTPHEADER, array(
			"Content-Type: application/json",
			"mrpay-api-id: ".$this->ApiId,
			"mrpay-api-key: ".$this->ApiKey
		));
		$response = curl_exec($ch);
		//print_r($response);
		curl_close($ch);
		return $response;
		
	}

}
	
	
	
	