<?php
include "includes/config.php";
include "includes/mysql.php";
include "includes/sessoes.php";
session_start();

function datapadrao($data){ 
	if($data){
		return(str_pad(substr($data,8,2),2,0,STR_PAD_LEFT)."/".str_pad(substr($data,5,2),2,0,STR_PAD_LEFT)."/".substr($data,0,4)) . ' '. substr($data,11,8);
	}
}

if(SessaoOk()){
	
	$q_mensais = dbQuery("SELECT * FROM planos WHERE deleted_at IS NULL AND valor > 0 AND ciclo = 'mes' ORDER BY valor ASC");
	$q_anuais  = dbQuery("SELECT * FROM planos WHERE deleted_at IS NULL AND valor > 0 AND ciclo = 'ano' ORDER BY valor ASC");
	
	$valor_personalizado  = dbfetchScalar("SELECT valor FROM config WHERE chave = 'valor_vistoria_empresa'");
	$valor_formatado = number_format($valor_personalizado, 2, ',', '.');
	
	$valor_usuario_personalizado = dbfetchScalar("SELECT valor FROM config WHERE chave = 'valor_usuario_empresa'");
	$valor_usuario_formatado = number_format($valor_usuario_personalizado, 2, ',', '.');
	$qtd_usuario = dbfetchScalar("SELECT valor FROM config WHERE chave = 'qtd_usuario_empresa'");
	
	$valor_snlogo  = dbfetchScalar("SELECT valor FROM config WHERE chave = 'valor_snlogo_plano'");
	 
	$mensais = []; 
	$anuais = [];
	$personalizado[] = [
		'valor' => number_format($valor_personalizado, 2, '.', ''), // Formato decimal com ponto
		'valor_format' => $valor_formatado,
		'valor_usuario' => number_format($valor_usuario_personalizado, 2, '.', ''), // Formato decimal com ponto
		'valor_usuario_format' => $valor_usuario_formatado,
		'qtd_usuario' => $qtd_usuario,
		'snlogo' => $valor_snlogo
	];

	while ($r = dbfetcharray($q_mensais)) {
		$r['valor'] = number_format($r['valor'], 2, ',', '.');
		$mensais[] = $r;
	}

	while ($r = dbfetcharray($q_anuais)) {
		$r['valor'] = number_format($r['valor'], 2, ',', '.');
		$anuais[] = $r;
	}

	echo json_encode([
		'mensais' => $mensais,
		'anuais'  => $anuais,
		'personalizado'  => $personalizado
	]);
	
}






?>