<?php
include "includes/config.php";
include "includes/mysql.php";
include "includes/sessoes.php";
session_start();

function datapadrao($data){
    if($data){
        return(str_pad(substr($data,8,2),2,0,STR_PAD_LEFT)."/".str_pad(substr($data,5,2),2,0,STR_PAD_LEFT)."/".substr($data,0,4)) . ' '. substr($data,11,8);
    }
}

if(SessaoOk()){

    $usuario = $_SESSION['login']['id'];

    $q= dbQuery("
        SELECT 
            vi.*, 
			en.logradouro, en.numero, en.complemento, en.bairro, en.cidade, en.uf, en.cep,
			ti.nome AS descricao,
			processos_de_assinatura.document_status
        FROM vistorias AS vi 
        LEFT JOIN imoveis AS im ON vi.imovel_id = im.id
        LEFT JOIN enderecos AS en ON im.endereco_id = en.id
        LEFT JOIN subtipos_imoveis AS ti ON im.subtipo_imovel_id  = ti.id
        LEFT JOIN processos_de_assinatura ON vi.id = processos_de_assinatura.vistoria_id
        WHERE vi.status = 'concluida' AND vi.user_id = '$usuario' 
        ORDER BY data_vistoria DESC
    ");

    $resposta = [];

    while ($r = dbfetcharray($q)) {

        if ($r['capa']) {
            $r['foto_capa'] = $urlbase_capa . $r['capa'];
        } else {
            $r['foto_capa'] = 'img/checklist_casa.png';
        }

        $r['statusDaAssinaturaAtual'] = null;
        $statusDaAssinatura = [
            'canceled' => 'Assinatura Cancelada',
            'draft' => 'Aguardando início da Assinatura',
            'running' => 'Assinatura em Andamento',
            'closed' => 'Assinatura Finalizada',
        ];
        if ($r['document_status']) {
            $r['statusDaAssinaturaAtual'] = [
                'id' => $r['document_status'],
                'titulo' => $statusDaAssinatura[$r['document_status']],
            ];
        }

        $r['data_vistoria'] = datapadrao($r['data_vistoria']);

        $resposta[] = $r;
    }
    echo json_encode($resposta);
}
