<?php

header('Content-Type: application/json');

include "../includes/config.php";
include "../includes/mysql.php";
include "../includes/sessoes.php";
include "../includes/clicksign.php";
session_start();

if (!SessaoOk()) {
    http_response_code(401);
    echo json_encode([
        'success' => false,
        'message' => 'Você precisa se autenticar',
    ]);
    exit();
}

$processoDeAssinaturaId = isset($_POST['processoDeAssinaturaId']) ? $_POST['processoDeAssinaturaId'] : null;
if (!$processoDeAssinaturaId) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => 'O ID do processo de assinatura é obrigatório',
    ]);
    exit();
}

$processoDeAssinatura = dbFetchArray(dbQuery("
    SELECT *
    FROM processos_de_assinatura
    WHERE id = $processoDeAssinaturaId
"));
if (!$processoDeAssinatura) {
    http_response_code(404);
    echo json_encode([
        'success' => false,
        'message' => 'Não existe processo de assinatura para o ID fornecido',
    ]);
    exit();
}

if ($processoDeAssinatura["document_status"] === 'draft') {
    http_response_code(422);
    echo json_encode([
        'success' => false,
        'message' => 'O processo não pôde ser cancelado pois não foi iniciado',
    ]);
    exit();
} else if ($processoDeAssinatura["document_status"] === 'canceled') {
    http_response_code(422);
    echo json_encode([
        'success' => false,
        'message' => 'O processo já foi cancelado',
    ]);
    exit();
} else if ($processoDeAssinatura["document_status"] === 'closed') {
    http_response_code(422);
    echo json_encode([
        'success' => false,
        'message' => 'O processo não pôde ser cancelado pois já foi finalizado',
    ]);
    exit();
}

try {
    $clicksign = new Clicksign();
    $canceled = $clicksign->cancelDocument(
        $processoDeAssinatura['envelope_id'],
        $processoDeAssinatura['document_id']
    );
    if ($canceled === null) {
        // Documento não cancelado
        throw new Exception("Código de erro: INT_CS_PDA_D01");
    }
    echo json_encode([
        'success' => true,
        'message' => 'Processo de Assinatura cancelado com sucesso',
    ]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage(),
    ]);
}