<?php

header('Content-Type: application/json');

include "../includes/config.php";
include "../includes/mysql.php";
include "../includes/sessoes.php";
include "../includes/clicksign.php";
session_start();

/**
 * Retorna o tipo do signatário em formato de título
 *
 * @param string $data
 * @return string
 */
function format_tipo_do_signatario($data)
{
    return [
        'vistoriador' => 'Vistoriador',
        'locatario' => 'Locatário',
        'locador' => 'Locador',
    ][$data];
}

/**
 * Retorna o signatário formatado para JSON
 *
 * @param array $row
 * @return array
 */
function format_signatario(array $row)
{
    return array_merge($row, [
        'assinou' => boolval($row['assinou']),
        'tipo' => [
            'titulo' => format_tipo_do_signatario($row['tipo']),
            'id' => $row['tipo'],
        ],
    ]);
}

/**
 * Retorna o status do processo em formato de título
 *
 * @param string $data
 * @return string
 */
function format_status_do_processo($data)
{
    return [
        'canceled' => 'Cancelado',
        'running' => 'Vigente',
        'closed' => 'Finalizado',
    ][$data];
}

/**
 * Retorna o processo formatado para JSON
 *
 * @param array $row
 * @return array
 */
function format_processo_de_assinatura(array $row)
{
    return array_merge($row, [
        'id' => intval($row['id']),
        'status' => [
            'titulo' => format_status_do_processo($row['status']),
            'id' => $row['status'],
        ]
    ]);
}

if (!SessaoOk()) {
    http_response_code(401);
    echo json_encode([
        'success' => false,
        'message' => 'Você precisa se autenticar',
    ]);
    exit();
}

$processoDeAssinaturaId = isset($_POST['processoDeAssinaturaId']) ? (int) $_POST['processoDeAssinaturaId'] : null;
if (!$processoDeAssinaturaId) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => 'O ID do processo de assinatura é obrigatório',
    ]);
    exit();
}

$processoDeAssinatura = dbFetchArray(dbQuery("
    SELECT 
        id,
        document_status AS status,
        document_original_file_link AS arquivoOriginal,
        document_signed_file_link AS arquivoAssinado
    FROM processos_de_assinatura
    WHERE id = $processoDeAssinaturaId
"));
if (!$processoDeAssinatura) {
    http_response_code(404);
    echo json_encode([
        'success' => false,
        'message' => 'Não existe processo de assinatura para o ID fornecido',
    ]);
    exit();
}
$signatariosDoProcesso = dbQuery("
    SELECT
        tipo,
        nome,
        email,
        has_signed AS assinou,
        sign_url AS linkDeAssinatura
    FROM signatarios_dos_processos
    WHERE processo_de_assinatura_id = {$processoDeAssinatura['id']}
");
$processoDeAssinatura['signatarios'] = [];
while ($signatarioDoProcesso = dbFetchArray($signatariosDoProcesso)) {
    $processoDeAssinatura['signatarios'][] = format_signatario($signatarioDoProcesso);
}

http_response_code(200);
echo json_encode([
    'success' => true,
    'message' => 'Processo de Assinatura encontrado com sucesso',
    'processoDeAssinatura' => format_processo_de_assinatura($processoDeAssinatura),
]);