<?php
include "includes/config.php";
include "includes/mysql.php";
include "includes/sessoes.php";

session_start();

/**
 * @param array{id: string}[] $fotos
 * @return Exception|null Exception em caso de erros, ou null em sucesso (ausência de erros)
 */
function apagarFotos(array $fotos)
{
    if (empty($fotos)) {
        return null;
    }
    $ids = array_map(function (array $foto) {
        $id = preg_replace('/[^0-9]/', '', $foto['id']);
        return (int) $id;
    }, $fotos);
    $values = implode(", ", $ids);

    $resultados = dbQuery("
        SELECT caminho_foto 
        FROM ambientes_vistorias_fotos 
        WHERE id IN ($values)
    ");
    foreach ($resultados as $resultado) {
        /**
         * @var string $filename "/.../server" + "/api/uploads/galeria_vistoria/.../*.jpg"
         */
        $filename = __DIR__ . $resultado['caminho_foto'];
        if (is_file($filename)) {
            unlink($filename);
        }
    }
    dbQuery("
        DELETE FROM ambientes_vistorias_fotos 
        WHERE id IN ($values)
    ");
    return null;
}


if (SessaoOk()) {

    date_default_timezone_set('America/Belem');

    $usuario = $_SESSION['login']['id'];
    $fotos = isset($_POST['apagarFotos']) ? $_POST['apagarFotos'] : [];

    if ($fotos) {
        apagarFotos($fotos);
    }

    $codvistoria = $_POST['codvistoria'];
    $ambiente_vistoria_id = $_POST['codambiente'];

//$ambiente_vistoria_id = dbfetchScalar("select id from ambientes_vistorias where vistoria_id = '$codvistoria' and ambiente_id = '$codambiente'");	
    list($codambiente) = dbfetchList("select ambiente_id from ambientes_vistorias where id = '$ambiente_vistoria_id'");

    $items = $_POST['items'];

    $sql = dbQuery($c = "delete from ambientes_itens_vistorias where ambiente_vistoria_id = '$ambiente_vistoria_id'");

    if (!empty($items)) {

        foreach ($items as &$value) {

            $item_id = $value['id'];
            $estado = $value['estado'];
            $observacoes = $value['observacoes'];

            $sql = dbQuery($c = "insert into ambientes_itens_vistorias(ambiente_vistoria_id,vistoria_id,ambiente_id,item_id,estado,observacoes) 
							values('$ambiente_vistoria_id','$codvistoria','$codambiente','$item_id','$estado','$observacoes')");

        }
    }

    if ($sql) {

        require_once('api/FilePond.class.php');

        // Load our configuration for this server
        require_once('api/config.php');
        FilePond\catch_server_exceptions();
        FilePond\route_form_post(ENTRY_FIELD, [
            'FILE_OBJECTS' => 'handle_file_post',
            'BASE64_ENCODED_FILE_OBJECTS' => 'handle_base64_encoded_file_post',
            'TRANSFER_IDS' => 'handle_transfer_ids_post'
        ]);

        echo 1;
    } else {
        echo 2;
    }


} else {

    echo 3;

}


function handle_file_post($files)
{

    // This is a very basic implementation of a classic PHP upload function, please properly
    // validate all submitted files before saving to disk or database, more information here
    // http://php.net/manual/en/features.file-upload.php
    //print_r($files);
    foreach ($files as $file) {
        FilePond\move_file($file, UPLOAD_DIR);
    }
}

function handle_base64_encoded_file_post($files)
{
    //    print_r($files);
    foreach ($files as $file) {

        // Suppress error messages, we'll assume these file objects are valid
        /* Expected format:
        {
            "id": "iuhv2cpsu",
            "name": "picture.jpg",
            "type": "image/jpeg",
            "size": 20636,
            "metadata" : {...}
            "data": "/9j/4AAQSkZJRgABAQEASABIAA..."
        }
        */
        $file = @json_decode($file);

        // Skip files that failed to decode
        if (!is_object($file)) continue;

        // write file to disk
        FilePond\write_file(
            UPLOAD_DIR,
            base64_decode($file->data),
            FilePond\sanitize_filename($file->name)
        );
    }

}

function handle_transfer_ids_post($ids)
{

    global $ambiente_vistoria_id;
    $selfie = $_POST['selfie'];

    //echo UPLOAD_DIR."/".$codarea;
    if (!is_dir(UPLOAD_DIR . "/galeria_vistoria/" . $ambiente_vistoria_id)) mkdir(UPLOAD_DIR . "/galeria_vistoria/" . $ambiente_vistoria_id, 0755);

    foreach ($ids as $id) {

        // create transfer wrapper around upload
        $transfer = FilePond\get_transfer(TRANSFER_DIR, $id);

        // transfer not found
        if (!$transfer) continue;

        // move files
        $files = $transfer->getFiles(defined('TRANSFER_PROCESSOR') ? TRANSFER_PROCESSOR : null);

        if ($files != null) {


            foreach ($files as $file) {

                if ($selfie) {
                    foreach ($selfie as $k => $a) {
                        if ($a == $id) {

                            $caminho_selfie = "/api/uploads/galeria_vistoria/$ambiente_vistoria_id/" . $file['name'];

                            dbQuery("insert into ambientes_vistorias_fotos(ambientes_vistoria_id,caminho_foto) values('$ambiente_vistoria_id','$caminho_selfie')");
                            FilePond\move_file($file, UPLOAD_DIR . "/galeria_vistoria/" . $ambiente_vistoria_id);
                        }
                    }
                }

            }
        }


        // remove transfer directory
        FilePond\remove_transfer_directory(TRANSFER_DIR, $id);
    }
}

?>